## Qtd

Returns PeriodsToDate( Quarter_Level, Member ).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |zero-one | |



### Return

```
set
```



### Description

This function is strictly equivalent to: PeriodsToDate( Quarter_Level, Member ).

If no member is specified, then [Time].currentMember is used.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Qtd(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Strictly equivalent to: PeriodsToDate( [Time].[Calendar].[Quarter], member ).

In our example, returns the months of the third quarter of [2010] stopping at [Aug 2010]

**Query**

```
Qtd([Time].[Calendar].[Aug 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jul 2010], 
  [Time].[Calendar].[Month].[Aug 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
PeriodsToDate([Time].[Calendar].[Quarter],[Aug 2010])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Qtd()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Strictly equivalent to: PeriodsToDate([Time].[Calendar].[Quarter],[Time].currentMember).

**Query**

```
WITH
    MEMBER period_names AS GENERATE( Qtd() as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">period_names</td>
</tr>
<tr>
 <td>Jul 2010-Aug 2010</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER period_names AS GENERATE( Qtd( [Time].[Calendar].currentMember ) as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Aug 2010]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Qtd(member) - non time dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

The function works only with time dimensions.

**Query**

```
Qtd([Geography].[Geo].[Spain].firstChild)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

unexpected hierarchy (expected:'[Time].[Calendar]') (actual:'[Geography].[Geo]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Qtd(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set.

**Query**

```
Qtd(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
PeriodsToDate([Time].[Calendar].[Quarter],NULL)
```


 
</div>

                                                                         

### See Also


[PeriodsToDate](PeriodsToDate.md)

[Wtd](Wtd.md)

[Mtd](Mtd.md)

[Ytd](Ytd.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
