## Percentile

Returns the percentile value of the specified set expression


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |value-expression |one | |
| |numeric-expression |one | |



### Return

```
value
```



### Description

The percentile function calculates the percentile value of the non-empty values ([Wikipedia](https://en.wikipedia.org/wiki/Percentile)).

The parameters use a range from 0 to 100.0 where the corresponding value for 50.0 is the median value.

Percentile ( [Countries], [Sales Amount], 50.0 )    ; same as the Median

And it is also equivalent than using a function on a Vector :

Vector( [Countries], [Sales Amount], EXCLUDEEMPTY)->percentile( 50 )



### Since Version

6.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Percentile(set,20)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the Percentile value of the set expression.

**Query**

```
Percentile( [Geography].[Country], [Measures].[Amount], 20 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>3.0</td></tr></table>


**Assertion : Cell Equals**

```
Vector( [Geography].[Country], [Measures].[Amount], EXCLUDEEMPTY)->percentile(20)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Percentile(set,50) - same as Median

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the Percentile value of the set expression.

The set has an odd number of items; after sorting, the item in the middle is returned.

**Query**

```
Percentile( [Geography].[Country], [Measures].[Amount], 50 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>126.0</td></tr></table>


**Assertion : Cell Equals**

```
Median( [Geography].[Country], [Measures].[Amount])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Percentile(set) - empty values

</div>

<div class="ic3-mdx-example-body" style="display:none">

Empty members are removed from the set.

In our example, the function ignores the [Empty] member giving the same result as applying it to the three first members.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
    MEMBER [Geography].[Geo].[5]     AS 5.0
    MEMBER [Geography].[Geo].[Empty] AS Null

    MEMBER [Measures].[Percentile Amount] AS Percentile( {[Geography].[Geo].[5],[Geography].[Geo].[1], [Geography].[Geo].[Empty], [Geography].[Geo].[3]}, [Measures].[Amount], 50.0 )

SELECT
    [Measures].[Percentile Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Percentile Amount</td>
</tr>
<tr>
 <td>3.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Percentile Amount] AS 3.0
SELECT
    [Measures].[Percentile Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Percentile(NULL), Percentile({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty cell if applied to an empty set or a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[Percentile Amount] AS Percentile( null, 1, 50 )
SELECT
    [Measures].[Percentile Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Percentile Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Percentile Amount] AS Percentile({}, 2, 90)
SELECT
    [Measures].[Percentile Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Percentile Amount] AS null
SELECT
    [Measures].[Percentile Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Median](Median.md)

[Avg](Avg.md)

[Min](Min.md)

[Max](Max.md)

[Sum](Sum.md)

[Vector](Vector.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
