## PercN

Returns the percentage of first parameter by the second one, empty if ANY of the parameters is empty or null or the second is equal to 0.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |numeric-expression |one | |
| |numeric-expression |one | |
| |numeric-expression |zero-one | |



### Return

```
numeric-value
```



### Description

This functions returns the percentage of first parameter by the second one.

PercN(A,B) = A / B - 1 ; empty if A or B are null/empty or B is equal to 0.

It will return the third parameter instead of null if the third parameter is defined (like a CoalesceEmpty).



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PercN(A,B)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns A / B - 1

**Query**

```
WITH
    MEMBER [percN] AS percN( ([Amount],[Geography].[Spain]) , ([Amount],[Geography].[France]) )
SELECT
    [percN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">percN</td>
</tr>
<tr>
 <td>-0.25</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [percN] AS ([Amount],[Geography].[Spain]) / ([Amount],[Geography].[France])-1
SELECT
    [percN] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PercN(A,B) - empty case

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns empty if one of the parameters is empty or the second one is equal to 0.0

**Query**

```
WITH
    MEMBER [percN] AS percN( ([Amount],[Geography].[Spain]) , ([Amount],[Geography].[France],[Time].[2011]) )
SELECT
    [percN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">percN</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [percN] AS NULL
SELECT
    [percN] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [percN] AS percN( ([Amount],[Geography].[Spain]) , 0.0 )
SELECT
    [percN] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [percN] AS percN( ([Amount],[Geography].[Spain]) , NULL )
SELECT
    [percN] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PercN(A,B,0.0) - empty case with third parameter

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the third parameter if one of the parameters is empty or the second one is equal to 0.0.

**Query**

```
WITH
    MEMBER [percN] AS percN( 2.0 , NULL, 0.0 )
SELECT
    [percN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">percN</td>
</tr>
<tr>
 <td>0.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [percN] AS CoalesceEmpty( percN( 2.0 , NULL), 0.0 )
SELECT
    [percN] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[AddN](AddN.md)

[MinusN](MinusN.md)

[DivN](DivN.md)

[CoalesceEmpty](CoalesceEmpty.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
