## PatternMatchesStartsWith

Tells whether or not a string starts with the pattern expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |pattern |one | |
| |string |one | |
| |CASE_SENSITIVE-CASE_INSENSITIVE |zero-one |CASE_SENSITIVE |



### Return

```
boolean
```



### Description

Tells whether or not a string starts with the pattern expression.

The option `CASE_SENSITIVE|CASE_INSENSITIVE` is defaulted to CASE_SENSITIVE.

Returns false if the regexp or the string parameter is null.



### Since Version

8.0.0-rc.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Case Sensitive: match

</div>

<div class="ic3-mdx-example-body" style="display:none">

A example checking the string expression starts with the "Par" pattern.
The default behavior is case-sensitive.

**Query**

```
PatternMatchesStartsWith( "Par", "Paris" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


**Assertion : MDX Equals**

```
PatternMatches( "^Par.*", "Paris" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Case Sensitive: no match

</div>

<div class="ic3-mdx-example-body" style="display:none">

A simple example checking the string expression starts with the "PAR" pattern.
The default behavior is case-sensitive.

**Query**

```
PatternMatchesStartsWith( "PAR", "Paris" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
false
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Case Insensitive: match

</div>

<div class="ic3-mdx-example-body" style="display:none">

A example checking the string expression starts with the "PAR" pattern.

**Query**

```
PatternMatchesStartsWith( "PAR", "Paris", CASE_INSENSITIVE )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


**Assertion : MDX Equals**

```
PatternMatches( "(?i)^PAR.*", "Paris" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Escape

</div>

<div class="ic3-mdx-example-body" style="display:none">

A example searching for the " character. Notice how the character is being escaped (doubling it) in the pattern expression

**Query**

```
PatternMatchesStartsWith( """2020""", '"2020" Phones')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


 
</div>

                                                                                                            

### See Also


[PatternMatchesEndsWith](PatternMatchesEndsWith.md)

[PatternMatchesContains](PatternMatchesContains.md)

[PatternMatchesEquals](PatternMatchesEquals.md)

[PatternMatches](PatternMatches.md)

[Filter](Filter.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
