## PatternMatchesEquals

Tells whether or not a string equals the pattern expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |pattern |one | |
| |string |one | |
| |CASE_SENSITIVE-CASE_INSENSITIVE |zero-one |CASE_SENSITIVE |



### Return

```
boolean
```



### Description

Tells whether or not a string equals the pattern expression.

The option `CASE_SENSITIVE|CASE_INSENSITIVE` is defaulted to CASE_SENSITIVE.

Returns false if the regexp or the string parameter is null.



### Since Version

8.0.0-rc.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Case Sensitive: match

</div>

<div class="ic3-mdx-example-body" style="display:none">

A example checking the string expression equals the "Paris" pattern.
The default behavior is case-sensitive.

**Query**

```
PatternMatchesContains( "Paris", "Paris" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


**Assertion : MDX Equals**

```
PatternMatches( "^Paris$", "Paris" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Case Sensitive: no match

</div>

<div class="ic3-mdx-example-body" style="display:none">

A simple example checking the string expression equals the "PARIS" pattern.
The default behavior is case-sensitive.

**Query**

```
PatternMatchesContains( "PARIS", "Paris" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
false
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Case Insensitive: match

</div>

<div class="ic3-mdx-example-body" style="display:none">

A example checking the string expression equals the "PARIS" pattern.

**Query**

```
PatternMatchesContains( "PARIS", "Paris", CASE_INSENSITIVE )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


**Assertion : MDX Equals**

```
PatternMatches( "(?i)^PARIS$", "Paris" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Escape

</div>

<div class="ic3-mdx-example-body" style="display:none">

A example searching for the " character. Notice how the character is being escaped (doubling it) in the pattern expression

**Query**

```
PatternMatchesContains( """2020""", 'Phones ("2020")')
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


 
</div>

                                                                                                            

### See Also


[PatternMatchesStartsWith](PatternMatchesStartsWith.md)

[PatternMatchesEndsWith](PatternMatchesEndsWith.md)

[PatternMatchesContains](PatternMatchesContains.md)

[PatternMatches](PatternMatches.md)

[Filter](Filter.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
