## PatternMatches

Tells whether or not a string matches the given regular expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |regexp |one | |
| |string |one | |



### Return

```
boolean
```



### Description

Determines whether a string matches the given regular expression.

This is mainly a wrapper of the Java [matches](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/lang/String.html#matches%28java.lang.String%29) function.

Returns false if the regexp or the string parameter is null.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Contains

</div>

<div class="ic3-mdx-example-body" style="display:none">

A simple example checking the string expression contains the "ar" pattern.

**Query**

```
PatternMatches( ".*ar.*", "Paris" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


**Assertion : MDX Equals**

```
Contains( "Paris", "ar" )
```


 
</div>

                                                                                                            

### See Also


[PatternMatchesStartsWith](PatternMatchesStartsWith.md)

[PatternMatchesEndsWith](PatternMatchesEndsWith.md)

[PatternMatchesContains](PatternMatchesContains.md)

[PatternMatchesEquals](PatternMatchesEquals.md)

[Filter](Filter.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
