## ParallelPeriod

Returns a member from a previous/next period with the same position in the level as the specified member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |level-expression |zero-one | |
| |numeric-expression |zero-one |1 |
| |member-expression |zero-one | |



### Return

```
member
```



### Description

This function finds the parallel member of the specified member.

1) If only the level-expression is specified, the function will use the level's hierarchy default member implicitly.

2) If no numeric-expression is specified, 1 will be used as default.

Note that the numeric-expression can be positive or negative. Positive numbers will navigate to previous members, negative to next members.

It is equivalent to Cousin( Member, Ancestor(Member,Level).Lag(Numeric Expression) ).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,numeric,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the parallel period for the member. It's equivalent to Cousin(Member,Ancestor(Member,Level).Lag(Numeric Expression))

In our example, returns [Jan 2010] which is also Cousin( [Jan 2011], [2010] )

**Query**

```
ParallelPeriod( [Time].[Calendar].[Year], 1, [Time].[Jan 2011] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[Jan 2010]
```


**Assertion : MDX Equals**

```
Cousin( [Time].[Jan 2011], Ancestor([Time].[Jan 2011],[Time].[Calendar].[Year]).Lag(1) )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If no member is specified the default member of the level hierarchy is used.

In our example, [2010] year is default.

**Query**

```
ParallelPeriod( [Time].[Calendar].[Year], -1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Year].[2011]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
ParallelPeriod( [Time].[Calendar].[Year], -1, [Time].[2010] )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,numeric) - non time dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

ParallelPeriod can also be applied to non-time dimensions.

**Query**

```
ParallelPeriod([Geography].[Geo].[Country],1,[Geography].[Geo].[Mexico])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Cousin([Geography].[Geo].[Mexico],Ancestor([Geography].[Geo].[Mexico],[Geography].[Geo].[Country]).Lag(1))
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,numeric,member) - negative numeric

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the numeric expression is negative, ParallelPeriod will return the next members instead of the previous ones.

Equivalent to Cousin( member, Ancestor(member,level).lead( numeric as positive) ).

**Query**

```
ParallelPeriod([Time].[Calendar].[Year],-1,[Time].[Calendar].[Jan 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2011]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Cousin([Time].[Calendar].[Jan 2011],Ancestor([Time].[Calendar].[Jan 2010],[Time].[Calendar].[Year]).Lead(1))
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,numeric,member) - outside bounds

</div>

<div class="ic3-mdx-example-body" style="display:none">

If there is no matching member (e.g., the numeric expression is too large), a null entity is returned.

**Query**

```
ParallelPeriod([Time].[Calendar].[Year],200,[Time].[Calendar].[Jan 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,0,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the specified member if the numeric expression is equal to 0.

**Query**

```
ParallelPeriod([Time].[Calendar].[Year],0,[Time].[Aug 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Aug 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[Aug 2010]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the default time hierarchy's current member.

In our case [Jan 2011] year is current member in the the [Time] dimension.

**Query**

```
WITH
    MEMBER period_names AS GENERATE( ParallelPeriod() as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Jan 2011]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">period_names</td>
</tr>
<tr>
 <td>Jan 2011</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER period_names AS [Time].[Calendar].[Jan 2011].name
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Jan 2011]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod() - time's current member is a root

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the time current member is a root member. This function returns NULL.

**Query**

```
WITH
    MEMBER period_names AS ParallelPeriod() IS NULL
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[2011]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">period_names</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Visual Equals**

```
WITH
    MEMBER period_names AS True
SELECT
    period_names ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(NULL,numeric,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
ParallelPeriod(NULL,2,[Time].[Calendar].[Year].[2011])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ParallelPeriod() : argument (0) type mismatch: expected:'level', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,numeric,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
ParallelPeriod([Time].[Calendar].[Month],2,NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,numeric,member) - non time member

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
ParallelPeriod([Time].[Calendar].[Month],2,[Geography].[Geo].[Paris])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

ParallelPeriod() : unexpected hierarchy (expected:'[Time].[Calendar]') (actual:'[Geography].[Geo]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ParallelPeriod(level,string,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
ParallelPeriod([Time].[Year],"hello",[Time].[Aug 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ParallelPeriod() : argument (1) type mismatch: expected:'numeric', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Ancestor](Ancestor.md)

[Cousin](Cousin.md)

[Lag](Lag.md)

[OpeningPeriod](OpeningPeriod.md)

[ClosingPeriod](ClosingPeriod.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
