## Ordinal

Returns of ordinal (aka. depth) of the level.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |level-expression |one | |



### Return

```
level
```



### Description

Returns of ordinal (aka. depth) of the level: it is zero-based.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Level.ordinal

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the ordinal of the 'Country' level (levels are : All, Continent, Country, City).

**Query**

```
WITH
    MEMBER [Country Ordinal] AS [Geography].[Geo].[Country].ordinal
SELECT
    [Country Ordinal] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Country Ordinal</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Country Ordinal] AS [Geography].[Geo].Levels( [Geography].[Geo].[Country].ordinal ).ordinal
SELECT
    [Country Ordinal] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Levels](Levels.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
