## OpeningPeriod

Returns the first sibling for the specified level. Optionally, a member can be specified for the search.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |level-expression |zero-one | |
| |member-expression |zero-one | |



### Return

```
member
```



### Description

This function finds the first sibling from descendants of the specified member at the specified level.

1) If no parameters were specified, the function will use implicitly time dimension current member and its next level.

2) If only a level was specified, the function will use default member implicitly.

The same result can be achieved with TopCount(Descendants(Member_Expression, Level_Expression), 1) MDX statement.

The function is primary intended to be used with time dimensions but is not limited to time dimensions.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod(level,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member of the descendants of the specified member at the specified level.

In our example the first month of [2010] year.

**Query**

```
OpeningPeriod([Time].[Calendar].[Month],[Time].[Calendar].[Year].[2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Head(Descendants([Time].[Calendar].[Year].[2010], [Time].[Calendar].[Month]), 1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member of the default member of level's hierarchy at the specified level.

The function behaves as OpeningPeriod([Time].[Calendar].[Month],[Time].[Calendar].[Year].defaultMember)

**Query**

```
OpeningPeriod([Time].[Calendar].[Month])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Jan 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Head(Descendants([Time].[Calendar].[Year].[2010], [Time].[Calendar].[Month]), 1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod()

</div>

<div class="ic3-mdx-example-body" style="display:none">

If no parameter is specified:
- the member is the current member of the time dimension.
- the level is the level of the former member + 1

The function behaves as OpeningPeriod([Time].[Calendar].DefaultMember.level,[Time].[Calendar].DefaultMember)

**Query**

```
WITH
    MEMBER OpeningName as OpeningPeriod().NAME
SELECT
    OpeningName on 0, [Time].[Calendar].[Year].members on 1
FROM
    Sales
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">OpeningName</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">2010</td>
 <td>Q1 2010</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">2011</td>
 <td>Q1 2011</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER OpeningName as OpeningPeriod([Time].[Calendar].CurrentMember.firstChild.level,[Time].[Calendar].CurrentMember).NAME
SELECT
    OpeningName on 0, [Time].[Calendar].[Year].members on 1
FROM
    Sales
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod(level,member) - non-time dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

OpeningPeriod can be applied to non-time dimensions. It returns the last sibling among the descendants of the specified member for the specified level.

**Query**

```
OpeningPeriod([Geography].[Geo].[City],[Geography].[Geo].[Spain])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Barcelona]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Spain].FirstChild
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod(level,member) - level is ancestor

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the level is of lower depth than the member.

**Query**

```
OpeningPeriod( [Geography].[Geo].[Continent], [Geography].[Geo].[Spain] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod(NULL,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The level cannot be null.

**Query**

```
OpeningPeriod(NULL,[Time].[Calendar].[Year].[2011])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

OpeningPeriod() : argument (0) type mismatch: expected:'level', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod(level,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

NULL has no opening period.

**Query**

```
OpeningPeriod([Time].[Calendar].[Month],NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### OpeningPeriod(level,member) - non time member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to different hierarchies generates an error.

**Query**

```
OpeningPeriod([Time].[Calendar].[Month],[Geography].[Geo].[Paris])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

unexpected hierarchy (expected:'[Time].[Calendar]') (actual:'[Geography].[Geo]')</td></tr></table>


 
</div>

                                                                         

### See Also


[ClosingPeriod](ClosingPeriod.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
