## NonEmptyX

Return the list of tuples removing all tuples that are empty based on the indexing of the measure


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |measure |one | |
|limit |value-expression |zero-one | |



### Return

```
set
```



### Description

This is a very fast version of pseudo - nonempty. It's worth using when applied to a huge crossjoin.

- NonEmpty is based in the indexing structure, not in fact values. Only if the measure as no NULL values in facts it will return the same result as a nonempty.
- Set has to be a crossjoin.
- Set is materialized, pay attention of the resulting size.
- If possible, a multithreaded version is used.

The third parameter, optional, limits the number of returned tuples.



### Since Version

6.8.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmptyX(tuple_set, measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all set members that are non-empty, facts indexing wise, from the tuple set.

In our example, this is equivalent to nonEmpty

**Query**

```
NonEmptyX([Geography].[Geo].members * [Time].[Calendar].members, [Measures].[Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 12 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 14 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 15 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 16 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 17 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 18 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 20 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 22 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 25 2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Day].[May 29 2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Day].[May 25 2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Day].[May 29 2010] ), 
  ( [Geography].[Geo].[Country].[United States], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[United States], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[Country].[United States], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[Country].[United States], [Time].[Calendar].[Day].[May 25 2010] ), 
  ( [Geography].[Geo].[Country].[United States], [Time].[Calendar].[Day].[May 29 2010] ), 
  ( [Geography].[Geo].[City].[New York], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[City].[New York], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[City].[New York], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[City].[New York], [Time].[Calendar].[Day].[May 25 2010] ), 
  ( [Geography].[Geo].[City].[New York], [Time].[Calendar].[Day].[May 29 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 12 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 14 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 15 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 16 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 17 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 18 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 20 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Day].[May 22 2010] ), 
  ( [Geography].[Geo].[Country].[France], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[France], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[Country].[France], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[Country].[France], [Time].[Calendar].[Day].[May 15 2010] ), 
  ( [Geography].[Geo].[City].[Paris], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[City].[Paris], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[City].[Paris], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[City].[Paris], [Time].[Calendar].[Day].[May 15 2010] ), 
  ( [Geography].[Geo].[Country].[Spain], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[Spain], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[Country].[Spain], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[Country].[Spain], [Time].[Calendar].[Day].[May 12 2010] ), 
  ( [Geography].[Geo].[Country].[Spain], [Time].[Calendar].[Day].[May 14 2010] ), 
  ( [Geography].[Geo].[City].[Barcelona], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[City].[Barcelona], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[City].[Barcelona], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[City].[Barcelona], [Time].[Calendar].[Day].[May 14 2010] ), 
  ( [Geography].[Geo].[City].[Madrid], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[City].[Madrid], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[City].[Madrid], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[City].[Madrid], [Time].[Calendar].[Day].[May 12 2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Day].[May 16 2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Day].[May 17 2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Day].[May 18 2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Day].[May 20 2010] ), 
  ( [Geography].[Geo].[Country].[Switzerland], [Time].[Calendar].[Day].[May 22 2010] ), 
  ( [Geography].[Geo].[City].[Geneva], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[City].[Geneva], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[City].[Geneva], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[City].[Geneva], [Time].[Calendar].[Day].[May 22 2010] ), 
  ( [Geography].[Geo].[City].[Lausanne], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[City].[Lausanne], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[City].[Lausanne], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[City].[Lausanne], [Time].[Calendar].[Day].[May 16 2010] ), 
  ( [Geography].[Geo].[City].[Lausanne], [Time].[Calendar].[Day].[May 17 2010] ), 
  ( [Geography].[Geo].[City].[Lausanne], [Time].[Calendar].[Day].[May 18 2010] ), 
  ( [Geography].[Geo].[City].[Zurich], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[City].[Zurich], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[City].[Zurich], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[City].[Zurich], [Time].[Calendar].[Day].[May 20 2010] )
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
NonEmpty([Geography].[Geo].members * [Time].[Calendar].members, [Measures].[Amount] )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmptyX(tuple_set, measure,limit)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first two set members that are non-empty, facts indexing wise, from the tuple set.

In our example, this is equivalent to nonEmpty

**Query**

```
NonEmptyX([Geography].[Geo].members * [Time].[Calendar].members, [Measures].[Amount],2 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[All Regions], [Time].[Calendar].[Quarter].[Q2 2010] )
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
NonEmpty([Geography].[Geo].members * [Time].[Calendar].members, [Measures].[Amount],2 )
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NonEmptyX(tuple_set, member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if the second parameter is not a measure

**Query**

```
NonEmptyX([Geography].[Geo].members * [Time].[Calendar].members, [Time].[Calendar].[2010] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

NonEmptyX() : argument (1) type mismatch: expected:'measure', got:'member'</td></tr></table>


 
</div>

                                                                         

### See Also


[NonEmpty](NonEmpty.md)

[NonEmptyMembers](NonEmptyMembers.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
