## Name

Returns the name of a specified dimension, hierarchy, level, or member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |expression |one | |



### Return

```
string
```



### Description

Returns the name of a specified dimension, hierarchy, level, or member.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Name( member )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the name of the country [Spain]; this is equivalent as requesting the 'MEMBER_NAME' property.

**Query**

```
WITH
    MEMBER [Spain Name] AS [Geography].[Geo].[Spain].name
SELECT
    [Spain Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain Name</td>
</tr>
<tr>
 <td>Spain</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Spain Name] AS [Geography].[Geo].[Spain].Properties( 'MEMBER_NAME' )
SELECT
    [Spain Name] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[UniqueName](UniqueName.md)

[Caption](Caption.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
