## Mtd

Returns PeriodsToDate( Month_Level, Member ).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |zero-one | |



### Return

```
set
```



### Description

This function is strictly equivalent to: PeriodsToDate( Month_Level, Member ).

If no member is defined, then [Time].currentMember is used as member.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Mtd(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Strictly equivalent to: PeriodsToDate( [Time].[Calendar].[Month], member ).

In our example, returns the three first days of [Feb 2010].

**Query**

```
Mtd([Time].[Calendar].[February 3 2010])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Day].[February 1 2010], 
  [Time].[Calendar].[Day].[February 2 2010], 
  [Time].[Calendar].[Day].[February 3 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
PeriodsToDate([Time].[Calendar].[Month],[February 3 2010])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Mtd()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Strictly equivalent to: PeriodsToDate( [Time].[Calendar].[Month], [Time].currentMember ).

**Query**

```
WITH
    MEMBER period_names AS GENERATE( Mtd() as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[February 3 2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">period_names</td>
</tr>
<tr>
 <td>February 1 2010-February 2 2010-February 3 2010</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER period_names AS GENERATE( Mtd( [Time].[Calendar].currentMember ) as periods , periods.CurrentMember.Name, "-" )
SELECT
    period_names ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[February 3 2010]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Mtd(member) - non time dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

The function works only with time dimensions.

**Query**

```
Mtd([Geography].[Geo].[Spain].firstChild)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

unexpected hierarchy (expected:'[Time].[Calendar]') (actual:'[Geography].[Geo]')</td></tr></table>


 
</div>

                                                                         

### See Also


[PeriodsToDate](PeriodsToDate.md)

[Wtd](Wtd.md)

[Qtd](Qtd.md)

[Ytd](Ytd.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
