## Min

Returns the min value of the specified set expression.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |value-expression |zero-one | |



### Return

```
value
```



### Description

The min function calculates the min value of the non-empty cells.

1) A value expression is specified.

When the value expression is specified, the measure is evaluated over the set and its min value is returned.

2) A value expression is not specified.

If a value expression is not specified, the measure is taken from the current context.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Min(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the min value along the set.

Note that empty cells are ignored.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
    MEMBER [Geography].[Geo].[Empty] AS Null

    MEMBER [Measures].[Min Amount]   AS MIN( {[Geography].[Geo].[1],[Geography].[Geo].[3],[Geography].[Geo].[Empty]}, [Measures].[Amount] )
SELECT
    [Measures].[Min Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Min Amount</td>
</tr>
<tr>
 <td>1.0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Min Amount] AS 1.0
SELECT
    [Measures].[Min Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Min(NULL), Min({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty cell if applied to an empty set or a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[Min Amount] AS Min( null )
SELECT
    [Measures].[Min Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Min Amount</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Min Amount] AS Min({})
SELECT
    [Measures].[Min Amount] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Min Amount] AS null
SELECT
    [Measures].[Min Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[Avg](Avg.md)

[Max](Max.md)

[Median](Median.md)

[Percentile](Percentile.md)

[Sum](Sum.md)

[Vector](Vector.md)

[Java Functions](Java%20Functions.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
