## Members

Returns all members of the specified level, hierarchy or dimension.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-tuple-expression | | |



### Return

```
set
```



### Description

Returns members of the specified hierarchy, dimension or level. Members are returned in their natural order.

Note that this function (as most of the MDX functions) does not retrieve calculated members.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the members of the level in their natural order (i.e., hierarchized).

**Query**

```
[Geography].[Geo].[Country].Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Generate( [Geography].[Geo].[Continent].members, [Geography].[Geo].currentMember.children )
```


**Assertion : MDX Equals**

```
Hierarchize( [Geography].[Geo].[Country].members )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Members - natural order

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the members of the hierarchy in their natural order (i.e., hierarchized).

**Query**

```
[Geography].[Geo].Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions], 
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[Country].[Venezuela], 
  [Geography].[Geo].[City].[Caracas], 
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[City].[Geneva], 
  [Geography].[Geo].[City].[Lausanne], 
  [Geography].[Geo].[City].[Zurich]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
// This is the natural order :-)
{ [Geography].[Geo].[All Regions] } +
Generate( [Geography].[Geo].[Continent].members, [Geography].[Geo].currentMember + // continent
Generate( [Geography].[Geo].currentMember.children, [Geography].[Geo].currentMember + // country
[Geography].[Geo].currentMember.children)) // city
```


**Assertion : MDX Equals**

```
Hierarchize( [Geography].[Geo].members )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dimension.Members - dimension with single hierarchy

</div>

<div class="ic3-mdx-example-body" style="display:none">

Members on a dimension with a single hierarchy return the same as the method members on this single hierarchy

**Query**

```
[Measures].members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Measures].[Amount], 
  [Measures].[Amount-Min], 
  [Measures].[Amount-Max], 
  [Measures].[Amount-Count], 
  [Measures].[Amount-AvgChildren], 
  [Measures].[Amount-None], 
  [Measures].[Amount-Open], 
  [Measures].[Amount-Close], 
  [Measures].[Amount-OpenNoEmpty], 
  [Measures].[Amount-CloseNoEmpty], 
  [Measures].[Amount-AvgLeaves], 
  [Measures].[Amount-NoEmpty], 
  [Measures].[Amount-Unique], 
  [Measures].[Fx]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Measures].[Measures].members
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dimension.Members - dimension with multiple hierarchy

</div>

<div class="ic3-mdx-example-body" style="display:none">

Members method cannot be applied to a dimension with multiple hierarchies

**Query**

```
[Geography].Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY](icCubeError.md#olap_function_dimension_with_more_than_one_hierarchy)</td></tr><tr><td>Error Message</td><td>

Members() : the '[Geography]' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
[Geography].[Geo].[United States].Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Members() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'member'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Members() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Members() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Members() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
"hello".Members
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Members() : argument (0) type mismatch: expected:'level|hierarchy|dimension', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[AddCalculatedMembers](AddCalculatedMembers.md)

[AllMembers](AllMembers.md)

[Children](Children.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
