## MemberValue

Returns the value of the member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |



### Return

```
any
```



### Description

Returns the value of the key of the member or its name if there is not key or if the key is a multi-value key.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MemberValue(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the key of the member as a date value.

**Query**

```
WITH
    MEMBER [Measures].[Day] AS MemberValue(  [Calendar].[Calendar].[Day].[1 Jan 2016] )
SELECT
    [Measures].[Day] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Day</td>
</tr>
<tr>
 <td>2016-01-01</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Day] AS StringToDate( "2016-01-01", "yyyy-MM-dd" )
SELECT
    [Measures].[Day] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
