## MatrixN

Returns a Matrix.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|vector |vector-expression |one-n | |



### Return

```
value
```



### Description

This function creates a matrix object of numerical values (double). Two syntax might be used :

<pre>
- Matrix( Col-Vector, Col-Vector ... ) -> Vectors represent matrix columns.
</pre>

Once the matrix is created, you can call perform various operations on it :

<pre>
Matrix(...)->value(col,row) : returns the 0-based col,row element (note this is inverse as a regular matrix annotation Aij where i represents a row)
Matrix(...)->inverse()      : returns the inverse of the matrix (an error if it's a singular matrix)
Matrix(...)->solve(Vector)  : solves the algebraic equation (an error if it's a singular matrix)
</pre>

See this [page](../mdx_types/matrix.md) for all the available operations.



### Since Version

5.1.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixN( {vector} )  

</div>

<div class="ic3-mdx-example-body" style="display:none">

A matrix can be build as a list of vectors.

In our example two vectors.

**Query**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(2,3),VectorN(2,3) )->length()
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>4</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 4
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixN(..) - operator + 

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixN class support the + operator.

In this example, ( (1,2),(3,4) ) + 2 = ( (3,5),(5,6) )

**Query**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1,2), VectorN(3,4) )  + 2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[[3.0, 5.0], [4.0, 6.0]]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 2 + MatrixN( VectorN(1,2), VectorN(3,4) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1+2,2+2), VectorN(3+2,4+2) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixN(..) - operator -

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixN class support the + operator.

In this example, ( (1,2),(3,4) ) - 2 = ( (-1,0),(1,2) )

**Query**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1,2), VectorN(3,4) ) - 2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[[-1.0, 1.0], [0.0, 2.0]]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS (-2) + MatrixN( VectorN(1,2), VectorN(3,4) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1-2,2-2), VectorN(3-2,4-2) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixN(..) - operator *

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixN class support the + operator.

In this example, ( (1,2),(3,4) ) * 2 = ( (2,4),(6,8) )

**Query**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1,2), VectorN(3,4) )  * 2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[[2.0, 6.0], [4.0, 8.0]]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS 2 * MatrixN( VectorN(1,2), VectorN(3,4) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1*2,2*2), VectorN(3*2,4*2) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixN(..) - operator / 

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixN class support the / operator.

In this example, ( (1,2),(3,4) ) / 2 = ( (1/2,2/2),(3/2,4/2) )

**Query**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1,2), VectorN(3,4) ) /  2
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[[0.5, 1.5], [1.0, 2.0]]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1/2,2/2), VectorN(3/2,4/2) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### MatrixN(..) - operator * (Vector) 

</div>

<div class="ic3-mdx-example-body" style="display:none">

MatrixN class support the * operator with a vector

In this example, ( (11,12),(21,22) ) * (1,2) = ( 11*1 + 21*2, 12*1 + 22*2 )

**Query**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(11,12), VectorN(21,22) ) * VectorN(1,2)
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[53.0, 56.0]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS VectorN( 11*1 + 21*2, 12*1 + 22*2 )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Matrix](Matrix.md)

[MatrixA](MatrixA.md)

[Vector](Vector.md)

[VectorN](VectorN.md)

[VectorA](VectorA.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
