## Matrix

Returns a Matrix.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |two | |
|value |numeric-expression |one | |



### Return

```
value
```



### Description

This function creates a matrix object of numerical values (double). Two syntax might be used :

<pre>
- Matrix( {Column-Set}, {Row-Set}, [Measures].[Amount])
</pre>

Once the matrix is created, you can call perform various operations on it :

<pre>
Matrix(...)->value(col,row) : returns the 0-based col,row element (note this is inverse as a regular matrix annotation Aij where i represents a row)
Matrix(...)->inverse()      : returns the inverse of the matrix (an error if it's a singular matrix)
Matrix(...)->solve(Vector)  : solves the algebraic equation (an error if it's a singular matrix)
</pre>

See this [page](../mdx_types/matrix.md) for all the available operations.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Matrix(set,set,numeric) 

</div>

<div class="ic3-mdx-example-body" style="display:none">

A matrix can be build as a crossjoin of two sets. The numerical expression specified as parameter is applied to each tuple. The first set define the rows of the matrix, the second one the columns.

**Query**

```
WITH
    MEMBER [Measures].[val] AS Matrix({[Time].[Calendar].[2010],[Time].[Calendar].[2011]}, {[Geography].[Geo].[Switzerland],[Geography].[Geo].[France]}, [Measures].[Amount] )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">val</td>
</tr>
<tr>
 <td>[[248.0, 0.0], [4.0, 0.0]]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [col1] AS  VectorN( ([Geography].[Geo].[Switzerland],[Time].[Calendar].[2010],[Amount]), ([Geography].[Geo].[France],[Time].[Calendar].[2010],[Amount]) )
    MEMBER [col2] AS  VectorN( ([Geography].[Geo].[Switzerland],[Time].[Calendar].[2011],[Amount]), ([Geography].[Geo].[France],[Time].[Calendar].[2011],[Amount]) )
    MEMBER [Measures].[val] AS MatrixN( [col1].value(), [col2].value() )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Matrix - Inverse()

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example of matrix inversion.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS MatrixA( nonempty([Geography].[Geo].[Country],[Measures].[Amount]).tail(4), [Product].[Prod].[Licence].head(4), [Measures].[Amount] + 2.0 )->inverse()
SELECT
  [Measures].[matrix-a] on Axes
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Corporate</td>
  <td class="ic3-mdx-result-cell-header">Partnership</td>
  <td class="ic3-mdx-result-cell-header">Personal</td>
  <td class="ic3-mdx-result-cell-header">Startup</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>0.0013020833333333335</td>
 <td>-0.001953125</td>
 <td>5.767392335715099E-19</td>
 <td>6.510416666666651E-4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>0.003906250000000002</td>
 <td>-0.05794270833333328</td>
 <td>1.0000000000000002</td>
 <td>-2.4459635416666674</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>-0.005208333333333336</td>
 <td>0.0494791666666666</td>
 <td>-1.0000000000000004</td>
 <td>2.955729166666668</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>-0.0</td>
 <td>0.010416666666666666</td>
 <td>-0.0</td>
 <td>-0.010416666666666666</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Matrix - Inverse() II

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to show we're actually calculating the matrix inverse.

**Query**

```
WITH
  MEMBER [Measures].[matrix-a] AS Matrix( nonempty([Geography].[Geo].[Country],[Measures].[Amount]).tail(4), [Product].[Prod].[Licence].head(4), [Measures].[Amount] + 2.0 )
  MEMBER [Measures].[matrix-i] AS ([matrix-a]->inverse() * [matrix-a])->round(10)
SELECT
  [Measures].[matrix-i] on 0
FROM
  [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">matrix-i</td>
</tr>
<tr>
 <td>[[1.0, 0.0, 0.0, 0.0], [0.0, 1.0, 0.0, 0.0], [0.0, 0.0, 1.0, 0.0], [0.0, 0.0, 0.0, 1.0]]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[val] AS MatrixN( VectorN(1,0,0,0), VectorN(0,1,0,0), VectorN(0,0,1,0), VectorN(0,0,0,1) )
SELECT
    [Measures].[val] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[MatrixA](MatrixA.md)

[MatrixN](MatrixN.md)

[Vector](Vector.md)

[VectorA](VectorA.md)

[VectorN](VectorN.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
