## LookupByName

Returns the first member in a given level/hierarchy/member child matching the parameter name.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimension-hierarchy-level-member-expression |one | |
| |value-expression |one | |



### Return

```
member
```



### Description

The function returns the first member matching the name specified in the value expression. 
Note, the lookup is done on the name and not the caption that might be localized if the schema has
localization active. Same as when writing an MDX query.

It is similar to strToMember("Level-expression" + ".[" + value-expression + "]") function, but faster and not using localization.



### Since Version

7.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByName(level,name)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member in the specified level matching the specified member name.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
LookupByName([Geography].[Economy].[Country],"United States" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[United States]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Economy].[United States]
```


**Assertion : MDX Equals**

```
strToMember( "[Geography].[Economy].[" + [Geography].[Economy].[United States].name + "]" )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByName(member,name)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member in the members child's list matching the specified member name.

In our example, we return the [Paris].

**Query**

```
LookupByName([Geography].[Geo].[France], "Paris" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Paris]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByName(level,name) - member not found

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if there is no matching member in the specified level.

In our example, there is no member in level [Continent] with name '232'.

**Query**

```
LookupByName([Geography].[Continent], "232" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                                            

### See Also


[LookupByKey](LookupByKey.md)

[LinkMember](LinkMember.md)

[StrToMember](StrToMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
