## LookupByKeys

Returns a set of members in a given level/hierarchy/dimension matching the key parameters.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |STR_NUMBERS |zero-one | |
| |dimension-hierarchy-level-expression |one | |
| |scalar-expression |one-n | |



### Return

```
set-members
```



### Description

The function returns the members matching the keys specified in the scalar expressions. If the keys of the requested members are multi-values, then wrap each of them into a ListScalars (see example below).

The optional STR_NUMBERS parameter allows for defining the integer keys as a string for efficiency purpose. This might be handy when defining a large permissions script. The string must contain integer values separated by a comma and must not contain any space in between :

<pre>
    [Product].[Article].[Article].LookupByKeys( STR_NUMBERS, "1,2,3" )
</pre>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKeys( hierarchy, keys )

</div>

<div class="ic3-mdx-example-body" style="display:none">

This example is retrieving the members FRANCE and SPAIN from the [Geography].[Geo] hierarchy.

**Query**

```
LookupByKeys( [Geography].[Geo], "FR", "ES" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Geography].[Geo].[France], [Geography].[Geo].[Spain] }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LookupByKeys( hierarchy, multi-value keys )

</div>

<div class="ic3-mdx-example-body" style="display:none">

This example is retrieving the members FRANCE and SPAIN from the [Geography].[Geo] hierarchy. It is wrapping the keys into ListScalars() function calls to show you how to create multi-value keys (this is obviously not necessary in this example as the keys are single value).

**Query**

```
LookupByKeys( [Geography].[Geo], ListScalars("FR"), ListScalars("ES") )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Geography].[Geo].[France], [Geography].[Geo].[Spain] }
```


 
</div>

                                                                                                            

### See Also


[LookupByKey](LookupByKey.md)

[ListScalars](ListScalars.md)

[Zip](Zip.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
