## ListScalars

Wraps a list of scalar entities into a scalar entity that can be used by other functions.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |scalar-expression |one-n | |



### Return

```
list
```



### Description

The function wraps the scalar entities as specified in the scalar expressions into a scalar entity representing this list of entities. This list can then, for example be used as a parameter of the LookupByKeys function to represent a multi-value key (e.g., ListScalars( "Texas", "Paris" ), ListScalars( "France", "Paris" ).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ListScalars(...)

</div>

<div class="ic3-mdx-example-body" style="display:none">

This example is creating a multi-value key representing the city "Paris" in "Texas".

**Query**

```
ListScalars( "Paris", "Texas" )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>[Paris, Texas]</td></tr></table>


**Assertion : MDX Equals**

```
ListScalars( "Paris", "Texas" )
```


 
</div>

                                                                                                            

### See Also


[LookupByKeys](LookupByKeys.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
