## LinkMember

Returns a member of the specified hierarchy that is matching the specified member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
| |hierarchy-expression |one | |



### Return

```
member
```



### Description

The function returns the member (in the specified hierarchy) that has the same key as the specified member.

It is used within dimensions with several hierarchies.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinkMember(member,hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member in the new hierarchy matching the specified member key.

In our example, we return the [United States] of the hierarchy [Economy].

**Query**

```
LinkMember([Geography].[Country].[United States],[Geography].[Economy])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[United States]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Economy].[United States]
```


**Assertion : Cell Equals**

```
// LinkMember is using the member key in the 'new' hierarchy
StrToMember( '' + [Geography].[Economy].uniqueName + '.&[' + [Geography].[Country].[United States].PROPERTIES("KEY") + ']' )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinkMember(member,hierarchy) - member not found

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if there is no matching member in the specified hierarchy.

In our example, the level [Continent] does not exist in the [Economy] hierarchy.

**Query**

```
LinkMember([Geography].[Continent].[Europe],[Geography].[Economy])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinkMember(member,hierarchy) - different dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the member and the hierarchy are from a different dimension.

**Query**

```
LinkMember([Geography].[Country].[United States],[Time].[Calendar])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinkMember(NULL,hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns null when applied to a null member.

**Query**

```
LinkMember(null,[Geography].[Geo])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinkMember(member,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

The hierarchy must be specified.

**Query**

```
LinkMember([Geography].[Country].[Spain],null)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

LinkMember() : argument (1) type mismatch: expected:'hierarchy', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinkMember(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
LinkMember([Geography].[Country].[Spain])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

LinkMember() : unexpected number of parameters '1' (expected:'2,2')</td></tr></table>


 
</div>

                                                                         

### See Also


[CurrentMember](CurrentMember.md)

[LookupByKey](LookupByKey.md)

[LookupByName](LookupByName.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
