## LinRegPoint

Returns the y-intercept of the linear regression ( y -> a * slice + b )


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|slice value (x) |numeric-expression |one | |
| |set-expression |one | |
|y values |numeric-expression |one | |
|x values |numeric-expression |one | |



### Return

```
numeric-value
```



### Description

Returns the y-intercept of the linear regression using the least square estimator ([Wikipedia](http://en.wikipedia.org/wiki/Ordinary_least_squares)).

y = a * x + b , returns y = a * sliceValue + b



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinRegPoint

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the y-intercept of the linear regression

**Query**

```
LinRegPoint(3.3, [Geography].[Geo].[Country].members, 2 * [Amount], [Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>6.6</td></tr></table>


**Assertion : MDX Equals**

```
2.0 * 3.3 + 0.0
```


 
</div>

                                                                                                            

### See Also


[LinRegIntercept](LinRegIntercept.md)

[LinRegPoint](LinRegPoint.md)

[LinRegR2](LinRegR2.md)

[LinRegSlope](LinRegSlope.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
