## LinRegIntercept

Returns the interception of the linear regression (b -> y = a*x + b)


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
|y values |numeric-expression |one | |
|x values |numeric-expression |one | |



### Return

```
numeric-value
```



### Description

Returns the interception point of the linear regression using the least square estimator ([Wikipedia](http://en.wikipedia.org/wiki/Ordinary_least_squares)).

y = a * x + b , returns b == interception



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LinRegIntercept

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the interception point of the linear regression

**Query**

```
LinRegIntercept( [Geography].[Geo].[Country].members, 2*[Amount], [Amount] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>0.0</td></tr></table>


**Assertion : MDX Equals**

```
0.0
```


 
</div>

                                                                                                            

### See Also


[LinRegIntercept](LinRegIntercept.md)

[LinRegPoint](LinRegPoint.md)

[LinRegR2](LinRegR2.md)

[LinRegSlope](LinRegSlope.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
