## Levels

Lookup a level by name or ordinal within its hierarchy.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-numeric-expression |one | |



### Return

```
level
```



### Description

Lookup a level by name or ordinal (aka. depth) within its hierarchy.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Levels( ordinal )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first level of the geography hierarchy (note how the numerical parameter is zero-based).

**Query**

```
WITH
    MEMBER [level-name] AS [Geography].[Geo].Levels(0).uniqueName
SELECT
    [level-name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">level-name</td>
</tr>
<tr>
 <td>[Geography].[Geo].[__All-Level]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [level-name] AS [Geography].[Geo].[All].level.uniqueName
SELECT
    [level-name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Levels( name )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the 'Country' level of the geography hierarchy.

**Query**

```
WITH
    MEMBER [level-name] AS [Geography].[Geo].Levels( 'Country' ).uniqueName
SELECT
    [level-name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">level-name</td>
</tr>
<tr>
 <td>[Geography].[Geo].[Country]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [level-name] AS [Geography].[Geo].[Spain].level.uniqueName
SELECT
    [level-name] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Level](Level.md)

[FirstNotAllLevel](FirstNotAllLevel.md)

[LastLevel](LastLevel.md)

[Ordinal](Ordinal.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
