## Lead

Returns the member that is at the specified number of positions after the specified member along its level.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |numeric-expression |one | |



### Return

```
member
```



### Description

This function allows for 'traveling' forwards in the members' level hierarchy member's list.

The following holds true : Lead(1) = nextMember = Lead(-1).

If the number of specified position is out of bounds, the function returns the null member.

Equivalent to lag(-index)



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Lead(index)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the next member from the level members list. Same as lag(-index).

In our example, return the second member of the [Continent] level.

**Query**

```
[Geography].[Geo].[Continent].members(0).Lead(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].members(0).NextMember
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].members(0).lag(-1)
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].members(0 + 1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Lead(-2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the number of position is negative, returns a previous member from the level members list.

In our example, return the second member of the [Country] level.

**Query**

```
[Geography].[Geo].[Country].members(3).Lead(-2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Mexico]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].members(3 + (-2))
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].members(3).Lag(+2)
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].members(3 - 2)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Lead(index) - out of bounds

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a NULL member if the resulting index is out of bounds. Less than zero or greater than the level number of members.

**Query**

```
[Geography].[Geo].[Continent].[America].Lead(1024)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].[America].Lead(-1024)
```


**Assertion : MDX Equals**

```
NULL.Lead(1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Lead(index)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Equivalent [Hierarchy].DefaultMember.Lead(index).

**Query**

```
[Geography].[Geo].Lead(0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].DefaultMember
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dimension.Lead - dimension with multiple hierarchies

</div>

<div class="ic3-mdx-example-body" style="display:none">

Lead cannot be applied to a dimension with multiple hierarchies.

**Query**

```
[Geography].Lead(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY](icCubeError.md#olap_function_dimension_with_more_than_one_hierarchy)</td></tr><tr><td>Error Message</td><td>

Lead() : the '[Geography]' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.Lead

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).Lead(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lead() : argument (0) type mismatch: expected:'member', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.Lead

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
[Geography].[Geo].[Continent].Lead(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lead() : argument (0) type mismatch: expected:'member', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.Lead

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.Lead(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lead() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.Lead

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.Lead(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lead() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.Lead

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using invalid parameter type causes an error.

**Query**

```
"hello".Lead(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lead() : argument (0) type mismatch: expected:'member', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Lag](Lag.md)

[PrevMember](PrevMember.md)

[NextMember](NextMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
