## LastLevel

Returns the last level of a hierarchy


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |hierarchy-expression |one | |



### Return

```
level
```



### Description

Returns the last level of the hierarchy.

It is a shortcut for : 'Hierarchy'.levels( count('Hierarchy'.levels()) -1 )



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LastLevel(hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the last level of the hierarchy.

In our example, [Geo].[City] as it's the last level of [Geo] hierarchy

**Query**

```
LastLevel([Geography].[Geo])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[City].[Caracas], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[City].[Geneva], 
  [Geography].[Geo].[City].[Lausanne], 
  [Geography].[Geo].[City].[Zurich]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[City]
```


**Assertion : MDX Equals**

```
[Geography].[Geo].levels( count([Geography].[Geo].levels()) -1 )
```


**Assertion : Cell Equals**

```
[Geography].[Geo].lastLevel()
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### LastLevel(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if applied to a NULL entity.

**Query**

```
LastLevel(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                         

### See Also


[FirstNotAllLevel](FirstNotAllLevel.md)

[Levels](Levels.md)

[Level](Level.md)

[Count](Count.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
