## Lag

Returns the member that is at the specified number of positions before the specified member along its level.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |numeric-expression |one | |



### Return

```
member
```



### Description

This function allows for 'traveling' backwards in the members' level hierarchy member's list.

The following holds true : Lag(1) = prevMember = Lead(-1).

If the number of specified position is out of bounds, the function returns the null member.

Equivalent to lead(-index)



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Lag(index)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a previous member from the level members list. Same as lead(-index).

In our example, return the first member of the [Continent] level.

**Query**

```
[Geography].[Geo].[Continent].members(1).lag(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].members(1).PrevMember
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].members(1).lead(-1)
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].members(1 - 1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Lag(-1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the number of position is negative, returns a next member from the level members list.

In our example, return the third member of the [Country] level.

**Query**

```
[Geography].[Geo].[Country].members(0).Lag(-3)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].members(0 - (-3))
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Country].members(0).lead(3)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### member.Lag(index) - out of bounds

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a NULL member if the number of positions is out of bounds. Less than zero or greater than the level number of members.

**Query**

```
[Geography].[Geo].[Continent].[America].Lag(1024)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Continent].[America].Lag(-1024)
```


**Assertion : MDX Equals**

```
NULL.Lag(1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Lag(index)

</div>

<div class="ic3-mdx-example-body" style="display:none">

That is equivalent to [Hierarchy].DefaultMember.Lag(index)

**Query**

```
[Geography].[Geo].Lag(0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].DefaultMember
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### dimension.Lag(index) - dimension with multiple hierarchies

</div>

<div class="ic3-mdx-example-body" style="display:none">

Lag cannot be applied to a dimension with multiple hierarchies

**Query**

```
[Geography].Lag(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_DIMENSION_WITH_MORE_THAN_ONE_HIERARCHY](icCubeError.md#olap_function_dimension_with_more_than_one_hierarchy)</td></tr><tr><td>Error Message</td><td>

Lag() : the '[Geography]' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.Lag

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).Lag(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lag() : argument (0) type mismatch: expected:'member', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.Lag

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
[Geography].[Geo].[Continent].Lag(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lag() : argument (0) type mismatch: expected:'member', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.Lag

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.Lag(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lag() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.Lag

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.Lag(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lag() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.Lag

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
"hello".Lag(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Lag() : argument (0) type mismatch: expected:'member', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Lead](Lead.md)

[PrevMember](PrevMember.md)

[NextMember](NextMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
