## Item

Returns a tuple from a set (or a member from a tuple).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |one | |



### Return

```
set
```



### Description

Returns the tuple that is in the zero-based position specified by the numeric-expression. The () operator notation can be used as well : { [Years].[2001] }(0) = Item( { [Years].[2001] }, 0 ). Note that calling item against a tuple expression instead of a set is returning the member at the specified position in the tuple.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Item(set,index)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the tuple that is in the zero-based position specified by the index expression.

**Query**

```
Item( { [Geography].[Geo].[America], [Geography].[Geo].[Europe] }, 1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Europe]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Item(set,index) - () notation

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the tuple that is in the zero-based position specified by the index expression using the () notation.

**Query**

```
{ [Geography].[Geo].[America], [Geography].[Geo].[Europe] }( 1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Item( { [Geography].[Geo].[America], [Geography].[Geo].[Europe] }, 1 )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Item(tuple,index)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member that is in the zero-based position specified by the index expression.

**Query**

```
( [Geography].[Economy].[Country].[Switzerland], [Time].[Calendar].[2010] )(1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Year].[2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Time].[Calendar].[2010]
```


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
