## IsUnknown

Returns true if the member is a created unknown member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member |member-expression |one | |



### Return

```
boolean
```



### Description

The function returns true if the member is a created unknown member.

If the member is an existing member used as unknown member for facts it will return false

If the parameter is not a MDX member this function will return false.



### Since Version

5.0


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsUnknown(member) - false

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if the member is not the unknown member.

**Query**

```
isUnknown([Geography].[Geo].defaultmember)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
false
```


**Assertion : MDX Equals**

```
[Geography].[Geo].defaultmember.isUnknown
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsDefault(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if the parameter is not a member.

**Query**

```
IsUnknown(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
FALSE
```


**Assertion : MDX Equals**

```
IsUnknown(2.3)
```


**Assertion : MDX Equals**

```
IsUnknown([Geography].[Geo].members)
```


 
</div>

                                                                         

### See Also


[IsAll](IsAll.md)

[IsDefault](IsDefault.md)

[IsLeaf](IsLeaf.md)

[UnknownMembers](UnknownMembers.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
