## IsSibling

Returns true if the both members are siblings (i.e., have the same parent).


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
| |member-expression |one | |



### Return

```
boolean
```



### Description

Returns TRUE if the specified members are siblings, FALSE otherwise.

Note that root (i.e., with no parent) members are siblings.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(member,member) - same parent

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if the two members are siblings (i.e., have the same parent).

In our example, returns true as [Geneva] and [Zurich] are siblings (i.e., same parent [Switzerland]).

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS IsSibling( [Geography].[Geneva], [Geography].[Zurich] )
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isSibling] AS TRUE
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(member,member) - different parents

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if the two members are not siblings (they have different parent).

In our example, returns false as [Geneva] and [Paris] are not siblings: different parents ([Switzerland] and [France]).

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS IsSibling( [Geography].[Geneva], [Geography].[Paris] )
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isSibling] AS FALSE
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(member,member) - root members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if both members are root members (they have no parent).

In our example, returns true as [2010] is a sibling of [2011]: both root members.

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS IsSibling( [Time].[Calendar].[2010], [Time].[Calendar].[2011] )
SELECT
    [Measures].[isSibling] ON 0
FROM 
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isSibling] AS TRUE
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(member,NULL), isSibling(NULL,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

NULL is not an sibling of any member.

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS false
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling( [Geography].[Geo].[Paris], NULL)
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling( NULL, [Geography].[Geo].[Paris])
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling( NULL, NULL )
SELECT
    [Measures].[isSibling] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(tuple,tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal]))

SELECT
    [Measures].[isSibling] ON 0

FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsSibling() : argument (0) type mismatch: expected:'member', got:'tuple'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(level,level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling([Geography].[Geo].[Continent],[Geography].[Geo].[Continent])

SELECT
    [Measures].[isSibling] ON 0

FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsSibling() : argument (0) type mismatch: expected:'member', got:'level'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(memberSet,memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]},{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]})

SELECT
    [Measures].[isSibling] ON 0

FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsSibling() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(tupleSet,tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])},{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})

SELECT
    [Measures].[isSibling] ON 0

FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsSibling() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isSibling(string,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[isSibling] AS isSibling("hello","hello")

SELECT
    [Measures].[isSibling] ON 0

FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isSibling</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsSibling() : argument (0) type mismatch: expected:'member', got:'string'</pre>


 
</div>

                                                                         

### See Also


[FirstSibling](FirstSibling.md)

[LastSibling](LastSibling.md)

[IsAncestor](IsAncestor.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
