## IsLeaf

Returns true if the specified member is a leaf member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member |member-expression |one | |



### Return

```
boolean
```



### Description

The function returns TRUE if the specified member is a leaf member (i.e., has no child), FALSE otherwise.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if the member is a leaf (i.e., no child).

In our example, returns true as [Zurich] has no children.

**Query**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS isLeaf([Geography].[Geo].[Zurich])
SELECT
    [Measures].[IS_LEAF] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS true
SELECT
    [Measures].[IS_LEAF] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS IIF( [Geography].[Geo].[Zurich].children.count = 0, true, false )
SELECT
    [Measures].[IS_LEAF] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(member) - not a leaf

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false for no leaf members.

In our example, return false for [Switzerland] as it is not a leaf member (i.e., has several cities as children).

**Query**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS isLeaf([Geography].[Geo].[Switzerland])
SELECT
    [Measures].[IS_LEAF] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS false
SELECT
    [Measures].[IS_LEAF] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS IIF( [Geography].[Geo].[Switzerland].children.count = 0, true, false )
SELECT
    [Measures].[IS_LEAF] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS isLeaf( null )
SELECT
    [Measures].[IS_LEAF] ON 0

FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_LEAF] AS FALSE
SELECT
    [Measures].[IS_LEAF] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
   MEMBER [Measures].[IS_LEAF] AS isLeaf(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]))
SELECT
   [Measures].[IS_LEAF] ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsLeaf() : argument (0) type mismatch: expected:'member', got:'tuple'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
   MEMBER [Measures].[IS_LEAF] AS isLeaf([Geography].[Geo].[Continent])
SELECT
   [Measures].[IS_LEAF] ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsLeaf() : argument (0) type mismatch: expected:'member', got:'level'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
   MEMBER [Measures].[IS_LEAF] AS isLeaf({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]})
SELECT
   [Measures].[IS_LEAF] ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsLeaf() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
   MEMBER [Measures].[IS_LEAF] AS isLeaf({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})
SELECT
   [Measures].[IS_LEAF] ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsLeaf() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isLeaf(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
   MEMBER [Measures].[IS_LEAF] AS isLeaf("hello")
SELECT
   [Measures].[IS_LEAF] ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_LEAF</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsLeaf() : argument (0) type mismatch: expected:'member', got:'string'</pre>


 
</div>

                                                                         

### See Also


[IsAll](IsAll.md)

[IsDefault](IsDefault.md)

[IsUnknown](IsUnknown.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
