## IsIn

Return true if the member is contained within the set passed as parameter; false otherwise.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member-set |set-member-expression |one | |
|member |member-expression |one | |



### Return

```
boolean
```



### Description

The function returns whether or not a member is contained within the set passed as parameter. Note that this function handle dimension, hierarchy and level as first parameter.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsIn(members, member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Check that [America] is one of the members of the first set passed as parameter.

**Query**

```
isIn( { [Geography].[Geo].[America] }, [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
True
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsIn(dimension, member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Check that [America] is one of the members of the dimension [Geography].

**Query**

```
isIn( [Geography], [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
True
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsIn(hierarchy, member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Check that [America] is one of the members of the hierarchy [Geography].[Geo].

**Query**

```
isIn( [Geography].[Geo], [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
True
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsIn(level, member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Check that [America] is one of the members of the level [Geography].[Geo].[Continent].

**Query**

```
isIn( [Geography].[Geo].[Continent], [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
True
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsIn(members, NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

NULL is not contained in any set.

**Query**

```
isIn( [Geography].[Geo].[Continent].members, NULL )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
False
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsIn(NULL, member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

NULL does not contain anything.

**Query**

```
isIn( NULL, [Geography].[Geo].[America] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
False
```


 
</div>

                                                                         

### See Also


[Intersect](Intersect.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
