## IsGeneration

Checks whether a member is in the specified generation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member |value-expression |one | |
| |numeric-expression |one | |



### Return

```
boolean
```



### Description

Returns TRUE if a specified member has specified generation index; FALSE otherwise.

Generation index starts at leaf members with a 0 value. The parent of a leaf has a generation of 1, and so on.

Note that for ragged dimension, intermediate members can have different generations as its children can be at different depths.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isGeneration(member,0) - leaf member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true for leaf members.

In our example, the leaf of a [City], [Paris] returns true.

**Query**

```
WITH
    MEMBER [Measures].[V] AS IsGeneration([Geography].[Paris], 0)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[V] AS isLeaf([Geography].[Paris])
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[V] AS true
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isGeneration(member,2) - first level member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Checks for a generation index of value 2. In our example the parent of the parent of [Paris]. Each parent level adds one to the generation index.

**Query**

```
WITH
    MEMBER [Measures].[V] AS IsGeneration([Geography].[Paris].parent.parent, 2)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[V] AS true
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isGeneration(NULL,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[V] AS IsGeneration(null, 2)
SELECT
    [Measures].[V] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">V</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[V] AS false
SELECT
    {[Measures].[V]} ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
