## IsFiltering

Returns true if the specified measure is filtered by the members of the dimension


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member |dimensions-expression |one | |
|member |measure |one | |



### Return

```
boolean
```



### Description

The function returns TRUE if the specified measure values are filtered by the members of the dimension.

This is the case when defining the measure group defined by the measure, the dimension defined a link.

Note, it will return false for categories and Statistical/Utility dimensions.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isFiltering(dimension, measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if the measure values are filtered by the measure

**Query**

```
WITH
    MEMBER [Measures].[IS_FILTERING] AS isFiltering([Geography], [Measures].[Amount])
SELECT
    [Measures].[IS_FILTERING] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_FILTERING</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_FILTERING] AS true
SELECT
    [Measures].[IS_FILTERING] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
