## IsEmpty

Return true if the tuple is evaluated to an empty cell.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |tuple-expression |one | |



### Return

```
boolean
```



### Description

The function returns true if the tuple is evaluated to an empty cell.

a) Null entities will return true, as they are considered empty.
b) Sets of members and tuple will return false independently of their size.

Note that even empty sets return false.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isEmpty(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if the tuple is evaluated to an empty cell (i.e., without value).

In our example, for operating year 2010, we return all cities with sale activity. Note how missing values for hierarchies are filled with current values.

**Query**

```
WITH
    SET [Cities] AS Filter( [Geography].[Geo].[City].Members, NOT IsEmpty( ([Time].[Calendar].[2010],[Measures].[Amount]) ) )
SELECT
    [Cities] ON 0,
    [Measures].[Amount] ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">New York</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Geneva</td>
  <td class="ic3-mdx-result-cell-header">Lausanne</td>
  <td class="ic3-mdx-result-cell-header">Zurich</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">Amount</td>
 <td>768</td>
 <td>4</td>
 <td>2</td>
 <td>1</td>
 <td>128</td>
 <td>56</td>
 <td>64</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    NonEmpty([Geography].[Geo].[City].Members) ON 0,
    [Measures].[Amount] ON 1
FROM
    [Sales]
WHERE
    [Time].[Calendar].[2010]
```


**Assertion : Cell Equals**

```
WITH
    SET [Cities] AS Filter( [Geography].[Geo].[City].Members, NOT IsEmpty( [Measures].[Amount] ) )
SELECT
    [Cities] ON 0,
    [Measures].[Amount] ON 1
FROM
    [Sales]
WHERE
    [Time].[Calendar].[2010]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isEmpty(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if applied to a NULL entity.

**Query**

```
WITH
    MEMBER [Measures].[Empty] AS IsEmpty(NULL)
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Empty</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Empty] AS True
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isEmpty(emptySet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to an MDX entity that cannot be converted into a tuple.

**Query**

```
WITH
    MEMBER [Measures].[Empty] AS isEmpty({})
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Empty</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Empty] AS FALSE
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isEmpty(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to an MDX entity that cannot be converted into a tuple.

**Query**

```
WITH
    MEMBER [Measures].[Empty] AS isEmpty([Geography].[Geo].[Continent])
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Empty</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Empty] AS FALSE
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isEmpty(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to an MDX entity that cannot be converted into a tuple.

**Query**

```
WITH
    MEMBER [Measures].[Empty] AS isEmpty({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]})
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Empty</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Empty] AS FALSE
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isEmpty(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to an MDX entity that cannot be converted into a tuple.

**Query**

```
WITH
    MEMBER [Measures].[Empty] AS isEmpty({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Empty</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Empty] AS FALSE
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isEmpty(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to an MDX entity that cannot be converted into a tuple.

**Query**

```
WITH
    MEMBER [Measures].[Empty] AS isEmpty("hello")
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Empty</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Empty] AS FALSE
SELECT
    {[Measures].[Empty]} ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[NonEmpty](NonEmpty.md)

[Exists](Exists.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
