## IsDefault

Returns true if the member is the default member of the hierarchy.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member |member-expression |one | |



### Return

```
boolean
```



### Description

The function returns true if the member is the default member of his hierarchy.

If the parameter is not a MDX member this function will return false.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsDefault(member) - true

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if the member is the default member.

**Query**

```
isDefault([Geography].[Geo].defaultmember)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


**Assertion : MDX Equals**

```
[Geography].[Geo].defaultmember.isDefault
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsDefault(member) - false

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if the member is not the default member of the hierarchy.

**Query**

```
IsDefault([Geography].[Geo].[America])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[America].IsDefault
```


**Assertion : MDX Equals**

```
false
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsDefault(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if the parameter is not a member.

**Query**

```
IsDefault(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
FALSE
```


**Assertion : MDX Equals**

```
IsDefault(2.3)
```


**Assertion : MDX Equals**

```
IsDefault([Geography].[Geo].members)
```


 
</div>

                                                                         

### See Also


[IsAll](IsAll.md)

[IsLeaf](IsLeaf.md)

[IsUnknown](IsUnknown.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
