## IsAncestor

Checks whether one member is the ancestor of another one.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|ancestor |member-expression |one | |
|member |member-expression |one | |



### Return

```
boolean
```



### Description

Returns true if the first member is an ancestor of the second member.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(ancestor,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if 'ancestor' member parameter is an ancestor of the 'member' parameter.

In our example, returns true as [Europe] is an ancestor of Paris.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor([Geography].[Geo].[Europe],[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS true
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
// fine also for parents
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor([Geography].[Geo].[France],[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(ancestor,member) - ancestor = member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false as a member is not an ancestor of itself.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor([Geography].[Geo].[Paris],[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS false
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(ancestor,member) - different hierarchy/dimension members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to members from different hierarchies or dimensions.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor( [Geography].[Economy].[United States], [Geography].[Geo].[New York])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS false
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor([Prod].[icCube],[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(NULL,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if applied to a NULL member or ancestor.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor( [Geography].[Geo].[Paris], NULL)
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>false</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS false
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor( NULL, NULL )
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]),[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsAncestor() : argument (0) type mismatch: expected:'member', got:'tuple'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor([Geography].[Geo].[Continent],[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsAncestor() : argument (0) type mismatch: expected:'member', got:'level'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]},[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsAncestor() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])},[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsAncestor() : argument (0) type mismatch: expected:'member', got:'set'</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### isAncestor(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
WITH
    MEMBER [Measures].[IS_ANCESTOR] AS isAncestor("hello",[Geography].[Geo].[Paris])
SELECT
    [Measures].[IS_ANCESTOR] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">IS_ANCESTOR</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)<br>Error Message : IsAncestor() : argument (0) type mismatch: expected:'member', got:'string'</pre>


 
</div>

                                                                         

### See Also


[Ancestor](Ancestor.md)

[Ancestors](Ancestors.md)

[IsSibling](IsSibling.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
