## IsAll

Returns true if the member is the All member of the hierarchy.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member |member-expression |one | |



### Return

```
boolean
```



### Description

The function returns true if the member is the ALL member of his hierarchy.

If the parameter is not a MDX member this function will return false.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsAll(member) - true

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns true if the member is the ALL member.

**Query**

```
isAll([Geography].[Geo].[All Regions])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>true</td></tr></table>


**Assertion : MDX Equals**

```
true
```


**Assertion : MDX Equals**

```
isAll([Geography].[Geo]) /* implicit conversion to default member (here ALL) */
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsAll(member) - false

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if the member is not the All member of the hierarchy.

**Query**

```
isAll([Geography].[Geo].[America])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[America].isAll
```


**Assertion : MDX Equals**

```
false
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsAll(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns false if the parameter is not a member.

**Query**

```
isAll(NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


**Assertion : MDX Equals**

```
FALSE
```


**Assertion : MDX Equals**

```
isAll(2.3)
```


**Assertion : MDX Equals**

```
isAll([Geography].[Geo].members)
```


 
</div>

                                                                         

### See Also


[IsDefault](IsDefault.md)

[IsLeaf](IsLeaf.md)

[IsUnknown](IsUnknown.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
