## Intersect

Returns the intersection of two sets, optionally retaining duplicates.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|Set1 |set-expression |one | |
|Set2 |set-expression |one | |
| |ALL |zero-one | |



### Return

```
set
```



### Description

Returns the intersection of two sets, optionally retaining duplicates.

Intersect( {A,A,B,F,G}, {A,B,C} ) -> {A,B}
Intersect( {A,A,B,F,G}, {A,B,C}, ALL ) -> {A,A,B}

The ALL flag specifies that the function should retain duplicates from the first set; when not specified, the function does not retain duplicates.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set,set) - members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members present on both sets, in our case [Europe].

**Query**

```
INTERSECT(
    {[Geography].[Geo].[Europe],[Geography].[Geo].[America]}
    ,
    {[Geography].[Geo].[Europe]}
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Europe]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set,set) - tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

The intersect function works also for tuples, returning tuples present in both sets.

**Query**

```
INTERSECT(
    [Product].[Prod].[Corporate] * {[Geography].[Geo].[Europe],[Geography].[Geo].[America]}
    ,
    [Product].[Prod].[Corporate] * {[Geography].[Geo].[Europe]}
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Product].[Prod].[Licence].[Corporate], [Geography].[Geo].[Continent].[Europe] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Product].[Prod].[Corporate],[Geography].[Geo].[Europe])}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set,set,ALL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns members present on both sets, keeping duplicates of the first set.

**Query**

```
INTERSECT(
    {[Geography].[Geo].[Europe],[Geography].[Geo].[Europe]},
    {[Geography].[Geo].[Europe]},
    ALL
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Europe],[Geography].[Geo].[Europe]}
```


**Assertion : MDX Equals**

```
INTERSECT(
    {[Geography].[Geo].[Europe],[Geography].[Geo].[Europe]},
    {[Geography].[Geo].[Europe],[Geography].[Geo].[Europe],[Geography].[Geo].[Europe]},
    ALL
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set,set,ALL) - duplicated members in second set are ignored

</div>

<div class="ic3-mdx-example-body" style="display:none">

The duplicated members in the second set are not retained in the intersection.

In our example, a single [Europe] member is returned.

**Query**

```
INTERSECT(
    {[Geography].[Geo].[Europe]},
    {[Geography].[Geo].[Europe],[Geography].[Geo].[Europe]},
    ALL
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Europe]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applying intersect for a single set generates an error.

**Query**

```
INTERSECT( [Geography].[Geo].DefaultMember )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

Intersect() : unexpected number of parameters '1' (expected:'3,2')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect({},NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a NULL entity or empty sets.

**Query**

```
INTERSECT({},{})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
INTERSECT({},null)
```


**Assertion : MDX Equals**

```
INTERSECT(null,{})
```


**Assertion : MDX Equals**

```
INTERSECT(null,null)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set,set) - members - different dimensionality

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using sets with different dimensionalities causes an error.

**Query**

```
INTERSECT( [Geography].[Geo].members, [Geography].[Economy] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Geography].[Geo]' - '[Geography].[Economy]'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set,set) - tuples - different dimensionality

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using sets with different dimensionalities causes an error.

**Query**

```
INTERSECT(
    { ( [Geography].[Geo].[Spain], [Time].[Calendar].[2010]  ) },
    { ( [Time].[Calendar].[2010] , [Geography].[Geo].[Spain] ) }
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Geography].[Geo],[Time].[Calendar]' - '[Time].[Calendar],[Geography].[Geo]'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(string,set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Using an invalid parameter causes an error.

**Query**

```
INTERSECT("XXX",[Geography].[Geo].[Continent].Members)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Intersect() : argument (0) type mismatch: expected:'set', got:'string'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Intersect(set,set,XYZ)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An invalid flag generates an error.

**Query**

```
INTERSECT( {}, {}, XYZ)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Intersect() : argument (2) type mismatch: expected:'[ALL]', got:'function option(XYZ)'</td></tr></table>


 
</div>

                                                                         

### See Also


[Except](Except.md)

[Union](Union.md)

[IsIn](IsIn.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
