## InterpolateRGBColors

Returns the interpolated colors using the RGB color space.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|position |value-expression |one | |
|color-palette |value-expression |zero-n | |



### Return

```
color
```



### Description

The function returns a color interpolated from the color palette. Interpolation is done linearly in the RGB color space.

The position is a numeric between 0.0 and 1.0 used to define the position in the palette (0.0 first, 1.0 last).

InterpolateRGBColors( 0.25, RGB("#FFA78F") /* 0 position */, RGB("#FFD9CF") /* 1/3 */, RGB("#FFFFFF") /* 2/3 */,RGB("#BDC9E4") /* 1 */ ) will return a color interpolated between the first and second colors.

Remember a color is an integer in the MDX world.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### InterpolateRGBColors(0.5, colors...)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an interpolated color.

In our example, RGB(0,0, 100 / 2 )

**Query**

```
WITH
    MEMBER [Measures].[Color] AS InterpolateRGBColors(0.5,RGB(0,0,100),RGB(0,0,0))
SELECT
    [Measures].[Color] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Color</td>
</tr>
<tr>
 <td>3276800</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Color] AS RGB(0,0,50)
SELECT
    [Measures].[Color] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### InterpolateRGBColors(-1.0, colors...) - outside bounds

</div>

<div class="ic3-mdx-example-body" style="display:none">

if the first parameter is outside bounds the first of the last color will be used.

**Query**

```
WITH
    MEMBER [Measures].[Color] AS InterpolateRGBColors(-1,RGB(0,0,0),RGB(0,0,127),RGB(0,0,255))
SELECT
    [Measures].[Color] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Color</td>
</tr>
<tr>
 <td>0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Color] AS RGB(0,0,0)
SELECT
    [Measures].[Color] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Color] AS InterpolateRGBColors(2,RGB(0,0,255),RGB(0,0,127),RGB(0,0,0))
SELECT
    [Measures].[Color] ON 0
FROM
    [Sales]
```


 
</div>

                                                                         

### See Also


[InterpolateHSVColors](InterpolateHSVColors.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
