## Head

Returns the first specified number of elements in a set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |numeric-expression |zero-one |1 |



### Return

```
set
```



### Description

Returns a set containing the specified number of the elements from the start of the set.

If no numeric expression is specified the first element of the set is returned.

If the specified number of elements is greater than the size of the initial set then the original
set will be returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Head(set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first numeric number of elements from the set.

In our example, returns the two first members of the set.

**Query**

```
Head([Geography].[Geo].[Continent].Members,2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Continent].Members(0),[Geography].[Geo].[Continent].Members(1)}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Head(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first element from the set.

**Query**

```
Head([Geography].[Geo].[Continent].Members)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Head([Geography].[Geo].[Continent].Members,1)
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Head(set,numeric) - set smaller that requested elements

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the number of elements requested is greater than the number of elements in the set, the original set is returned.

**Query**

```
Head([Geography].[Geo].[Continent].Members,300000000)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Continent].Members}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Head(NULL,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a NULL entity.

**Query**

```
Head(NULL,2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Head( [Geography].[Geo].[Continent].Members, 0)
```


**Assertion : MDX Equals**

```
Head( [Geography].[Geo].[Continent].Members, -1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Head(dimension,string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Head([Geography].[Geo].[Continent].Members, "hello")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Head() : argument (1) type mismatch: expected:'numeric', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Tail](Tail.md)

[Subset](Subset.md)

[Range](Range.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
