## HSV

Create a color from its HSV values.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|hue |value-expression |one | |
|saturation |value-expression |one | |
|value |value-expression |one | |



### Return

```
color
```



### Description

The function returns a color in the HSV color space; e.g., yellow-color = RGV( 60, 1.0, 1.0).

The saturation and value components should be floating-point values between zero and one (numbers in the range 0.0-1.0). The hue component can be any floating-point number.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### HSV( h, s, v)

</div>

<div class="ic3-mdx-example-body" style="display:none">

This examples creates an yellow color.

**Query**

```
WITH
    MEMBER [Measures].[YELLOW] AS HSV( 60.0, 1.0, 1.0 )
SELECT
    [Measures].[YELLOW] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">YELLOW</td>
</tr>
<tr>
 <td>65535</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[YELLOW] AS RGB( 255, 255, 0 )
SELECT
    [Measures].[YELLOW] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[RGB](RGB.md)

[InterpolateHSVColors](InterpolateHSVColors.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
