## HSL

Returns a color from its HSL (hue, saturation, and lightness) representation.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|hue |value-expression |one | |
|saturation |value-expression |one | |
|lightness |value-expression |one | |



### Return

```
color
```



### Description

The function returns a color in the HSL (hue, saturation, and lightness) color space.

The saturation and lightness components should be floating-point values between zero and one (numbers in the range 0.0-1.0). The hue component can be any floating-point number.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### HSL( h, s, l)

</div>

<div class="ic3-mdx-example-body" style="display:none">

This examples returns a yellow color.

**Query**

```
WITH MEMBER [Blue] AS HSL( 207, 1.0, 0.5 )
SELECT [Blue] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Blue</td>
</tr>
<tr>
 <td>16747520</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [Blue] AS RGB( 0, 140, 255 )
SELECT [Blue] ON 0 FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[HSV](HSV.md)

[RGB](RGB.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
