## GetFilterInfo

Returns the set of tuples on a specified axis of the sub-select.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|hierarchy |hierarchy-expression | | |



### Return

```
set
```



### Description

Returns a set of members, extracting from both slicer and subselect sets members of the defined hierarchy.

The set does removes duplicated members.



### Since Version

5.1.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Basic Example

</div>

<div class="ic3-mdx-example-body" style="display:none">

In our example, we're displaying the name of the members in the sub-select.

**Query**

```
WITH
	MEMBER [Count-Time] as GetFilterInfo([Time].[Calendar]).count
	MEMBER [Count-Geo] as GetFilterInfo([Geography].[Geo]).count
SELECT
	{ [Measures].[Count-Time], [Measures].[Count-Geo] } on 0
from
 ( select { [Time].[Calendar].[2010], [Time].[Calendar].[2011] } on 0 from [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Count-Time</td>
  <td class="ic3-mdx-result-cell-header">Count-Geo</td>
</tr>
<tr>
 <td>2</td>
 <td>0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
with
  MEMBER [Count-Time] as 2
  MEMBER [Count-Geo] as 0
select
    { [Measures].[Count-Time], [Measures].[Count-Geo] } on 0

from ( select { [Time].[Calendar].[2010], [Time].[Calendar].[2011] } on 0 from [Sales] )
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Count-Time] as GetFilterInfo([Time].[Calendar]).count
    MEMBER [Count-Geo] as GetFilterInfo([Geography].[Geo]).count
SELECT
    { [Measures].[Count-Time], [Measures].[Count-Geo] } on 0
from
 ( select { [Time].[Calendar].[2010], [Time].[Calendar].[2011] } on 0 from [Sales] )
 where [Time].[Calendar].[2010]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Count-Time] as GetFilterInfo([Time].[Calendar]).count
    MEMBER [Count-Geo] as GetFilterInfo([Geography].[Geo]).count
SELECT
    { [Measures].[Count-Time], [Measures].[Count-Geo] } on 0
from
 ( select { [Time].[Calendar].[2011] } on 0 from [Sales] )
 where [Time].[Calendar].[2010]
```


 
</div>

                                                                                                            

### See Also


[Axis](Axis.md)

[SubSelectAxis](SubSelectAxis.md)

[Slicer](Slicer.md)

[ContextMember](ContextMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
