## FilterBy

Similar to SubQueries, FILTERBY clauses are restricting the space of the cube for the SELECT evaluation.




### Description

Equivalent to SubQueries, FILTERBY clauses are simpler to use. They are restricting the space of the cube used during the SELECT evaluation.

You can use Subcubes as the parameter of a FILTERBY clause. Subcubes will NOT filter the axis as
standard FILTERBY do, but behave the same in calculated members, see examples.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Equivalent to SubQuery

</div>

<div class="ic3-mdx-example-body" style="display:none">

FILTERBY clauses are equivalent to SubQueries.

In our example, [Geography].[Geo].[Europe].children is returning only the sub-select
member [Geography].[Geo].[Switzerland].

**Query**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[Personal]) ON 0
FROM [Sales]

FILTERBY [Geography].[Geo].[Switzerland]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Personal</td>
</tr>
<tr>
 <td>8</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    crossjoin([Geography].[Geo].[Europe].children,[Product].[Prod].[Personal]) ON 0
FROM
    ( SELECT [Geography].[Geo].[Switzerland] ON 0 FROM [Sales] )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Subcubes and Calculated Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Subcubes behaves similar than using an MDX Set.

**Query**

```
WITH
   MEMBER Amount_2010 as [Amount]
   MEMBER Amount_2011 as ( [Amount], [Time].[Calendar].[2011])
SELECT
    { [Amount_2010] , [Amount_2011] } on  0
     [Geography].[Geo].[Continent] on 1
FROM [Sales]
FILTERBY SubCubeUnion([Time].[Calendar].[2010])
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount_2010</td>
  <td class="ic3-mdx-result-cell-header">Amount_2011</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>768</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255</td>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
   MEMBER Amount_2010 as ( [Amount],[Time].[Calendar].[2010] )
   MEMBER Amount_2011 as ( [Amount],[Time].[Calendar].[2011] )
SELECT
    { [Amount_2010] , [Amount_2011] } on  0
     [Geography].[Geo].[Continent] on 1
FROM [Sales]
```


**Assertion : MDX Equals**

```
WITH
   Amount_2010 as [Amount]
   Amount_2011 as ( [Amount],[Time].[Calendar].[2011] )
SELECT
    { [Amount_2010] , [Amount_2011] } on  0
     [Geography].[Geo].[Continent] on 1
FROM [Sales]
FILTERBY [Time].[Calendar].[2010]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Filtering Axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

FilterBy clause filters the axis (it's NOT the case when using SubCubes)

**Query**

```
SELECT
     [Geography].[Geo].[Continent] on 0
FROM [Sales]
FILTERBY [Geography].[Geo].[America]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">America</td>
</tr>
<tr>
 <td>768</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
     [Geography].[Geo].[America] on 0
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Filtering Axis - SubCubes

</div>

<div class="ic3-mdx-example-body" style="display:none">

FilterBy clause do NOT filter the axis when using subcubes

**Query**

```
WITH
   MEMBER Constant AS 2
SELECT
     [Constant] on 0
     [Geography].[Geo].[Continent] on 1
FROM [Sales]
FILTERBY SubCubeUnion([Geography].[Geo].[America])
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Constant</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>2</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
   MEMBER Constant AS 2
SELECT
     [Constant] on 0
     [Geography].[Geo].[Continent] on 1
FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[SubQueries](SubQueries.md)

[SubCubeUnion](SubCubeUnion.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
