## Filter

Filters the specified set elements according to the filtering condition.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression | | |
| |boolean-expression | | |
|limit |value-expression |zero-one | |



### Return

```
set
```



### Description

Returns a subset of the specified set based on the filtering condition.

Only elements that satisfy the filter condition are included in the result set.

The third parameter, if defined, limits the number of returned tuples or members.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Filter(member-set,condition)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members passing the condition.

In our example, we return all cities of [United States].

**Query**

```
Filter([Geography].[Geo].[City].members, [Geography].[Geo].CurrentMember.Parent IS [Geography].[Geo].[United States])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[United States].children
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Filter(member-set,condition,limit)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first member passing the condition.

In our example, we return the first city of [United States].

**Query**

```
Filter([Geography].[Geo].[City].members, [Geography].[Geo].CurrentMember.Parent IS [Geography].[Geo].[United States], 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Los Angeles]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[United States].children.head(1)
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Filter({},condition), Filter(NULL,condition)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a NULL entity or an empty set.

**Query**

```
Filter( {}, [Measures].[Amount])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Filter( NULL, [Measures].[Amount] )
```


**Assertion : MDX Equals**

```
Filter( [Geography].[Geo].[Europe].children, NULL )
```


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
