## Extract

Returns a set of tuples extracting the specified hierarchies


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |hierarchy-expression |one-n | |



### Return

```
set
```



### Description

For each tuple in the specified set, this functions extracts the members of the specified hierarchies into a new tuple. These new tuples are combined into a new set returned by this function.

Note that this function removes duplicate elements.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Extract(set,hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the set, extracting from all tuples the hierarchy specified.

In our example, the function removes from the tuple the member of the [Geography].[Economy] hierarchy.

**Query**

```
Extract( { ([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}, [Geography].[Geo] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Canada]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Extract(set,hierarchy) - duplicates are removed

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the set, extracting from all tuples the hierarchy specified. Duplicated tuples are removed.

In our example, the function removes from the tuple the member of the [Geography].[Economy] hierarchy.

**Query**

```
Extract( { ([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}+{([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}, [Geography].[Geo] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Canada]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Extract(set,hierarchy1,hierarchy2) - multiple hierarchies

</div>

<div class="ic3-mdx-example-body" style="display:none">

Extract will also works with a list of hierarchies.

**Query**

```
Extract( {([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}, [Geography].[Geo],[Geography].[Economy] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Country].[Canada], [Geography].[Economy].[Country].[Canada] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Extract(set,hierarchy) - missing hierarchy

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if the tuples of the set do no contain the requested hierarchy.

**Query**

```
Extract( {([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}, [Time].[Calendar] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_EXTRACT_MISSING_HIERARCHY](icCubeError.md#olap_extract_missing_hierarchy)</td></tr><tr><td>Error Message</td><td>

Extract() : tuples/members dimensionality is missing the specified hierarchy '[Calendar(5)]'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Extract(set,hierarchy1,hierarchy2) - missing hierarchy II

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if the tuples of the set do no contain at least one of the requested hierarchies.

**Query**

```
Extract( {([Geography].[Geo].[Canada],[Geography].[Economy].[Canada])}, [Geography].[Geo],[Geography].[Economy],[Time].[Calendar] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_EXTRACT_MISSING_HIERARCHY](icCubeError.md#olap_extract_missing_hierarchy)</td></tr><tr><td>Error Message</td><td>

Extract() : tuples/members dimensionality is missing the specified hierarchy '[Calendar(5)]'</td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Extract({},hierarchy)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if an empty set is specified.

**Query**

```
Extract( {}, [Geography].[Geo] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                         

### See Also


[ExtractOthers](ExtractOthers.md)

[Crossjoin](Crossjoin.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
