## Expand

Returns a set with all members expanded (self and descendants)


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |



### Return

```
set
```



### Description

Returns a set containing all members or expanded tuples, including the current element and all its descendants.

This function is similar to the Descendants function but operates on sets and crossjoins of tuples.

Note: When applied to a crossjoin, this function may significantly increase the size of the resulting set. Use with caution to avoid performance and memory issues.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Expand(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with all members expanded, with self and all descendants.

**Query**

```
Expand([Geography].[Geo].[France])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
Descendants([Geography].[Geo].[France],[Geography].[Geo].[Country],SELF_AND_AFTER)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Expand(member_set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with all members expanded, with self and all descendants.

**Query**

```
Expand({[Geography].[Geo].[France],[Geography].[Geo].[Spain]})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
{Descendants([Geography].[Geo].[France],[Geography].[Geo].[Country],SELF_AND_AFTER)+Descendants([Geography].[Geo].[Spain],[Geography].[Geo].[Country],SELF_AND_AFTER)}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Expand(member_set_crossjoin)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with all members expanded, with self and all descendants.

**Query**

```
SELECT
    Expand( {[Geography].[Geo].[France],[Geography].[Geo].[Spain]} * {[Time].[Calendar].[Year].[2010],[Time].[Calendar].[Year].[2011]}) on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Paris</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Barcelona</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Madrid</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
  <td class="ic3-mdx-result-cell-header">Valencia</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">January 1 2010</td>
  <td class="ic3-mdx-result-cell-header">January 2 2010</td>
  <td class="ic3-mdx-result-cell-header">January 3 2010</td>
  <td class="ic3-mdx-result-cell-header">January 4 2010</td>
  <td class="ic3-mdx-result-cell-header">January 5 2010</td>
  <td class="ic3-mdx-result-cell-header">January 6 2010</td>
  <td class="ic3-mdx-result-cell-header">January 7 2010</td>
  <td class="ic3-mdx-result-cell-header">January 8 2010</td>
  <td class="ic3-mdx-result-cell-header">January 9 2010</td>
  <td class="ic3-mdx-result-cell-header">January 10 2010</td>
  <td class="ic3-mdx-result-cell-header">January 11 2010</td>
  <td class="ic3-mdx-result-cell-header">January 12 2010</td>
  <td class="ic3-mdx-result-cell-header">January 13 2010</td>
  <td class="ic3-mdx-result-cell-header">January 14 2010</td>
  <td class="ic3-mdx-result-cell-header">January 15 2010</td>
  <td class="ic3-mdx-result-cell-header">January 16 2010</td>
  <td class="ic3-mdx-result-cell-header">January 17 2010</td>
  <td class="ic3-mdx-result-cell-header">January 18 2010</td>
  <td class="ic3-mdx-result-cell-header">January 19 2010</td>
  <td class="ic3-mdx-result-cell-header">January 20 2010</td>
  <td class="ic3-mdx-result-cell-header">January 21 2010</td>
  <td class="ic3-mdx-result-cell-header">January 22 2010</td>
  <td class="ic3-mdx-result-cell-header">January 23 2010</td>
  <td class="ic3-mdx-result-cell-header">January 24 2010</td>
  <td class="ic3-mdx-result-cell-header">January 25 2010</td>
  <td class="ic3-mdx-result-cell-header">January 26 2010</td>
  <td class="ic3-mdx-result-cell-header">January 27 2010</td>
  <td class="ic3-mdx-result-cell-header">January 28 2010</td>
  <td class="ic3-mdx-result-cell-header">January 29 2010</td>
  <td class="ic3-mdx-result-cell-header">January 30 2010</td>
  <td class="ic3-mdx-result-cell-header">January 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">February 1 2010</td>
  <td class="ic3-mdx-result-cell-header">February 2 2010</td>
  <td class="ic3-mdx-result-cell-header">February 3 2010</td>
  <td class="ic3-mdx-result-cell-header">February 4 2010</td>
  <td class="ic3-mdx-result-cell-header">February 5 2010</td>
  <td class="ic3-mdx-result-cell-header">February 6 2010</td>
  <td class="ic3-mdx-result-cell-header">February 7 2010</td>
  <td class="ic3-mdx-result-cell-header">February 8 2010</td>
  <td class="ic3-mdx-result-cell-header">February 9 2010</td>
  <td class="ic3-mdx-result-cell-header">February 10 2010</td>
  <td class="ic3-mdx-result-cell-header">February 11 2010</td>
  <td class="ic3-mdx-result-cell-header">February 12 2010</td>
  <td class="ic3-mdx-result-cell-header">February 13 2010</td>
  <td class="ic3-mdx-result-cell-header">February 14 2010</td>
  <td class="ic3-mdx-result-cell-header">February 15 2010</td>
  <td class="ic3-mdx-result-cell-header">February 16 2010</td>
  <td class="ic3-mdx-result-cell-header">February 17 2010</td>
  <td class="ic3-mdx-result-cell-header">February 18 2010</td>
  <td class="ic3-mdx-result-cell-header">February 19 2010</td>
  <td class="ic3-mdx-result-cell-header">February 20 2010</td>
  <td class="ic3-mdx-result-cell-header">February 21 2010</td>
  <td class="ic3-mdx-result-cell-header">February 22 2010</td>
  <td class="ic3-mdx-result-cell-header">February 23 2010</td>
  <td class="ic3-mdx-result-cell-header">February 24 2010</td>
  <td class="ic3-mdx-result-cell-header">February 25 2010</td>
  <td class="ic3-mdx-result-cell-header">February 26 2010</td>
  <td class="ic3-mdx-result-cell-header">February 27 2010</td>
  <td class="ic3-mdx-result-cell-header">February 28 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
  <td class="ic3-mdx-result-cell-header">March 1 2010</td>
  <td class="ic3-mdx-result-cell-header">March 2 2010</td>
  <td class="ic3-mdx-result-cell-header">March 3 2010</td>
  <td class="ic3-mdx-result-cell-header">March 4 2010</td>
  <td class="ic3-mdx-result-cell-header">March 5 2010</td>
  <td class="ic3-mdx-result-cell-header">March 6 2010</td>
  <td class="ic3-mdx-result-cell-header">March 7 2010</td>
  <td class="ic3-mdx-result-cell-header">March 8 2010</td>
  <td class="ic3-mdx-result-cell-header">March 9 2010</td>
  <td class="ic3-mdx-result-cell-header">March 10 2010</td>
  <td class="ic3-mdx-result-cell-header">March 11 2010</td>
  <td class="ic3-mdx-result-cell-header">March 12 2010</td>
  <td class="ic3-mdx-result-cell-header">March 13 2010</td>
  <td class="ic3-mdx-result-cell-header">March 14 2010</td>
  <td class="ic3-mdx-result-cell-header">March 15 2010</td>
  <td class="ic3-mdx-result-cell-header">March 16 2010</td>
  <td class="ic3-mdx-result-cell-header">March 17 2010</td>
  <td class="ic3-mdx-result-cell-header">March 18 2010</td>
  <td class="ic3-mdx-result-cell-header">March 19 2010</td>
  <td class="ic3-mdx-result-cell-header">March 20 2010</td>
  <td class="ic3-mdx-result-cell-header">March 21 2010</td>
  <td class="ic3-mdx-result-cell-header">March 22 2010</td>
  <td class="ic3-mdx-result-cell-header">March 23 2010</td>
  <td class="ic3-mdx-result-cell-header">March 24 2010</td>
  <td class="ic3-mdx-result-cell-header">March 25 2010</td>
  <td class="ic3-mdx-result-cell-header">March 26 2010</td>
  <td class="ic3-mdx-result-cell-header">March 27 2010</td>
  <td class="ic3-mdx-result-cell-header">March 28 2010</td>
  <td class="ic3-mdx-result-cell-header">March 29 2010</td>
  <td class="ic3-mdx-result-cell-header">March 30 2010</td>
  <td class="ic3-mdx-result-cell-header">March 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
  <td class="ic3-mdx-result-cell-header">Apr 2010</td>
  <td class="ic3-mdx-result-cell-header">April 1 2010</td>
  <td class="ic3-mdx-result-cell-header">April 2 2010</td>
  <td class="ic3-mdx-result-cell-header">April 3 2010</td>
  <td class="ic3-mdx-result-cell-header">April 4 2010</td>
  <td class="ic3-mdx-result-cell-header">April 5 2010</td>
  <td class="ic3-mdx-result-cell-header">April 6 2010</td>
  <td class="ic3-mdx-result-cell-header">April 7 2010</td>
  <td class="ic3-mdx-result-cell-header">April 8 2010</td>
  <td class="ic3-mdx-result-cell-header">April 9 2010</td>
  <td class="ic3-mdx-result-cell-header">April 10 2010</td>
  <td class="ic3-mdx-result-cell-header">April 11 2010</td>
  <td class="ic3-mdx-result-cell-header">April 12 2010</td>
  <td class="ic3-mdx-result-cell-header">April 13 2010</td>
  <td class="ic3-mdx-result-cell-header">April 14 2010</td>
  <td class="ic3-mdx-result-cell-header">April 15 2010</td>
  <td class="ic3-mdx-result-cell-header">April 16 2010</td>
  <td class="ic3-mdx-result-cell-header">April 17 2010</td>
  <td class="ic3-mdx-result-cell-header">April 18 2010</td>
  <td class="ic3-mdx-result-cell-header">April 19 2010</td>
  <td class="ic3-mdx-result-cell-header">April 20 2010</td>
  <td class="ic3-mdx-result-cell-header">April 21 2010</td>
  <td class="ic3-mdx-result-cell-header">April 22 2010</td>
  <td class="ic3-mdx-result-cell-header">April 23 2010</td>
  <td class="ic3-mdx-result-cell-header">April 24 2010</td>
  <td class="ic3-mdx-result-cell-header">April 25 2010</td>
  <td class="ic3-mdx-result-cell-header">April 26 2010</td>
  <td class="ic3-mdx-result-cell-header">April 27 2010</td>
  <td class="ic3-mdx-result-cell-header">April 28 2010</td>
  <td class="ic3-mdx-result-cell-header">April 29 2010</td>
  <td class="ic3-mdx-result-cell-header">April 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2010</td>
  <td class="ic3-mdx-result-cell-header">May 1 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2 2010</td>
  <td class="ic3-mdx-result-cell-header">May 3 2010</td>
  <td class="ic3-mdx-result-cell-header">May 4 2010</td>
  <td class="ic3-mdx-result-cell-header">May 5 2010</td>
  <td class="ic3-mdx-result-cell-header">May 6 2010</td>
  <td class="ic3-mdx-result-cell-header">May 7 2010</td>
  <td class="ic3-mdx-result-cell-header">May 8 2010</td>
  <td class="ic3-mdx-result-cell-header">May 9 2010</td>
  <td class="ic3-mdx-result-cell-header">May 10 2010</td>
  <td class="ic3-mdx-result-cell-header">May 11 2010</td>
  <td class="ic3-mdx-result-cell-header">May 12 2010</td>
  <td class="ic3-mdx-result-cell-header">May 13 2010</td>
  <td class="ic3-mdx-result-cell-header">May 14 2010</td>
  <td class="ic3-mdx-result-cell-header">May 15 2010</td>
  <td class="ic3-mdx-result-cell-header">May 16 2010</td>
  <td class="ic3-mdx-result-cell-header">May 17 2010</td>
  <td class="ic3-mdx-result-cell-header">May 18 2010</td>
  <td class="ic3-mdx-result-cell-header">May 19 2010</td>
  <td class="ic3-mdx-result-cell-header">May 20 2010</td>
  <td class="ic3-mdx-result-cell-header">May 21 2010</td>
  <td class="ic3-mdx-result-cell-header">May 22 2010</td>
  <td class="ic3-mdx-result-cell-header">May 23 2010</td>
  <td class="ic3-mdx-result-cell-header">May 24 2010</td>
  <td class="ic3-mdx-result-cell-header">May 25 2010</td>
  <td class="ic3-mdx-result-cell-header">May 26 2010</td>
  <td class="ic3-mdx-result-cell-header">May 27 2010</td>
  <td class="ic3-mdx-result-cell-header">May 28 2010</td>
  <td class="ic3-mdx-result-cell-header">May 29 2010</td>
  <td class="ic3-mdx-result-cell-header">May 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Jun 2010</td>
  <td class="ic3-mdx-result-cell-header">June 1 2010</td>
  <td class="ic3-mdx-result-cell-header">June 2 2010</td>
  <td class="ic3-mdx-result-cell-header">June 3 2010</td>
  <td class="ic3-mdx-result-cell-header">June 4 2010</td>
  <td class="ic3-mdx-result-cell-header">June 5 2010</td>
  <td class="ic3-mdx-result-cell-header">June 6 2010</td>
  <td class="ic3-mdx-result-cell-header">June 7 2010</td>
  <td class="ic3-mdx-result-cell-header">June 8 2010</td>
  <td class="ic3-mdx-result-cell-header">June 9 2010</td>
  <td class="ic3-mdx-result-cell-header">June 10 2010</td>
  <td class="ic3-mdx-result-cell-header">June 11 2010</td>
  <td class="ic3-mdx-result-cell-header">June 12 2010</td>
  <td class="ic3-mdx-result-cell-header">June 13 2010</td>
  <td class="ic3-mdx-result-cell-header">June 14 2010</td>
  <td class="ic3-mdx-result-cell-header">June 15 2010</td>
  <td class="ic3-mdx-result-cell-header">June 16 2010</td>
  <td class="ic3-mdx-result-cell-header">June 17 2010</td>
  <td class="ic3-mdx-result-cell-header">June 18 2010</td>
  <td class="ic3-mdx-result-cell-header">June 19 2010</td>
  <td class="ic3-mdx-result-cell-header">June 20 2010</td>
  <td class="ic3-mdx-result-cell-header">June 21 2010</td>
  <td class="ic3-mdx-result-cell-header">June 22 2010</td>
  <td class="ic3-mdx-result-cell-header">June 23 2010</td>
  <td class="ic3-mdx-result-cell-header">June 24 2010</td>
  <td class="ic3-mdx-result-cell-header">June 25 2010</td>
  <td class="ic3-mdx-result-cell-header">June 26 2010</td>
  <td class="ic3-mdx-result-cell-header">June 27 2010</td>
  <td class="ic3-mdx-result-cell-header">June 28 2010</td>
  <td class="ic3-mdx-result-cell-header">June 29 2010</td>
  <td class="ic3-mdx-result-cell-header">June 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q3 2010</td>
  <td class="ic3-mdx-result-cell-header">Jul 2010</td>
  <td class="ic3-mdx-result-cell-header">July 1 2010</td>
  <td class="ic3-mdx-result-cell-header">July 2 2010</td>
  <td class="ic3-mdx-result-cell-header">July 3 2010</td>
  <td class="ic3-mdx-result-cell-header">July 4 2010</td>
  <td class="ic3-mdx-result-cell-header">July 5 2010</td>
  <td class="ic3-mdx-result-cell-header">July 6 2010</td>
  <td class="ic3-mdx-result-cell-header">July 7 2010</td>
  <td class="ic3-mdx-result-cell-header">July 8 2010</td>
  <td class="ic3-mdx-result-cell-header">July 9 2010</td>
  <td class="ic3-mdx-result-cell-header">July 10 2010</td>
  <td class="ic3-mdx-result-cell-header">July 11 2010</td>
  <td class="ic3-mdx-result-cell-header">July 12 2010</td>
  <td class="ic3-mdx-result-cell-header">July 13 2010</td>
  <td class="ic3-mdx-result-cell-header">July 14 2010</td>
  <td class="ic3-mdx-result-cell-header">July 15 2010</td>
  <td class="ic3-mdx-result-cell-header">July 16 2010</td>
  <td class="ic3-mdx-result-cell-header">July 17 2010</td>
  <td class="ic3-mdx-result-cell-header">July 18 2010</td>
  <td class="ic3-mdx-result-cell-header">July 19 2010</td>
  <td class="ic3-mdx-result-cell-header">July 20 2010</td>
  <td class="ic3-mdx-result-cell-header">July 21 2010</td>
  <td class="ic3-mdx-result-cell-header">July 22 2010</td>
  <td class="ic3-mdx-result-cell-header">July 23 2010</td>
  <td class="ic3-mdx-result-cell-header">July 24 2010</td>
  <td class="ic3-mdx-result-cell-header">July 25 2010</td>
  <td class="ic3-mdx-result-cell-header">July 26 2010</td>
  <td class="ic3-mdx-result-cell-header">July 27 2010</td>
  <td class="ic3-mdx-result-cell-header">July 28 2010</td>
  <td class="ic3-mdx-result-cell-header">July 29 2010</td>
  <td class="ic3-mdx-result-cell-header">July 30 2010</td>
  <td class="ic3-mdx-result-cell-header">July 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Aug 2010</td>
  <td class="ic3-mdx-result-cell-header">August 1 2010</td>
  <td class="ic3-mdx-result-cell-header">August 2 2010</td>
  <td class="ic3-mdx-result-cell-header">August 3 2010</td>
  <td class="ic3-mdx-result-cell-header">August 4 2010</td>
  <td class="ic3-mdx-result-cell-header">August 5 2010</td>
  <td class="ic3-mdx-result-cell-header">August 6 2010</td>
  <td class="ic3-mdx-result-cell-header">August 7 2010</td>
  <td class="ic3-mdx-result-cell-header">August 8 2010</td>
  <td class="ic3-mdx-result-cell-header">August 9 2010</td>
  <td class="ic3-mdx-result-cell-header">August 10 2010</td>
  <td class="ic3-mdx-result-cell-header">August 11 2010</td>
  <td class="ic3-mdx-result-cell-header">August 12 2010</td>
  <td class="ic3-mdx-result-cell-header">August 13 2010</td>
  <td class="ic3-mdx-result-cell-header">August 14 2010</td>
  <td class="ic3-mdx-result-cell-header">August 15 2010</td>
  <td class="ic3-mdx-result-cell-header">August 16 2010</td>
  <td class="ic3-mdx-result-cell-header">August 17 2010</td>
  <td class="ic3-mdx-result-cell-header">August 18 2010</td>
  <td class="ic3-mdx-result-cell-header">August 19 2010</td>
  <td class="ic3-mdx-result-cell-header">August 20 2010</td>
  <td class="ic3-mdx-result-cell-header">August 21 2010</td>
  <td class="ic3-mdx-result-cell-header">August 22 2010</td>
  <td class="ic3-mdx-result-cell-header">August 23 2010</td>
  <td class="ic3-mdx-result-cell-header">August 24 2010</td>
  <td class="ic3-mdx-result-cell-header">August 25 2010</td>
  <td class="ic3-mdx-result-cell-header">August 26 2010</td>
  <td class="ic3-mdx-result-cell-header">August 27 2010</td>
  <td class="ic3-mdx-result-cell-header">August 28 2010</td>
  <td class="ic3-mdx-result-cell-header">August 29 2010</td>
  <td class="ic3-mdx-result-cell-header">August 30 2010</td>
  <td class="ic3-mdx-result-cell-header">August 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Sep 2010</td>
  <td class="ic3-mdx-result-cell-header">September 1 2010</td>
  <td class="ic3-mdx-result-cell-header">September 2 2010</td>
  <td class="ic3-mdx-result-cell-header">September 3 2010</td>
  <td class="ic3-mdx-result-cell-header">September 4 2010</td>
  <td class="ic3-mdx-result-cell-header">September 5 2010</td>
  <td class="ic3-mdx-result-cell-header">September 6 2010</td>
  <td class="ic3-mdx-result-cell-header">September 7 2010</td>
  <td class="ic3-mdx-result-cell-header">September 8 2010</td>
  <td class="ic3-mdx-result-cell-header">September 9 2010</td>
  <td class="ic3-mdx-result-cell-header">September 10 2010</td>
  <td class="ic3-mdx-result-cell-header">September 11 2010</td>
  <td class="ic3-mdx-result-cell-header">September 12 2010</td>
  <td class="ic3-mdx-result-cell-header">September 13 2010</td>
  <td class="ic3-mdx-result-cell-header">September 14 2010</td>
  <td class="ic3-mdx-result-cell-header">September 15 2010</td>
  <td class="ic3-mdx-result-cell-header">September 16 2010</td>
  <td class="ic3-mdx-result-cell-header">September 17 2010</td>
  <td class="ic3-mdx-result-cell-header">September 18 2010</td>
  <td class="ic3-mdx-result-cell-header">September 19 2010</td>
  <td class="ic3-mdx-result-cell-header">September 20 2010</td>
  <td class="ic3-mdx-result-cell-header">September 21 2010</td>
  <td class="ic3-mdx-result-cell-header">September 22 2010</td>
  <td class="ic3-mdx-result-cell-header">September 23 2010</td>
  <td class="ic3-mdx-result-cell-header">September 24 2010</td>
  <td class="ic3-mdx-result-cell-header">September 25 2010</td>
  <td class="ic3-mdx-result-cell-header">September 26 2010</td>
  <td class="ic3-mdx-result-cell-header">September 27 2010</td>
  <td class="ic3-mdx-result-cell-header">September 28 2010</td>
  <td class="ic3-mdx-result-cell-header">September 29 2010</td>
  <td class="ic3-mdx-result-cell-header">September 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q4 2010</td>
  <td class="ic3-mdx-result-cell-header">Oct 2010</td>
  <td class="ic3-mdx-result-cell-header">October 1 2010</td>
  <td class="ic3-mdx-result-cell-header">October 2 2010</td>
  <td class="ic3-mdx-result-cell-header">October 3 2010</td>
  <td class="ic3-mdx-result-cell-header">October 4 2010</td>
  <td class="ic3-mdx-result-cell-header">October 5 2010</td>
  <td class="ic3-mdx-result-cell-header">October 6 2010</td>
  <td class="ic3-mdx-result-cell-header">October 7 2010</td>
  <td class="ic3-mdx-result-cell-header">October 8 2010</td>
  <td class="ic3-mdx-result-cell-header">October 9 2010</td>
  <td class="ic3-mdx-result-cell-header">October 10 2010</td>
  <td class="ic3-mdx-result-cell-header">October 11 2010</td>
  <td class="ic3-mdx-result-cell-header">October 12 2010</td>
  <td class="ic3-mdx-result-cell-header">October 13 2010</td>
  <td class="ic3-mdx-result-cell-header">October 14 2010</td>
  <td class="ic3-mdx-result-cell-header">October 15 2010</td>
  <td class="ic3-mdx-result-cell-header">October 16 2010</td>
  <td class="ic3-mdx-result-cell-header">October 17 2010</td>
  <td class="ic3-mdx-result-cell-header">October 18 2010</td>
  <td class="ic3-mdx-result-cell-header">October 19 2010</td>
  <td class="ic3-mdx-result-cell-header">October 20 2010</td>
  <td class="ic3-mdx-result-cell-header">October 21 2010</td>
  <td class="ic3-mdx-result-cell-header">October 22 2010</td>
  <td class="ic3-mdx-result-cell-header">October 23 2010</td>
  <td class="ic3-mdx-result-cell-header">October 24 2010</td>
  <td class="ic3-mdx-result-cell-header">October 25 2010</td>
  <td class="ic3-mdx-result-cell-header">October 26 2010</td>
  <td class="ic3-mdx-result-cell-header">October 27 2010</td>
  <td class="ic3-mdx-result-cell-header">October 28 2010</td>
  <td class="ic3-mdx-result-cell-header">October 29 2010</td>
  <td class="ic3-mdx-result-cell-header">October 30 2010</td>
  <td class="ic3-mdx-result-cell-header">October 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Nov 2010</td>
  <td class="ic3-mdx-result-cell-header">November 1 2010</td>
  <td class="ic3-mdx-result-cell-header">November 2 2010</td>
  <td class="ic3-mdx-result-cell-header">November 3 2010</td>
  <td class="ic3-mdx-result-cell-header">November 4 2010</td>
  <td class="ic3-mdx-result-cell-header">November 5 2010</td>
  <td class="ic3-mdx-result-cell-header">November 6 2010</td>
  <td class="ic3-mdx-result-cell-header">November 7 2010</td>
  <td class="ic3-mdx-result-cell-header">November 8 2010</td>
  <td class="ic3-mdx-result-cell-header">November 9 2010</td>
  <td class="ic3-mdx-result-cell-header">November 10 2010</td>
  <td class="ic3-mdx-result-cell-header">November 11 2010</td>
  <td class="ic3-mdx-result-cell-header">November 12 2010</td>
  <td class="ic3-mdx-result-cell-header">November 13 2010</td>
  <td class="ic3-mdx-result-cell-header">November 14 2010</td>
  <td class="ic3-mdx-result-cell-header">November 15 2010</td>
  <td class="ic3-mdx-result-cell-header">November 16 2010</td>
  <td class="ic3-mdx-result-cell-header">November 17 2010</td>
  <td class="ic3-mdx-result-cell-header">November 18 2010</td>
  <td class="ic3-mdx-result-cell-header">November 19 2010</td>
  <td class="ic3-mdx-result-cell-header">November 20 2010</td>
  <td class="ic3-mdx-result-cell-header">November 21 2010</td>
  <td class="ic3-mdx-result-cell-header">November 22 2010</td>
  <td class="ic3-mdx-result-cell-header">November 23 2010</td>
  <td class="ic3-mdx-result-cell-header">November 24 2010</td>
  <td class="ic3-mdx-result-cell-header">November 25 2010</td>
  <td class="ic3-mdx-result-cell-header">November 26 2010</td>
  <td class="ic3-mdx-result-cell-header">November 27 2010</td>
  <td class="ic3-mdx-result-cell-header">November 28 2010</td>
  <td class="ic3-mdx-result-cell-header">November 29 2010</td>
  <td class="ic3-mdx-result-cell-header">November 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Dec 2010</td>
  <td class="ic3-mdx-result-cell-header">December 1 2010</td>
  <td class="ic3-mdx-result-cell-header">December 2 2010</td>
  <td class="ic3-mdx-result-cell-header">December 3 2010</td>
  <td class="ic3-mdx-result-cell-header">December 4 2010</td>
  <td class="ic3-mdx-result-cell-header">December 5 2010</td>
  <td class="ic3-mdx-result-cell-header">December 6 2010</td>
  <td class="ic3-mdx-result-cell-header">December 7 2010</td>
  <td class="ic3-mdx-result-cell-header">December 8 2010</td>
  <td class="ic3-mdx-result-cell-header">December 9 2010</td>
  <td class="ic3-mdx-result-cell-header">December 10 2010</td>
  <td class="ic3-mdx-result-cell-header">December 11 2010</td>
  <td class="ic3-mdx-result-cell-header">December 12 2010</td>
  <td class="ic3-mdx-result-cell-header">December 13 2010</td>
  <td class="ic3-mdx-result-cell-header">December 14 2010</td>
  <td class="ic3-mdx-result-cell-header">December 15 2010</td>
  <td class="ic3-mdx-result-cell-header">December 16 2010</td>
  <td class="ic3-mdx-result-cell-header">December 17 2010</td>
  <td class="ic3-mdx-result-cell-header">December 18 2010</td>
  <td class="ic3-mdx-result-cell-header">December 19 2010</td>
  <td class="ic3-mdx-result-cell-header">December 20 2010</td>
  <td class="ic3-mdx-result-cell-header">December 21 2010</td>
  <td class="ic3-mdx-result-cell-header">December 22 2010</td>
  <td class="ic3-mdx-result-cell-header">December 23 2010</td>
  <td class="ic3-mdx-result-cell-header">December 24 2010</td>
  <td class="ic3-mdx-result-cell-header">December 25 2010</td>
  <td class="ic3-mdx-result-cell-header">December 26 2010</td>
  <td class="ic3-mdx-result-cell-header">December 27 2010</td>
  <td class="ic3-mdx-result-cell-header">December 28 2010</td>
  <td class="ic3-mdx-result-cell-header">December 29 2010</td>
  <td class="ic3-mdx-result-cell-header">December 30 2010</td>
  <td class="ic3-mdx-result-cell-header">December 31 2010</td>
  <td class="ic3-mdx-result-cell-header">2011</td>
  <td class="ic3-mdx-result-cell-header">Q1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jan 2011</td>
  <td class="ic3-mdx-result-cell-header">January 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Feb 2011</td>
  <td class="ic3-mdx-result-cell-header">February 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Mar 2011</td>
  <td class="ic3-mdx-result-cell-header">March 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q2 2011</td>
  <td class="ic3-mdx-result-cell-header">Apr 2011</td>
  <td class="ic3-mdx-result-cell-header">April 1 2011</td>
  <td class="ic3-mdx-result-cell-header">May 2011</td>
  <td class="ic3-mdx-result-cell-header">May 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jun 2011</td>
  <td class="ic3-mdx-result-cell-header">June 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q3 2011</td>
  <td class="ic3-mdx-result-cell-header">Jul 2011</td>
  <td class="ic3-mdx-result-cell-header">July 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Aug 2011</td>
  <td class="ic3-mdx-result-cell-header">August 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Sep 2011</td>
  <td class="ic3-mdx-result-cell-header">September 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q4 2011</td>
  <td class="ic3-mdx-result-cell-header">Oct 2011</td>
  <td class="ic3-mdx-result-cell-header">October 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Nov 2011</td>
  <td class="ic3-mdx-result-cell-header">November 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Dec 2011</td>
  <td class="ic3-mdx-result-cell-header">December 1 2011</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">January 1 2010</td>
  <td class="ic3-mdx-result-cell-header">January 2 2010</td>
  <td class="ic3-mdx-result-cell-header">January 3 2010</td>
  <td class="ic3-mdx-result-cell-header">January 4 2010</td>
  <td class="ic3-mdx-result-cell-header">January 5 2010</td>
  <td class="ic3-mdx-result-cell-header">January 6 2010</td>
  <td class="ic3-mdx-result-cell-header">January 7 2010</td>
  <td class="ic3-mdx-result-cell-header">January 8 2010</td>
  <td class="ic3-mdx-result-cell-header">January 9 2010</td>
  <td class="ic3-mdx-result-cell-header">January 10 2010</td>
  <td class="ic3-mdx-result-cell-header">January 11 2010</td>
  <td class="ic3-mdx-result-cell-header">January 12 2010</td>
  <td class="ic3-mdx-result-cell-header">January 13 2010</td>
  <td class="ic3-mdx-result-cell-header">January 14 2010</td>
  <td class="ic3-mdx-result-cell-header">January 15 2010</td>
  <td class="ic3-mdx-result-cell-header">January 16 2010</td>
  <td class="ic3-mdx-result-cell-header">January 17 2010</td>
  <td class="ic3-mdx-result-cell-header">January 18 2010</td>
  <td class="ic3-mdx-result-cell-header">January 19 2010</td>
  <td class="ic3-mdx-result-cell-header">January 20 2010</td>
  <td class="ic3-mdx-result-cell-header">January 21 2010</td>
  <td class="ic3-mdx-result-cell-header">January 22 2010</td>
  <td class="ic3-mdx-result-cell-header">January 23 2010</td>
  <td class="ic3-mdx-result-cell-header">January 24 2010</td>
  <td class="ic3-mdx-result-cell-header">January 25 2010</td>
  <td class="ic3-mdx-result-cell-header">January 26 2010</td>
  <td class="ic3-mdx-result-cell-header">January 27 2010</td>
  <td class="ic3-mdx-result-cell-header">January 28 2010</td>
  <td class="ic3-mdx-result-cell-header">January 29 2010</td>
  <td class="ic3-mdx-result-cell-header">January 30 2010</td>
  <td class="ic3-mdx-result-cell-header">January 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">February 1 2010</td>
  <td class="ic3-mdx-result-cell-header">February 2 2010</td>
  <td class="ic3-mdx-result-cell-header">February 3 2010</td>
  <td class="ic3-mdx-result-cell-header">February 4 2010</td>
  <td class="ic3-mdx-result-cell-header">February 5 2010</td>
  <td class="ic3-mdx-result-cell-header">February 6 2010</td>
  <td class="ic3-mdx-result-cell-header">February 7 2010</td>
  <td class="ic3-mdx-result-cell-header">February 8 2010</td>
  <td class="ic3-mdx-result-cell-header">February 9 2010</td>
  <td class="ic3-mdx-result-cell-header">February 10 2010</td>
  <td class="ic3-mdx-result-cell-header">February 11 2010</td>
  <td class="ic3-mdx-result-cell-header">February 12 2010</td>
  <td class="ic3-mdx-result-cell-header">February 13 2010</td>
  <td class="ic3-mdx-result-cell-header">February 14 2010</td>
  <td class="ic3-mdx-result-cell-header">February 15 2010</td>
  <td class="ic3-mdx-result-cell-header">February 16 2010</td>
  <td class="ic3-mdx-result-cell-header">February 17 2010</td>
  <td class="ic3-mdx-result-cell-header">February 18 2010</td>
  <td class="ic3-mdx-result-cell-header">February 19 2010</td>
  <td class="ic3-mdx-result-cell-header">February 20 2010</td>
  <td class="ic3-mdx-result-cell-header">February 21 2010</td>
  <td class="ic3-mdx-result-cell-header">February 22 2010</td>
  <td class="ic3-mdx-result-cell-header">February 23 2010</td>
  <td class="ic3-mdx-result-cell-header">February 24 2010</td>
  <td class="ic3-mdx-result-cell-header">February 25 2010</td>
  <td class="ic3-mdx-result-cell-header">February 26 2010</td>
  <td class="ic3-mdx-result-cell-header">February 27 2010</td>
  <td class="ic3-mdx-result-cell-header">February 28 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
  <td class="ic3-mdx-result-cell-header">March 1 2010</td>
  <td class="ic3-mdx-result-cell-header">March 2 2010</td>
  <td class="ic3-mdx-result-cell-header">March 3 2010</td>
  <td class="ic3-mdx-result-cell-header">March 4 2010</td>
  <td class="ic3-mdx-result-cell-header">March 5 2010</td>
  <td class="ic3-mdx-result-cell-header">March 6 2010</td>
  <td class="ic3-mdx-result-cell-header">March 7 2010</td>
  <td class="ic3-mdx-result-cell-header">March 8 2010</td>
  <td class="ic3-mdx-result-cell-header">March 9 2010</td>
  <td class="ic3-mdx-result-cell-header">March 10 2010</td>
  <td class="ic3-mdx-result-cell-header">March 11 2010</td>
  <td class="ic3-mdx-result-cell-header">March 12 2010</td>
  <td class="ic3-mdx-result-cell-header">March 13 2010</td>
  <td class="ic3-mdx-result-cell-header">March 14 2010</td>
  <td class="ic3-mdx-result-cell-header">March 15 2010</td>
  <td class="ic3-mdx-result-cell-header">March 16 2010</td>
  <td class="ic3-mdx-result-cell-header">March 17 2010</td>
  <td class="ic3-mdx-result-cell-header">March 18 2010</td>
  <td class="ic3-mdx-result-cell-header">March 19 2010</td>
  <td class="ic3-mdx-result-cell-header">March 20 2010</td>
  <td class="ic3-mdx-result-cell-header">March 21 2010</td>
  <td class="ic3-mdx-result-cell-header">March 22 2010</td>
  <td class="ic3-mdx-result-cell-header">March 23 2010</td>
  <td class="ic3-mdx-result-cell-header">March 24 2010</td>
  <td class="ic3-mdx-result-cell-header">March 25 2010</td>
  <td class="ic3-mdx-result-cell-header">March 26 2010</td>
  <td class="ic3-mdx-result-cell-header">March 27 2010</td>
  <td class="ic3-mdx-result-cell-header">March 28 2010</td>
  <td class="ic3-mdx-result-cell-header">March 29 2010</td>
  <td class="ic3-mdx-result-cell-header">March 30 2010</td>
  <td class="ic3-mdx-result-cell-header">March 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
  <td class="ic3-mdx-result-cell-header">Apr 2010</td>
  <td class="ic3-mdx-result-cell-header">April 1 2010</td>
  <td class="ic3-mdx-result-cell-header">April 2 2010</td>
  <td class="ic3-mdx-result-cell-header">April 3 2010</td>
  <td class="ic3-mdx-result-cell-header">April 4 2010</td>
  <td class="ic3-mdx-result-cell-header">April 5 2010</td>
  <td class="ic3-mdx-result-cell-header">April 6 2010</td>
  <td class="ic3-mdx-result-cell-header">April 7 2010</td>
  <td class="ic3-mdx-result-cell-header">April 8 2010</td>
  <td class="ic3-mdx-result-cell-header">April 9 2010</td>
  <td class="ic3-mdx-result-cell-header">April 10 2010</td>
  <td class="ic3-mdx-result-cell-header">April 11 2010</td>
  <td class="ic3-mdx-result-cell-header">April 12 2010</td>
  <td class="ic3-mdx-result-cell-header">April 13 2010</td>
  <td class="ic3-mdx-result-cell-header">April 14 2010</td>
  <td class="ic3-mdx-result-cell-header">April 15 2010</td>
  <td class="ic3-mdx-result-cell-header">April 16 2010</td>
  <td class="ic3-mdx-result-cell-header">April 17 2010</td>
  <td class="ic3-mdx-result-cell-header">April 18 2010</td>
  <td class="ic3-mdx-result-cell-header">April 19 2010</td>
  <td class="ic3-mdx-result-cell-header">April 20 2010</td>
  <td class="ic3-mdx-result-cell-header">April 21 2010</td>
  <td class="ic3-mdx-result-cell-header">April 22 2010</td>
  <td class="ic3-mdx-result-cell-header">April 23 2010</td>
  <td class="ic3-mdx-result-cell-header">April 24 2010</td>
  <td class="ic3-mdx-result-cell-header">April 25 2010</td>
  <td class="ic3-mdx-result-cell-header">April 26 2010</td>
  <td class="ic3-mdx-result-cell-header">April 27 2010</td>
  <td class="ic3-mdx-result-cell-header">April 28 2010</td>
  <td class="ic3-mdx-result-cell-header">April 29 2010</td>
  <td class="ic3-mdx-result-cell-header">April 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2010</td>
  <td class="ic3-mdx-result-cell-header">May 1 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2 2010</td>
  <td class="ic3-mdx-result-cell-header">May 3 2010</td>
  <td class="ic3-mdx-result-cell-header">May 4 2010</td>
  <td class="ic3-mdx-result-cell-header">May 5 2010</td>
  <td class="ic3-mdx-result-cell-header">May 6 2010</td>
  <td class="ic3-mdx-result-cell-header">May 7 2010</td>
  <td class="ic3-mdx-result-cell-header">May 8 2010</td>
  <td class="ic3-mdx-result-cell-header">May 9 2010</td>
  <td class="ic3-mdx-result-cell-header">May 10 2010</td>
  <td class="ic3-mdx-result-cell-header">May 11 2010</td>
  <td class="ic3-mdx-result-cell-header">May 12 2010</td>
  <td class="ic3-mdx-result-cell-header">May 13 2010</td>
  <td class="ic3-mdx-result-cell-header">May 14 2010</td>
  <td class="ic3-mdx-result-cell-header">May 15 2010</td>
  <td class="ic3-mdx-result-cell-header">May 16 2010</td>
  <td class="ic3-mdx-result-cell-header">May 17 2010</td>
  <td class="ic3-mdx-result-cell-header">May 18 2010</td>
  <td class="ic3-mdx-result-cell-header">May 19 2010</td>
  <td class="ic3-mdx-result-cell-header">May 20 2010</td>
  <td class="ic3-mdx-result-cell-header">May 21 2010</td>
  <td class="ic3-mdx-result-cell-header">May 22 2010</td>
  <td class="ic3-mdx-result-cell-header">May 23 2010</td>
  <td class="ic3-mdx-result-cell-header">May 24 2010</td>
  <td class="ic3-mdx-result-cell-header">May 25 2010</td>
  <td class="ic3-mdx-result-cell-header">May 26 2010</td>
  <td class="ic3-mdx-result-cell-header">May 27 2010</td>
  <td class="ic3-mdx-result-cell-header">May 28 2010</td>
  <td class="ic3-mdx-result-cell-header">May 29 2010</td>
  <td class="ic3-mdx-result-cell-header">May 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Jun 2010</td>
  <td class="ic3-mdx-result-cell-header">June 1 2010</td>
  <td class="ic3-mdx-result-cell-header">June 2 2010</td>
  <td class="ic3-mdx-result-cell-header">June 3 2010</td>
  <td class="ic3-mdx-result-cell-header">June 4 2010</td>
  <td class="ic3-mdx-result-cell-header">June 5 2010</td>
  <td class="ic3-mdx-result-cell-header">June 6 2010</td>
  <td class="ic3-mdx-result-cell-header">June 7 2010</td>
  <td class="ic3-mdx-result-cell-header">June 8 2010</td>
  <td class="ic3-mdx-result-cell-header">June 9 2010</td>
  <td class="ic3-mdx-result-cell-header">June 10 2010</td>
  <td class="ic3-mdx-result-cell-header">June 11 2010</td>
  <td class="ic3-mdx-result-cell-header">June 12 2010</td>
  <td class="ic3-mdx-result-cell-header">June 13 2010</td>
  <td class="ic3-mdx-result-cell-header">June 14 2010</td>
  <td class="ic3-mdx-result-cell-header">June 15 2010</td>
  <td class="ic3-mdx-result-cell-header">June 16 2010</td>
  <td class="ic3-mdx-result-cell-header">June 17 2010</td>
  <td class="ic3-mdx-result-cell-header">June 18 2010</td>
  <td class="ic3-mdx-result-cell-header">June 19 2010</td>
  <td class="ic3-mdx-result-cell-header">June 20 2010</td>
  <td class="ic3-mdx-result-cell-header">June 21 2010</td>
  <td class="ic3-mdx-result-cell-header">June 22 2010</td>
  <td class="ic3-mdx-result-cell-header">June 23 2010</td>
  <td class="ic3-mdx-result-cell-header">June 24 2010</td>
  <td class="ic3-mdx-result-cell-header">June 25 2010</td>
  <td class="ic3-mdx-result-cell-header">June 26 2010</td>
  <td class="ic3-mdx-result-cell-header">June 27 2010</td>
  <td class="ic3-mdx-result-cell-header">June 28 2010</td>
  <td class="ic3-mdx-result-cell-header">June 29 2010</td>
  <td class="ic3-mdx-result-cell-header">June 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q3 2010</td>
  <td class="ic3-mdx-result-cell-header">Jul 2010</td>
  <td class="ic3-mdx-result-cell-header">July 1 2010</td>
  <td class="ic3-mdx-result-cell-header">July 2 2010</td>
  <td class="ic3-mdx-result-cell-header">July 3 2010</td>
  <td class="ic3-mdx-result-cell-header">July 4 2010</td>
  <td class="ic3-mdx-result-cell-header">July 5 2010</td>
  <td class="ic3-mdx-result-cell-header">July 6 2010</td>
  <td class="ic3-mdx-result-cell-header">July 7 2010</td>
  <td class="ic3-mdx-result-cell-header">July 8 2010</td>
  <td class="ic3-mdx-result-cell-header">July 9 2010</td>
  <td class="ic3-mdx-result-cell-header">July 10 2010</td>
  <td class="ic3-mdx-result-cell-header">July 11 2010</td>
  <td class="ic3-mdx-result-cell-header">July 12 2010</td>
  <td class="ic3-mdx-result-cell-header">July 13 2010</td>
  <td class="ic3-mdx-result-cell-header">July 14 2010</td>
  <td class="ic3-mdx-result-cell-header">July 15 2010</td>
  <td class="ic3-mdx-result-cell-header">July 16 2010</td>
  <td class="ic3-mdx-result-cell-header">July 17 2010</td>
  <td class="ic3-mdx-result-cell-header">July 18 2010</td>
  <td class="ic3-mdx-result-cell-header">July 19 2010</td>
  <td class="ic3-mdx-result-cell-header">July 20 2010</td>
  <td class="ic3-mdx-result-cell-header">July 21 2010</td>
  <td class="ic3-mdx-result-cell-header">July 22 2010</td>
  <td class="ic3-mdx-result-cell-header">July 23 2010</td>
  <td class="ic3-mdx-result-cell-header">July 24 2010</td>
  <td class="ic3-mdx-result-cell-header">July 25 2010</td>
  <td class="ic3-mdx-result-cell-header">July 26 2010</td>
  <td class="ic3-mdx-result-cell-header">July 27 2010</td>
  <td class="ic3-mdx-result-cell-header">July 28 2010</td>
  <td class="ic3-mdx-result-cell-header">July 29 2010</td>
  <td class="ic3-mdx-result-cell-header">July 30 2010</td>
  <td class="ic3-mdx-result-cell-header">July 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Aug 2010</td>
  <td class="ic3-mdx-result-cell-header">August 1 2010</td>
  <td class="ic3-mdx-result-cell-header">August 2 2010</td>
  <td class="ic3-mdx-result-cell-header">August 3 2010</td>
  <td class="ic3-mdx-result-cell-header">August 4 2010</td>
  <td class="ic3-mdx-result-cell-header">August 5 2010</td>
  <td class="ic3-mdx-result-cell-header">August 6 2010</td>
  <td class="ic3-mdx-result-cell-header">August 7 2010</td>
  <td class="ic3-mdx-result-cell-header">August 8 2010</td>
  <td class="ic3-mdx-result-cell-header">August 9 2010</td>
  <td class="ic3-mdx-result-cell-header">August 10 2010</td>
  <td class="ic3-mdx-result-cell-header">August 11 2010</td>
  <td class="ic3-mdx-result-cell-header">August 12 2010</td>
  <td class="ic3-mdx-result-cell-header">August 13 2010</td>
  <td class="ic3-mdx-result-cell-header">August 14 2010</td>
  <td class="ic3-mdx-result-cell-header">August 15 2010</td>
  <td class="ic3-mdx-result-cell-header">August 16 2010</td>
  <td class="ic3-mdx-result-cell-header">August 17 2010</td>
  <td class="ic3-mdx-result-cell-header">August 18 2010</td>
  <td class="ic3-mdx-result-cell-header">August 19 2010</td>
  <td class="ic3-mdx-result-cell-header">August 20 2010</td>
  <td class="ic3-mdx-result-cell-header">August 21 2010</td>
  <td class="ic3-mdx-result-cell-header">August 22 2010</td>
  <td class="ic3-mdx-result-cell-header">August 23 2010</td>
  <td class="ic3-mdx-result-cell-header">August 24 2010</td>
  <td class="ic3-mdx-result-cell-header">August 25 2010</td>
  <td class="ic3-mdx-result-cell-header">August 26 2010</td>
  <td class="ic3-mdx-result-cell-header">August 27 2010</td>
  <td class="ic3-mdx-result-cell-header">August 28 2010</td>
  <td class="ic3-mdx-result-cell-header">August 29 2010</td>
  <td class="ic3-mdx-result-cell-header">August 30 2010</td>
  <td class="ic3-mdx-result-cell-header">August 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Sep 2010</td>
  <td class="ic3-mdx-result-cell-header">September 1 2010</td>
  <td class="ic3-mdx-result-cell-header">September 2 2010</td>
  <td class="ic3-mdx-result-cell-header">September 3 2010</td>
  <td class="ic3-mdx-result-cell-header">September 4 2010</td>
  <td class="ic3-mdx-result-cell-header">September 5 2010</td>
  <td class="ic3-mdx-result-cell-header">September 6 2010</td>
  <td class="ic3-mdx-result-cell-header">September 7 2010</td>
  <td class="ic3-mdx-result-cell-header">September 8 2010</td>
  <td class="ic3-mdx-result-cell-header">September 9 2010</td>
  <td class="ic3-mdx-result-cell-header">September 10 2010</td>
  <td class="ic3-mdx-result-cell-header">September 11 2010</td>
  <td class="ic3-mdx-result-cell-header">September 12 2010</td>
  <td class="ic3-mdx-result-cell-header">September 13 2010</td>
  <td class="ic3-mdx-result-cell-header">September 14 2010</td>
  <td class="ic3-mdx-result-cell-header">September 15 2010</td>
  <td class="ic3-mdx-result-cell-header">September 16 2010</td>
  <td class="ic3-mdx-result-cell-header">September 17 2010</td>
  <td class="ic3-mdx-result-cell-header">September 18 2010</td>
  <td class="ic3-mdx-result-cell-header">September 19 2010</td>
  <td class="ic3-mdx-result-cell-header">September 20 2010</td>
  <td class="ic3-mdx-result-cell-header">September 21 2010</td>
  <td class="ic3-mdx-result-cell-header">September 22 2010</td>
  <td class="ic3-mdx-result-cell-header">September 23 2010</td>
  <td class="ic3-mdx-result-cell-header">September 24 2010</td>
  <td class="ic3-mdx-result-cell-header">September 25 2010</td>
  <td class="ic3-mdx-result-cell-header">September 26 2010</td>
  <td class="ic3-mdx-result-cell-header">September 27 2010</td>
  <td class="ic3-mdx-result-cell-header">September 28 2010</td>
  <td class="ic3-mdx-result-cell-header">September 29 2010</td>
  <td class="ic3-mdx-result-cell-header">September 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q4 2010</td>
  <td class="ic3-mdx-result-cell-header">Oct 2010</td>
  <td class="ic3-mdx-result-cell-header">October 1 2010</td>
  <td class="ic3-mdx-result-cell-header">October 2 2010</td>
  <td class="ic3-mdx-result-cell-header">October 3 2010</td>
  <td class="ic3-mdx-result-cell-header">October 4 2010</td>
  <td class="ic3-mdx-result-cell-header">October 5 2010</td>
  <td class="ic3-mdx-result-cell-header">October 6 2010</td>
  <td class="ic3-mdx-result-cell-header">October 7 2010</td>
  <td class="ic3-mdx-result-cell-header">October 8 2010</td>
  <td class="ic3-mdx-result-cell-header">October 9 2010</td>
  <td class="ic3-mdx-result-cell-header">October 10 2010</td>
  <td class="ic3-mdx-result-cell-header">October 11 2010</td>
  <td class="ic3-mdx-result-cell-header">October 12 2010</td>
  <td class="ic3-mdx-result-cell-header">October 13 2010</td>
  <td class="ic3-mdx-result-cell-header">October 14 2010</td>
  <td class="ic3-mdx-result-cell-header">October 15 2010</td>
  <td class="ic3-mdx-result-cell-header">October 16 2010</td>
  <td class="ic3-mdx-result-cell-header">October 17 2010</td>
  <td class="ic3-mdx-result-cell-header">October 18 2010</td>
  <td class="ic3-mdx-result-cell-header">October 19 2010</td>
  <td class="ic3-mdx-result-cell-header">October 20 2010</td>
  <td class="ic3-mdx-result-cell-header">October 21 2010</td>
  <td class="ic3-mdx-result-cell-header">October 22 2010</td>
  <td class="ic3-mdx-result-cell-header">October 23 2010</td>
  <td class="ic3-mdx-result-cell-header">October 24 2010</td>
  <td class="ic3-mdx-result-cell-header">October 25 2010</td>
  <td class="ic3-mdx-result-cell-header">October 26 2010</td>
  <td class="ic3-mdx-result-cell-header">October 27 2010</td>
  <td class="ic3-mdx-result-cell-header">October 28 2010</td>
  <td class="ic3-mdx-result-cell-header">October 29 2010</td>
  <td class="ic3-mdx-result-cell-header">October 30 2010</td>
  <td class="ic3-mdx-result-cell-header">October 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Nov 2010</td>
  <td class="ic3-mdx-result-cell-header">November 1 2010</td>
  <td class="ic3-mdx-result-cell-header">November 2 2010</td>
  <td class="ic3-mdx-result-cell-header">November 3 2010</td>
  <td class="ic3-mdx-result-cell-header">November 4 2010</td>
  <td class="ic3-mdx-result-cell-header">November 5 2010</td>
  <td class="ic3-mdx-result-cell-header">November 6 2010</td>
  <td class="ic3-mdx-result-cell-header">November 7 2010</td>
  <td class="ic3-mdx-result-cell-header">November 8 2010</td>
  <td class="ic3-mdx-result-cell-header">November 9 2010</td>
  <td class="ic3-mdx-result-cell-header">November 10 2010</td>
  <td class="ic3-mdx-result-cell-header">November 11 2010</td>
  <td class="ic3-mdx-result-cell-header">November 12 2010</td>
  <td class="ic3-mdx-result-cell-header">November 13 2010</td>
  <td class="ic3-mdx-result-cell-header">November 14 2010</td>
  <td class="ic3-mdx-result-cell-header">November 15 2010</td>
  <td class="ic3-mdx-result-cell-header">November 16 2010</td>
  <td class="ic3-mdx-result-cell-header">November 17 2010</td>
  <td class="ic3-mdx-result-cell-header">November 18 2010</td>
  <td class="ic3-mdx-result-cell-header">November 19 2010</td>
  <td class="ic3-mdx-result-cell-header">November 20 2010</td>
  <td class="ic3-mdx-result-cell-header">November 21 2010</td>
  <td class="ic3-mdx-result-cell-header">November 22 2010</td>
  <td class="ic3-mdx-result-cell-header">November 23 2010</td>
  <td class="ic3-mdx-result-cell-header">November 24 2010</td>
  <td class="ic3-mdx-result-cell-header">November 25 2010</td>
  <td class="ic3-mdx-result-cell-header">November 26 2010</td>
  <td class="ic3-mdx-result-cell-header">November 27 2010</td>
  <td class="ic3-mdx-result-cell-header">November 28 2010</td>
  <td class="ic3-mdx-result-cell-header">November 29 2010</td>
  <td class="ic3-mdx-result-cell-header">November 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Dec 2010</td>
  <td class="ic3-mdx-result-cell-header">December 1 2010</td>
  <td class="ic3-mdx-result-cell-header">December 2 2010</td>
  <td class="ic3-mdx-result-cell-header">December 3 2010</td>
  <td class="ic3-mdx-result-cell-header">December 4 2010</td>
  <td class="ic3-mdx-result-cell-header">December 5 2010</td>
  <td class="ic3-mdx-result-cell-header">December 6 2010</td>
  <td class="ic3-mdx-result-cell-header">December 7 2010</td>
  <td class="ic3-mdx-result-cell-header">December 8 2010</td>
  <td class="ic3-mdx-result-cell-header">December 9 2010</td>
  <td class="ic3-mdx-result-cell-header">December 10 2010</td>
  <td class="ic3-mdx-result-cell-header">December 11 2010</td>
  <td class="ic3-mdx-result-cell-header">December 12 2010</td>
  <td class="ic3-mdx-result-cell-header">December 13 2010</td>
  <td class="ic3-mdx-result-cell-header">December 14 2010</td>
  <td class="ic3-mdx-result-cell-header">December 15 2010</td>
  <td class="ic3-mdx-result-cell-header">December 16 2010</td>
  <td class="ic3-mdx-result-cell-header">December 17 2010</td>
  <td class="ic3-mdx-result-cell-header">December 18 2010</td>
  <td class="ic3-mdx-result-cell-header">December 19 2010</td>
  <td class="ic3-mdx-result-cell-header">December 20 2010</td>
  <td class="ic3-mdx-result-cell-header">December 21 2010</td>
  <td class="ic3-mdx-result-cell-header">December 22 2010</td>
  <td class="ic3-mdx-result-cell-header">December 23 2010</td>
  <td class="ic3-mdx-result-cell-header">December 24 2010</td>
  <td class="ic3-mdx-result-cell-header">December 25 2010</td>
  <td class="ic3-mdx-result-cell-header">December 26 2010</td>
  <td class="ic3-mdx-result-cell-header">December 27 2010</td>
  <td class="ic3-mdx-result-cell-header">December 28 2010</td>
  <td class="ic3-mdx-result-cell-header">December 29 2010</td>
  <td class="ic3-mdx-result-cell-header">December 30 2010</td>
  <td class="ic3-mdx-result-cell-header">December 31 2010</td>
  <td class="ic3-mdx-result-cell-header">2011</td>
  <td class="ic3-mdx-result-cell-header">Q1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jan 2011</td>
  <td class="ic3-mdx-result-cell-header">January 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Feb 2011</td>
  <td class="ic3-mdx-result-cell-header">February 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Mar 2011</td>
  <td class="ic3-mdx-result-cell-header">March 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q2 2011</td>
  <td class="ic3-mdx-result-cell-header">Apr 2011</td>
  <td class="ic3-mdx-result-cell-header">April 1 2011</td>
  <td class="ic3-mdx-result-cell-header">May 2011</td>
  <td class="ic3-mdx-result-cell-header">May 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jun 2011</td>
  <td class="ic3-mdx-result-cell-header">June 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q3 2011</td>
  <td class="ic3-mdx-result-cell-header">Jul 2011</td>
  <td class="ic3-mdx-result-cell-header">July 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Aug 2011</td>
  <td class="ic3-mdx-result-cell-header">August 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Sep 2011</td>
  <td class="ic3-mdx-result-cell-header">September 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q4 2011</td>
  <td class="ic3-mdx-result-cell-header">Oct 2011</td>
  <td class="ic3-mdx-result-cell-header">October 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Nov 2011</td>
  <td class="ic3-mdx-result-cell-header">November 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Dec 2011</td>
  <td class="ic3-mdx-result-cell-header">December 1 2011</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">January 1 2010</td>
  <td class="ic3-mdx-result-cell-header">January 2 2010</td>
  <td class="ic3-mdx-result-cell-header">January 3 2010</td>
  <td class="ic3-mdx-result-cell-header">January 4 2010</td>
  <td class="ic3-mdx-result-cell-header">January 5 2010</td>
  <td class="ic3-mdx-result-cell-header">January 6 2010</td>
  <td class="ic3-mdx-result-cell-header">January 7 2010</td>
  <td class="ic3-mdx-result-cell-header">January 8 2010</td>
  <td class="ic3-mdx-result-cell-header">January 9 2010</td>
  <td class="ic3-mdx-result-cell-header">January 10 2010</td>
  <td class="ic3-mdx-result-cell-header">January 11 2010</td>
  <td class="ic3-mdx-result-cell-header">January 12 2010</td>
  <td class="ic3-mdx-result-cell-header">January 13 2010</td>
  <td class="ic3-mdx-result-cell-header">January 14 2010</td>
  <td class="ic3-mdx-result-cell-header">January 15 2010</td>
  <td class="ic3-mdx-result-cell-header">January 16 2010</td>
  <td class="ic3-mdx-result-cell-header">January 17 2010</td>
  <td class="ic3-mdx-result-cell-header">January 18 2010</td>
  <td class="ic3-mdx-result-cell-header">January 19 2010</td>
  <td class="ic3-mdx-result-cell-header">January 20 2010</td>
  <td class="ic3-mdx-result-cell-header">January 21 2010</td>
  <td class="ic3-mdx-result-cell-header">January 22 2010</td>
  <td class="ic3-mdx-result-cell-header">January 23 2010</td>
  <td class="ic3-mdx-result-cell-header">January 24 2010</td>
  <td class="ic3-mdx-result-cell-header">January 25 2010</td>
  <td class="ic3-mdx-result-cell-header">January 26 2010</td>
  <td class="ic3-mdx-result-cell-header">January 27 2010</td>
  <td class="ic3-mdx-result-cell-header">January 28 2010</td>
  <td class="ic3-mdx-result-cell-header">January 29 2010</td>
  <td class="ic3-mdx-result-cell-header">January 30 2010</td>
  <td class="ic3-mdx-result-cell-header">January 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">February 1 2010</td>
  <td class="ic3-mdx-result-cell-header">February 2 2010</td>
  <td class="ic3-mdx-result-cell-header">February 3 2010</td>
  <td class="ic3-mdx-result-cell-header">February 4 2010</td>
  <td class="ic3-mdx-result-cell-header">February 5 2010</td>
  <td class="ic3-mdx-result-cell-header">February 6 2010</td>
  <td class="ic3-mdx-result-cell-header">February 7 2010</td>
  <td class="ic3-mdx-result-cell-header">February 8 2010</td>
  <td class="ic3-mdx-result-cell-header">February 9 2010</td>
  <td class="ic3-mdx-result-cell-header">February 10 2010</td>
  <td class="ic3-mdx-result-cell-header">February 11 2010</td>
  <td class="ic3-mdx-result-cell-header">February 12 2010</td>
  <td class="ic3-mdx-result-cell-header">February 13 2010</td>
  <td class="ic3-mdx-result-cell-header">February 14 2010</td>
  <td class="ic3-mdx-result-cell-header">February 15 2010</td>
  <td class="ic3-mdx-result-cell-header">February 16 2010</td>
  <td class="ic3-mdx-result-cell-header">February 17 2010</td>
  <td class="ic3-mdx-result-cell-header">February 18 2010</td>
  <td class="ic3-mdx-result-cell-header">February 19 2010</td>
  <td class="ic3-mdx-result-cell-header">February 20 2010</td>
  <td class="ic3-mdx-result-cell-header">February 21 2010</td>
  <td class="ic3-mdx-result-cell-header">February 22 2010</td>
  <td class="ic3-mdx-result-cell-header">February 23 2010</td>
  <td class="ic3-mdx-result-cell-header">February 24 2010</td>
  <td class="ic3-mdx-result-cell-header">February 25 2010</td>
  <td class="ic3-mdx-result-cell-header">February 26 2010</td>
  <td class="ic3-mdx-result-cell-header">February 27 2010</td>
  <td class="ic3-mdx-result-cell-header">February 28 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
  <td class="ic3-mdx-result-cell-header">March 1 2010</td>
  <td class="ic3-mdx-result-cell-header">March 2 2010</td>
  <td class="ic3-mdx-result-cell-header">March 3 2010</td>
  <td class="ic3-mdx-result-cell-header">March 4 2010</td>
  <td class="ic3-mdx-result-cell-header">March 5 2010</td>
  <td class="ic3-mdx-result-cell-header">March 6 2010</td>
  <td class="ic3-mdx-result-cell-header">March 7 2010</td>
  <td class="ic3-mdx-result-cell-header">March 8 2010</td>
  <td class="ic3-mdx-result-cell-header">March 9 2010</td>
  <td class="ic3-mdx-result-cell-header">March 10 2010</td>
  <td class="ic3-mdx-result-cell-header">March 11 2010</td>
  <td class="ic3-mdx-result-cell-header">March 12 2010</td>
  <td class="ic3-mdx-result-cell-header">March 13 2010</td>
  <td class="ic3-mdx-result-cell-header">March 14 2010</td>
  <td class="ic3-mdx-result-cell-header">March 15 2010</td>
  <td class="ic3-mdx-result-cell-header">March 16 2010</td>
  <td class="ic3-mdx-result-cell-header">March 17 2010</td>
  <td class="ic3-mdx-result-cell-header">March 18 2010</td>
  <td class="ic3-mdx-result-cell-header">March 19 2010</td>
  <td class="ic3-mdx-result-cell-header">March 20 2010</td>
  <td class="ic3-mdx-result-cell-header">March 21 2010</td>
  <td class="ic3-mdx-result-cell-header">March 22 2010</td>
  <td class="ic3-mdx-result-cell-header">March 23 2010</td>
  <td class="ic3-mdx-result-cell-header">March 24 2010</td>
  <td class="ic3-mdx-result-cell-header">March 25 2010</td>
  <td class="ic3-mdx-result-cell-header">March 26 2010</td>
  <td class="ic3-mdx-result-cell-header">March 27 2010</td>
  <td class="ic3-mdx-result-cell-header">March 28 2010</td>
  <td class="ic3-mdx-result-cell-header">March 29 2010</td>
  <td class="ic3-mdx-result-cell-header">March 30 2010</td>
  <td class="ic3-mdx-result-cell-header">March 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
  <td class="ic3-mdx-result-cell-header">Apr 2010</td>
  <td class="ic3-mdx-result-cell-header">April 1 2010</td>
  <td class="ic3-mdx-result-cell-header">April 2 2010</td>
  <td class="ic3-mdx-result-cell-header">April 3 2010</td>
  <td class="ic3-mdx-result-cell-header">April 4 2010</td>
  <td class="ic3-mdx-result-cell-header">April 5 2010</td>
  <td class="ic3-mdx-result-cell-header">April 6 2010</td>
  <td class="ic3-mdx-result-cell-header">April 7 2010</td>
  <td class="ic3-mdx-result-cell-header">April 8 2010</td>
  <td class="ic3-mdx-result-cell-header">April 9 2010</td>
  <td class="ic3-mdx-result-cell-header">April 10 2010</td>
  <td class="ic3-mdx-result-cell-header">April 11 2010</td>
  <td class="ic3-mdx-result-cell-header">April 12 2010</td>
  <td class="ic3-mdx-result-cell-header">April 13 2010</td>
  <td class="ic3-mdx-result-cell-header">April 14 2010</td>
  <td class="ic3-mdx-result-cell-header">April 15 2010</td>
  <td class="ic3-mdx-result-cell-header">April 16 2010</td>
  <td class="ic3-mdx-result-cell-header">April 17 2010</td>
  <td class="ic3-mdx-result-cell-header">April 18 2010</td>
  <td class="ic3-mdx-result-cell-header">April 19 2010</td>
  <td class="ic3-mdx-result-cell-header">April 20 2010</td>
  <td class="ic3-mdx-result-cell-header">April 21 2010</td>
  <td class="ic3-mdx-result-cell-header">April 22 2010</td>
  <td class="ic3-mdx-result-cell-header">April 23 2010</td>
  <td class="ic3-mdx-result-cell-header">April 24 2010</td>
  <td class="ic3-mdx-result-cell-header">April 25 2010</td>
  <td class="ic3-mdx-result-cell-header">April 26 2010</td>
  <td class="ic3-mdx-result-cell-header">April 27 2010</td>
  <td class="ic3-mdx-result-cell-header">April 28 2010</td>
  <td class="ic3-mdx-result-cell-header">April 29 2010</td>
  <td class="ic3-mdx-result-cell-header">April 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2010</td>
  <td class="ic3-mdx-result-cell-header">May 1 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2 2010</td>
  <td class="ic3-mdx-result-cell-header">May 3 2010</td>
  <td class="ic3-mdx-result-cell-header">May 4 2010</td>
  <td class="ic3-mdx-result-cell-header">May 5 2010</td>
  <td class="ic3-mdx-result-cell-header">May 6 2010</td>
  <td class="ic3-mdx-result-cell-header">May 7 2010</td>
  <td class="ic3-mdx-result-cell-header">May 8 2010</td>
  <td class="ic3-mdx-result-cell-header">May 9 2010</td>
  <td class="ic3-mdx-result-cell-header">May 10 2010</td>
  <td class="ic3-mdx-result-cell-header">May 11 2010</td>
  <td class="ic3-mdx-result-cell-header">May 12 2010</td>
  <td class="ic3-mdx-result-cell-header">May 13 2010</td>
  <td class="ic3-mdx-result-cell-header">May 14 2010</td>
  <td class="ic3-mdx-result-cell-header">May 15 2010</td>
  <td class="ic3-mdx-result-cell-header">May 16 2010</td>
  <td class="ic3-mdx-result-cell-header">May 17 2010</td>
  <td class="ic3-mdx-result-cell-header">May 18 2010</td>
  <td class="ic3-mdx-result-cell-header">May 19 2010</td>
  <td class="ic3-mdx-result-cell-header">May 20 2010</td>
  <td class="ic3-mdx-result-cell-header">May 21 2010</td>
  <td class="ic3-mdx-result-cell-header">May 22 2010</td>
  <td class="ic3-mdx-result-cell-header">May 23 2010</td>
  <td class="ic3-mdx-result-cell-header">May 24 2010</td>
  <td class="ic3-mdx-result-cell-header">May 25 2010</td>
  <td class="ic3-mdx-result-cell-header">May 26 2010</td>
  <td class="ic3-mdx-result-cell-header">May 27 2010</td>
  <td class="ic3-mdx-result-cell-header">May 28 2010</td>
  <td class="ic3-mdx-result-cell-header">May 29 2010</td>
  <td class="ic3-mdx-result-cell-header">May 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Jun 2010</td>
  <td class="ic3-mdx-result-cell-header">June 1 2010</td>
  <td class="ic3-mdx-result-cell-header">June 2 2010</td>
  <td class="ic3-mdx-result-cell-header">June 3 2010</td>
  <td class="ic3-mdx-result-cell-header">June 4 2010</td>
  <td class="ic3-mdx-result-cell-header">June 5 2010</td>
  <td class="ic3-mdx-result-cell-header">June 6 2010</td>
  <td class="ic3-mdx-result-cell-header">June 7 2010</td>
  <td class="ic3-mdx-result-cell-header">June 8 2010</td>
  <td class="ic3-mdx-result-cell-header">June 9 2010</td>
  <td class="ic3-mdx-result-cell-header">June 10 2010</td>
  <td class="ic3-mdx-result-cell-header">June 11 2010</td>
  <td class="ic3-mdx-result-cell-header">June 12 2010</td>
  <td class="ic3-mdx-result-cell-header">June 13 2010</td>
  <td class="ic3-mdx-result-cell-header">June 14 2010</td>
  <td class="ic3-mdx-result-cell-header">June 15 2010</td>
  <td class="ic3-mdx-result-cell-header">June 16 2010</td>
  <td class="ic3-mdx-result-cell-header">June 17 2010</td>
  <td class="ic3-mdx-result-cell-header">June 18 2010</td>
  <td class="ic3-mdx-result-cell-header">June 19 2010</td>
  <td class="ic3-mdx-result-cell-header">June 20 2010</td>
  <td class="ic3-mdx-result-cell-header">June 21 2010</td>
  <td class="ic3-mdx-result-cell-header">June 22 2010</td>
  <td class="ic3-mdx-result-cell-header">June 23 2010</td>
  <td class="ic3-mdx-result-cell-header">June 24 2010</td>
  <td class="ic3-mdx-result-cell-header">June 25 2010</td>
  <td class="ic3-mdx-result-cell-header">June 26 2010</td>
  <td class="ic3-mdx-result-cell-header">June 27 2010</td>
  <td class="ic3-mdx-result-cell-header">June 28 2010</td>
  <td class="ic3-mdx-result-cell-header">June 29 2010</td>
  <td class="ic3-mdx-result-cell-header">June 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q3 2010</td>
  <td class="ic3-mdx-result-cell-header">Jul 2010</td>
  <td class="ic3-mdx-result-cell-header">July 1 2010</td>
  <td class="ic3-mdx-result-cell-header">July 2 2010</td>
  <td class="ic3-mdx-result-cell-header">July 3 2010</td>
  <td class="ic3-mdx-result-cell-header">July 4 2010</td>
  <td class="ic3-mdx-result-cell-header">July 5 2010</td>
  <td class="ic3-mdx-result-cell-header">July 6 2010</td>
  <td class="ic3-mdx-result-cell-header">July 7 2010</td>
  <td class="ic3-mdx-result-cell-header">July 8 2010</td>
  <td class="ic3-mdx-result-cell-header">July 9 2010</td>
  <td class="ic3-mdx-result-cell-header">July 10 2010</td>
  <td class="ic3-mdx-result-cell-header">July 11 2010</td>
  <td class="ic3-mdx-result-cell-header">July 12 2010</td>
  <td class="ic3-mdx-result-cell-header">July 13 2010</td>
  <td class="ic3-mdx-result-cell-header">July 14 2010</td>
  <td class="ic3-mdx-result-cell-header">July 15 2010</td>
  <td class="ic3-mdx-result-cell-header">July 16 2010</td>
  <td class="ic3-mdx-result-cell-header">July 17 2010</td>
  <td class="ic3-mdx-result-cell-header">July 18 2010</td>
  <td class="ic3-mdx-result-cell-header">July 19 2010</td>
  <td class="ic3-mdx-result-cell-header">July 20 2010</td>
  <td class="ic3-mdx-result-cell-header">July 21 2010</td>
  <td class="ic3-mdx-result-cell-header">July 22 2010</td>
  <td class="ic3-mdx-result-cell-header">July 23 2010</td>
  <td class="ic3-mdx-result-cell-header">July 24 2010</td>
  <td class="ic3-mdx-result-cell-header">July 25 2010</td>
  <td class="ic3-mdx-result-cell-header">July 26 2010</td>
  <td class="ic3-mdx-result-cell-header">July 27 2010</td>
  <td class="ic3-mdx-result-cell-header">July 28 2010</td>
  <td class="ic3-mdx-result-cell-header">July 29 2010</td>
  <td class="ic3-mdx-result-cell-header">July 30 2010</td>
  <td class="ic3-mdx-result-cell-header">July 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Aug 2010</td>
  <td class="ic3-mdx-result-cell-header">August 1 2010</td>
  <td class="ic3-mdx-result-cell-header">August 2 2010</td>
  <td class="ic3-mdx-result-cell-header">August 3 2010</td>
  <td class="ic3-mdx-result-cell-header">August 4 2010</td>
  <td class="ic3-mdx-result-cell-header">August 5 2010</td>
  <td class="ic3-mdx-result-cell-header">August 6 2010</td>
  <td class="ic3-mdx-result-cell-header">August 7 2010</td>
  <td class="ic3-mdx-result-cell-header">August 8 2010</td>
  <td class="ic3-mdx-result-cell-header">August 9 2010</td>
  <td class="ic3-mdx-result-cell-header">August 10 2010</td>
  <td class="ic3-mdx-result-cell-header">August 11 2010</td>
  <td class="ic3-mdx-result-cell-header">August 12 2010</td>
  <td class="ic3-mdx-result-cell-header">August 13 2010</td>
  <td class="ic3-mdx-result-cell-header">August 14 2010</td>
  <td class="ic3-mdx-result-cell-header">August 15 2010</td>
  <td class="ic3-mdx-result-cell-header">August 16 2010</td>
  <td class="ic3-mdx-result-cell-header">August 17 2010</td>
  <td class="ic3-mdx-result-cell-header">August 18 2010</td>
  <td class="ic3-mdx-result-cell-header">August 19 2010</td>
  <td class="ic3-mdx-result-cell-header">August 20 2010</td>
  <td class="ic3-mdx-result-cell-header">August 21 2010</td>
  <td class="ic3-mdx-result-cell-header">August 22 2010</td>
  <td class="ic3-mdx-result-cell-header">August 23 2010</td>
  <td class="ic3-mdx-result-cell-header">August 24 2010</td>
  <td class="ic3-mdx-result-cell-header">August 25 2010</td>
  <td class="ic3-mdx-result-cell-header">August 26 2010</td>
  <td class="ic3-mdx-result-cell-header">August 27 2010</td>
  <td class="ic3-mdx-result-cell-header">August 28 2010</td>
  <td class="ic3-mdx-result-cell-header">August 29 2010</td>
  <td class="ic3-mdx-result-cell-header">August 30 2010</td>
  <td class="ic3-mdx-result-cell-header">August 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Sep 2010</td>
  <td class="ic3-mdx-result-cell-header">September 1 2010</td>
  <td class="ic3-mdx-result-cell-header">September 2 2010</td>
  <td class="ic3-mdx-result-cell-header">September 3 2010</td>
  <td class="ic3-mdx-result-cell-header">September 4 2010</td>
  <td class="ic3-mdx-result-cell-header">September 5 2010</td>
  <td class="ic3-mdx-result-cell-header">September 6 2010</td>
  <td class="ic3-mdx-result-cell-header">September 7 2010</td>
  <td class="ic3-mdx-result-cell-header">September 8 2010</td>
  <td class="ic3-mdx-result-cell-header">September 9 2010</td>
  <td class="ic3-mdx-result-cell-header">September 10 2010</td>
  <td class="ic3-mdx-result-cell-header">September 11 2010</td>
  <td class="ic3-mdx-result-cell-header">September 12 2010</td>
  <td class="ic3-mdx-result-cell-header">September 13 2010</td>
  <td class="ic3-mdx-result-cell-header">September 14 2010</td>
  <td class="ic3-mdx-result-cell-header">September 15 2010</td>
  <td class="ic3-mdx-result-cell-header">September 16 2010</td>
  <td class="ic3-mdx-result-cell-header">September 17 2010</td>
  <td class="ic3-mdx-result-cell-header">September 18 2010</td>
  <td class="ic3-mdx-result-cell-header">September 19 2010</td>
  <td class="ic3-mdx-result-cell-header">September 20 2010</td>
  <td class="ic3-mdx-result-cell-header">September 21 2010</td>
  <td class="ic3-mdx-result-cell-header">September 22 2010</td>
  <td class="ic3-mdx-result-cell-header">September 23 2010</td>
  <td class="ic3-mdx-result-cell-header">September 24 2010</td>
  <td class="ic3-mdx-result-cell-header">September 25 2010</td>
  <td class="ic3-mdx-result-cell-header">September 26 2010</td>
  <td class="ic3-mdx-result-cell-header">September 27 2010</td>
  <td class="ic3-mdx-result-cell-header">September 28 2010</td>
  <td class="ic3-mdx-result-cell-header">September 29 2010</td>
  <td class="ic3-mdx-result-cell-header">September 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q4 2010</td>
  <td class="ic3-mdx-result-cell-header">Oct 2010</td>
  <td class="ic3-mdx-result-cell-header">October 1 2010</td>
  <td class="ic3-mdx-result-cell-header">October 2 2010</td>
  <td class="ic3-mdx-result-cell-header">October 3 2010</td>
  <td class="ic3-mdx-result-cell-header">October 4 2010</td>
  <td class="ic3-mdx-result-cell-header">October 5 2010</td>
  <td class="ic3-mdx-result-cell-header">October 6 2010</td>
  <td class="ic3-mdx-result-cell-header">October 7 2010</td>
  <td class="ic3-mdx-result-cell-header">October 8 2010</td>
  <td class="ic3-mdx-result-cell-header">October 9 2010</td>
  <td class="ic3-mdx-result-cell-header">October 10 2010</td>
  <td class="ic3-mdx-result-cell-header">October 11 2010</td>
  <td class="ic3-mdx-result-cell-header">October 12 2010</td>
  <td class="ic3-mdx-result-cell-header">October 13 2010</td>
  <td class="ic3-mdx-result-cell-header">October 14 2010</td>
  <td class="ic3-mdx-result-cell-header">October 15 2010</td>
  <td class="ic3-mdx-result-cell-header">October 16 2010</td>
  <td class="ic3-mdx-result-cell-header">October 17 2010</td>
  <td class="ic3-mdx-result-cell-header">October 18 2010</td>
  <td class="ic3-mdx-result-cell-header">October 19 2010</td>
  <td class="ic3-mdx-result-cell-header">October 20 2010</td>
  <td class="ic3-mdx-result-cell-header">October 21 2010</td>
  <td class="ic3-mdx-result-cell-header">October 22 2010</td>
  <td class="ic3-mdx-result-cell-header">October 23 2010</td>
  <td class="ic3-mdx-result-cell-header">October 24 2010</td>
  <td class="ic3-mdx-result-cell-header">October 25 2010</td>
  <td class="ic3-mdx-result-cell-header">October 26 2010</td>
  <td class="ic3-mdx-result-cell-header">October 27 2010</td>
  <td class="ic3-mdx-result-cell-header">October 28 2010</td>
  <td class="ic3-mdx-result-cell-header">October 29 2010</td>
  <td class="ic3-mdx-result-cell-header">October 30 2010</td>
  <td class="ic3-mdx-result-cell-header">October 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Nov 2010</td>
  <td class="ic3-mdx-result-cell-header">November 1 2010</td>
  <td class="ic3-mdx-result-cell-header">November 2 2010</td>
  <td class="ic3-mdx-result-cell-header">November 3 2010</td>
  <td class="ic3-mdx-result-cell-header">November 4 2010</td>
  <td class="ic3-mdx-result-cell-header">November 5 2010</td>
  <td class="ic3-mdx-result-cell-header">November 6 2010</td>
  <td class="ic3-mdx-result-cell-header">November 7 2010</td>
  <td class="ic3-mdx-result-cell-header">November 8 2010</td>
  <td class="ic3-mdx-result-cell-header">November 9 2010</td>
  <td class="ic3-mdx-result-cell-header">November 10 2010</td>
  <td class="ic3-mdx-result-cell-header">November 11 2010</td>
  <td class="ic3-mdx-result-cell-header">November 12 2010</td>
  <td class="ic3-mdx-result-cell-header">November 13 2010</td>
  <td class="ic3-mdx-result-cell-header">November 14 2010</td>
  <td class="ic3-mdx-result-cell-header">November 15 2010</td>
  <td class="ic3-mdx-result-cell-header">November 16 2010</td>
  <td class="ic3-mdx-result-cell-header">November 17 2010</td>
  <td class="ic3-mdx-result-cell-header">November 18 2010</td>
  <td class="ic3-mdx-result-cell-header">November 19 2010</td>
  <td class="ic3-mdx-result-cell-header">November 20 2010</td>
  <td class="ic3-mdx-result-cell-header">November 21 2010</td>
  <td class="ic3-mdx-result-cell-header">November 22 2010</td>
  <td class="ic3-mdx-result-cell-header">November 23 2010</td>
  <td class="ic3-mdx-result-cell-header">November 24 2010</td>
  <td class="ic3-mdx-result-cell-header">November 25 2010</td>
  <td class="ic3-mdx-result-cell-header">November 26 2010</td>
  <td class="ic3-mdx-result-cell-header">November 27 2010</td>
  <td class="ic3-mdx-result-cell-header">November 28 2010</td>
  <td class="ic3-mdx-result-cell-header">November 29 2010</td>
  <td class="ic3-mdx-result-cell-header">November 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Dec 2010</td>
  <td class="ic3-mdx-result-cell-header">December 1 2010</td>
  <td class="ic3-mdx-result-cell-header">December 2 2010</td>
  <td class="ic3-mdx-result-cell-header">December 3 2010</td>
  <td class="ic3-mdx-result-cell-header">December 4 2010</td>
  <td class="ic3-mdx-result-cell-header">December 5 2010</td>
  <td class="ic3-mdx-result-cell-header">December 6 2010</td>
  <td class="ic3-mdx-result-cell-header">December 7 2010</td>
  <td class="ic3-mdx-result-cell-header">December 8 2010</td>
  <td class="ic3-mdx-result-cell-header">December 9 2010</td>
  <td class="ic3-mdx-result-cell-header">December 10 2010</td>
  <td class="ic3-mdx-result-cell-header">December 11 2010</td>
  <td class="ic3-mdx-result-cell-header">December 12 2010</td>
  <td class="ic3-mdx-result-cell-header">December 13 2010</td>
  <td class="ic3-mdx-result-cell-header">December 14 2010</td>
  <td class="ic3-mdx-result-cell-header">December 15 2010</td>
  <td class="ic3-mdx-result-cell-header">December 16 2010</td>
  <td class="ic3-mdx-result-cell-header">December 17 2010</td>
  <td class="ic3-mdx-result-cell-header">December 18 2010</td>
  <td class="ic3-mdx-result-cell-header">December 19 2010</td>
  <td class="ic3-mdx-result-cell-header">December 20 2010</td>
  <td class="ic3-mdx-result-cell-header">December 21 2010</td>
  <td class="ic3-mdx-result-cell-header">December 22 2010</td>
  <td class="ic3-mdx-result-cell-header">December 23 2010</td>
  <td class="ic3-mdx-result-cell-header">December 24 2010</td>
  <td class="ic3-mdx-result-cell-header">December 25 2010</td>
  <td class="ic3-mdx-result-cell-header">December 26 2010</td>
  <td class="ic3-mdx-result-cell-header">December 27 2010</td>
  <td class="ic3-mdx-result-cell-header">December 28 2010</td>
  <td class="ic3-mdx-result-cell-header">December 29 2010</td>
  <td class="ic3-mdx-result-cell-header">December 30 2010</td>
  <td class="ic3-mdx-result-cell-header">December 31 2010</td>
  <td class="ic3-mdx-result-cell-header">2011</td>
  <td class="ic3-mdx-result-cell-header">Q1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jan 2011</td>
  <td class="ic3-mdx-result-cell-header">January 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Feb 2011</td>
  <td class="ic3-mdx-result-cell-header">February 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Mar 2011</td>
  <td class="ic3-mdx-result-cell-header">March 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q2 2011</td>
  <td class="ic3-mdx-result-cell-header">Apr 2011</td>
  <td class="ic3-mdx-result-cell-header">April 1 2011</td>
  <td class="ic3-mdx-result-cell-header">May 2011</td>
  <td class="ic3-mdx-result-cell-header">May 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jun 2011</td>
  <td class="ic3-mdx-result-cell-header">June 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q3 2011</td>
  <td class="ic3-mdx-result-cell-header">Jul 2011</td>
  <td class="ic3-mdx-result-cell-header">July 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Aug 2011</td>
  <td class="ic3-mdx-result-cell-header">August 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Sep 2011</td>
  <td class="ic3-mdx-result-cell-header">September 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q4 2011</td>
  <td class="ic3-mdx-result-cell-header">Oct 2011</td>
  <td class="ic3-mdx-result-cell-header">October 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Nov 2011</td>
  <td class="ic3-mdx-result-cell-header">November 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Dec 2011</td>
  <td class="ic3-mdx-result-cell-header">December 1 2011</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">January 1 2010</td>
  <td class="ic3-mdx-result-cell-header">January 2 2010</td>
  <td class="ic3-mdx-result-cell-header">January 3 2010</td>
  <td class="ic3-mdx-result-cell-header">January 4 2010</td>
  <td class="ic3-mdx-result-cell-header">January 5 2010</td>
  <td class="ic3-mdx-result-cell-header">January 6 2010</td>
  <td class="ic3-mdx-result-cell-header">January 7 2010</td>
  <td class="ic3-mdx-result-cell-header">January 8 2010</td>
  <td class="ic3-mdx-result-cell-header">January 9 2010</td>
  <td class="ic3-mdx-result-cell-header">January 10 2010</td>
  <td class="ic3-mdx-result-cell-header">January 11 2010</td>
  <td class="ic3-mdx-result-cell-header">January 12 2010</td>
  <td class="ic3-mdx-result-cell-header">January 13 2010</td>
  <td class="ic3-mdx-result-cell-header">January 14 2010</td>
  <td class="ic3-mdx-result-cell-header">January 15 2010</td>
  <td class="ic3-mdx-result-cell-header">January 16 2010</td>
  <td class="ic3-mdx-result-cell-header">January 17 2010</td>
  <td class="ic3-mdx-result-cell-header">January 18 2010</td>
  <td class="ic3-mdx-result-cell-header">January 19 2010</td>
  <td class="ic3-mdx-result-cell-header">January 20 2010</td>
  <td class="ic3-mdx-result-cell-header">January 21 2010</td>
  <td class="ic3-mdx-result-cell-header">January 22 2010</td>
  <td class="ic3-mdx-result-cell-header">January 23 2010</td>
  <td class="ic3-mdx-result-cell-header">January 24 2010</td>
  <td class="ic3-mdx-result-cell-header">January 25 2010</td>
  <td class="ic3-mdx-result-cell-header">January 26 2010</td>
  <td class="ic3-mdx-result-cell-header">January 27 2010</td>
  <td class="ic3-mdx-result-cell-header">January 28 2010</td>
  <td class="ic3-mdx-result-cell-header">January 29 2010</td>
  <td class="ic3-mdx-result-cell-header">January 30 2010</td>
  <td class="ic3-mdx-result-cell-header">January 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">February 1 2010</td>
  <td class="ic3-mdx-result-cell-header">February 2 2010</td>
  <td class="ic3-mdx-result-cell-header">February 3 2010</td>
  <td class="ic3-mdx-result-cell-header">February 4 2010</td>
  <td class="ic3-mdx-result-cell-header">February 5 2010</td>
  <td class="ic3-mdx-result-cell-header">February 6 2010</td>
  <td class="ic3-mdx-result-cell-header">February 7 2010</td>
  <td class="ic3-mdx-result-cell-header">February 8 2010</td>
  <td class="ic3-mdx-result-cell-header">February 9 2010</td>
  <td class="ic3-mdx-result-cell-header">February 10 2010</td>
  <td class="ic3-mdx-result-cell-header">February 11 2010</td>
  <td class="ic3-mdx-result-cell-header">February 12 2010</td>
  <td class="ic3-mdx-result-cell-header">February 13 2010</td>
  <td class="ic3-mdx-result-cell-header">February 14 2010</td>
  <td class="ic3-mdx-result-cell-header">February 15 2010</td>
  <td class="ic3-mdx-result-cell-header">February 16 2010</td>
  <td class="ic3-mdx-result-cell-header">February 17 2010</td>
  <td class="ic3-mdx-result-cell-header">February 18 2010</td>
  <td class="ic3-mdx-result-cell-header">February 19 2010</td>
  <td class="ic3-mdx-result-cell-header">February 20 2010</td>
  <td class="ic3-mdx-result-cell-header">February 21 2010</td>
  <td class="ic3-mdx-result-cell-header">February 22 2010</td>
  <td class="ic3-mdx-result-cell-header">February 23 2010</td>
  <td class="ic3-mdx-result-cell-header">February 24 2010</td>
  <td class="ic3-mdx-result-cell-header">February 25 2010</td>
  <td class="ic3-mdx-result-cell-header">February 26 2010</td>
  <td class="ic3-mdx-result-cell-header">February 27 2010</td>
  <td class="ic3-mdx-result-cell-header">February 28 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
  <td class="ic3-mdx-result-cell-header">March 1 2010</td>
  <td class="ic3-mdx-result-cell-header">March 2 2010</td>
  <td class="ic3-mdx-result-cell-header">March 3 2010</td>
  <td class="ic3-mdx-result-cell-header">March 4 2010</td>
  <td class="ic3-mdx-result-cell-header">March 5 2010</td>
  <td class="ic3-mdx-result-cell-header">March 6 2010</td>
  <td class="ic3-mdx-result-cell-header">March 7 2010</td>
  <td class="ic3-mdx-result-cell-header">March 8 2010</td>
  <td class="ic3-mdx-result-cell-header">March 9 2010</td>
  <td class="ic3-mdx-result-cell-header">March 10 2010</td>
  <td class="ic3-mdx-result-cell-header">March 11 2010</td>
  <td class="ic3-mdx-result-cell-header">March 12 2010</td>
  <td class="ic3-mdx-result-cell-header">March 13 2010</td>
  <td class="ic3-mdx-result-cell-header">March 14 2010</td>
  <td class="ic3-mdx-result-cell-header">March 15 2010</td>
  <td class="ic3-mdx-result-cell-header">March 16 2010</td>
  <td class="ic3-mdx-result-cell-header">March 17 2010</td>
  <td class="ic3-mdx-result-cell-header">March 18 2010</td>
  <td class="ic3-mdx-result-cell-header">March 19 2010</td>
  <td class="ic3-mdx-result-cell-header">March 20 2010</td>
  <td class="ic3-mdx-result-cell-header">March 21 2010</td>
  <td class="ic3-mdx-result-cell-header">March 22 2010</td>
  <td class="ic3-mdx-result-cell-header">March 23 2010</td>
  <td class="ic3-mdx-result-cell-header">March 24 2010</td>
  <td class="ic3-mdx-result-cell-header">March 25 2010</td>
  <td class="ic3-mdx-result-cell-header">March 26 2010</td>
  <td class="ic3-mdx-result-cell-header">March 27 2010</td>
  <td class="ic3-mdx-result-cell-header">March 28 2010</td>
  <td class="ic3-mdx-result-cell-header">March 29 2010</td>
  <td class="ic3-mdx-result-cell-header">March 30 2010</td>
  <td class="ic3-mdx-result-cell-header">March 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
  <td class="ic3-mdx-result-cell-header">Apr 2010</td>
  <td class="ic3-mdx-result-cell-header">April 1 2010</td>
  <td class="ic3-mdx-result-cell-header">April 2 2010</td>
  <td class="ic3-mdx-result-cell-header">April 3 2010</td>
  <td class="ic3-mdx-result-cell-header">April 4 2010</td>
  <td class="ic3-mdx-result-cell-header">April 5 2010</td>
  <td class="ic3-mdx-result-cell-header">April 6 2010</td>
  <td class="ic3-mdx-result-cell-header">April 7 2010</td>
  <td class="ic3-mdx-result-cell-header">April 8 2010</td>
  <td class="ic3-mdx-result-cell-header">April 9 2010</td>
  <td class="ic3-mdx-result-cell-header">April 10 2010</td>
  <td class="ic3-mdx-result-cell-header">April 11 2010</td>
  <td class="ic3-mdx-result-cell-header">April 12 2010</td>
  <td class="ic3-mdx-result-cell-header">April 13 2010</td>
  <td class="ic3-mdx-result-cell-header">April 14 2010</td>
  <td class="ic3-mdx-result-cell-header">April 15 2010</td>
  <td class="ic3-mdx-result-cell-header">April 16 2010</td>
  <td class="ic3-mdx-result-cell-header">April 17 2010</td>
  <td class="ic3-mdx-result-cell-header">April 18 2010</td>
  <td class="ic3-mdx-result-cell-header">April 19 2010</td>
  <td class="ic3-mdx-result-cell-header">April 20 2010</td>
  <td class="ic3-mdx-result-cell-header">April 21 2010</td>
  <td class="ic3-mdx-result-cell-header">April 22 2010</td>
  <td class="ic3-mdx-result-cell-header">April 23 2010</td>
  <td class="ic3-mdx-result-cell-header">April 24 2010</td>
  <td class="ic3-mdx-result-cell-header">April 25 2010</td>
  <td class="ic3-mdx-result-cell-header">April 26 2010</td>
  <td class="ic3-mdx-result-cell-header">April 27 2010</td>
  <td class="ic3-mdx-result-cell-header">April 28 2010</td>
  <td class="ic3-mdx-result-cell-header">April 29 2010</td>
  <td class="ic3-mdx-result-cell-header">April 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2010</td>
  <td class="ic3-mdx-result-cell-header">May 1 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2 2010</td>
  <td class="ic3-mdx-result-cell-header">May 3 2010</td>
  <td class="ic3-mdx-result-cell-header">May 4 2010</td>
  <td class="ic3-mdx-result-cell-header">May 5 2010</td>
  <td class="ic3-mdx-result-cell-header">May 6 2010</td>
  <td class="ic3-mdx-result-cell-header">May 7 2010</td>
  <td class="ic3-mdx-result-cell-header">May 8 2010</td>
  <td class="ic3-mdx-result-cell-header">May 9 2010</td>
  <td class="ic3-mdx-result-cell-header">May 10 2010</td>
  <td class="ic3-mdx-result-cell-header">May 11 2010</td>
  <td class="ic3-mdx-result-cell-header">May 12 2010</td>
  <td class="ic3-mdx-result-cell-header">May 13 2010</td>
  <td class="ic3-mdx-result-cell-header">May 14 2010</td>
  <td class="ic3-mdx-result-cell-header">May 15 2010</td>
  <td class="ic3-mdx-result-cell-header">May 16 2010</td>
  <td class="ic3-mdx-result-cell-header">May 17 2010</td>
  <td class="ic3-mdx-result-cell-header">May 18 2010</td>
  <td class="ic3-mdx-result-cell-header">May 19 2010</td>
  <td class="ic3-mdx-result-cell-header">May 20 2010</td>
  <td class="ic3-mdx-result-cell-header">May 21 2010</td>
  <td class="ic3-mdx-result-cell-header">May 22 2010</td>
  <td class="ic3-mdx-result-cell-header">May 23 2010</td>
  <td class="ic3-mdx-result-cell-header">May 24 2010</td>
  <td class="ic3-mdx-result-cell-header">May 25 2010</td>
  <td class="ic3-mdx-result-cell-header">May 26 2010</td>
  <td class="ic3-mdx-result-cell-header">May 27 2010</td>
  <td class="ic3-mdx-result-cell-header">May 28 2010</td>
  <td class="ic3-mdx-result-cell-header">May 29 2010</td>
  <td class="ic3-mdx-result-cell-header">May 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Jun 2010</td>
  <td class="ic3-mdx-result-cell-header">June 1 2010</td>
  <td class="ic3-mdx-result-cell-header">June 2 2010</td>
  <td class="ic3-mdx-result-cell-header">June 3 2010</td>
  <td class="ic3-mdx-result-cell-header">June 4 2010</td>
  <td class="ic3-mdx-result-cell-header">June 5 2010</td>
  <td class="ic3-mdx-result-cell-header">June 6 2010</td>
  <td class="ic3-mdx-result-cell-header">June 7 2010</td>
  <td class="ic3-mdx-result-cell-header">June 8 2010</td>
  <td class="ic3-mdx-result-cell-header">June 9 2010</td>
  <td class="ic3-mdx-result-cell-header">June 10 2010</td>
  <td class="ic3-mdx-result-cell-header">June 11 2010</td>
  <td class="ic3-mdx-result-cell-header">June 12 2010</td>
  <td class="ic3-mdx-result-cell-header">June 13 2010</td>
  <td class="ic3-mdx-result-cell-header">June 14 2010</td>
  <td class="ic3-mdx-result-cell-header">June 15 2010</td>
  <td class="ic3-mdx-result-cell-header">June 16 2010</td>
  <td class="ic3-mdx-result-cell-header">June 17 2010</td>
  <td class="ic3-mdx-result-cell-header">June 18 2010</td>
  <td class="ic3-mdx-result-cell-header">June 19 2010</td>
  <td class="ic3-mdx-result-cell-header">June 20 2010</td>
  <td class="ic3-mdx-result-cell-header">June 21 2010</td>
  <td class="ic3-mdx-result-cell-header">June 22 2010</td>
  <td class="ic3-mdx-result-cell-header">June 23 2010</td>
  <td class="ic3-mdx-result-cell-header">June 24 2010</td>
  <td class="ic3-mdx-result-cell-header">June 25 2010</td>
  <td class="ic3-mdx-result-cell-header">June 26 2010</td>
  <td class="ic3-mdx-result-cell-header">June 27 2010</td>
  <td class="ic3-mdx-result-cell-header">June 28 2010</td>
  <td class="ic3-mdx-result-cell-header">June 29 2010</td>
  <td class="ic3-mdx-result-cell-header">June 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q3 2010</td>
  <td class="ic3-mdx-result-cell-header">Jul 2010</td>
  <td class="ic3-mdx-result-cell-header">July 1 2010</td>
  <td class="ic3-mdx-result-cell-header">July 2 2010</td>
  <td class="ic3-mdx-result-cell-header">July 3 2010</td>
  <td class="ic3-mdx-result-cell-header">July 4 2010</td>
  <td class="ic3-mdx-result-cell-header">July 5 2010</td>
  <td class="ic3-mdx-result-cell-header">July 6 2010</td>
  <td class="ic3-mdx-result-cell-header">July 7 2010</td>
  <td class="ic3-mdx-result-cell-header">July 8 2010</td>
  <td class="ic3-mdx-result-cell-header">July 9 2010</td>
  <td class="ic3-mdx-result-cell-header">July 10 2010</td>
  <td class="ic3-mdx-result-cell-header">July 11 2010</td>
  <td class="ic3-mdx-result-cell-header">July 12 2010</td>
  <td class="ic3-mdx-result-cell-header">July 13 2010</td>
  <td class="ic3-mdx-result-cell-header">July 14 2010</td>
  <td class="ic3-mdx-result-cell-header">July 15 2010</td>
  <td class="ic3-mdx-result-cell-header">July 16 2010</td>
  <td class="ic3-mdx-result-cell-header">July 17 2010</td>
  <td class="ic3-mdx-result-cell-header">July 18 2010</td>
  <td class="ic3-mdx-result-cell-header">July 19 2010</td>
  <td class="ic3-mdx-result-cell-header">July 20 2010</td>
  <td class="ic3-mdx-result-cell-header">July 21 2010</td>
  <td class="ic3-mdx-result-cell-header">July 22 2010</td>
  <td class="ic3-mdx-result-cell-header">July 23 2010</td>
  <td class="ic3-mdx-result-cell-header">July 24 2010</td>
  <td class="ic3-mdx-result-cell-header">July 25 2010</td>
  <td class="ic3-mdx-result-cell-header">July 26 2010</td>
  <td class="ic3-mdx-result-cell-header">July 27 2010</td>
  <td class="ic3-mdx-result-cell-header">July 28 2010</td>
  <td class="ic3-mdx-result-cell-header">July 29 2010</td>
  <td class="ic3-mdx-result-cell-header">July 30 2010</td>
  <td class="ic3-mdx-result-cell-header">July 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Aug 2010</td>
  <td class="ic3-mdx-result-cell-header">August 1 2010</td>
  <td class="ic3-mdx-result-cell-header">August 2 2010</td>
  <td class="ic3-mdx-result-cell-header">August 3 2010</td>
  <td class="ic3-mdx-result-cell-header">August 4 2010</td>
  <td class="ic3-mdx-result-cell-header">August 5 2010</td>
  <td class="ic3-mdx-result-cell-header">August 6 2010</td>
  <td class="ic3-mdx-result-cell-header">August 7 2010</td>
  <td class="ic3-mdx-result-cell-header">August 8 2010</td>
  <td class="ic3-mdx-result-cell-header">August 9 2010</td>
  <td class="ic3-mdx-result-cell-header">August 10 2010</td>
  <td class="ic3-mdx-result-cell-header">August 11 2010</td>
  <td class="ic3-mdx-result-cell-header">August 12 2010</td>
  <td class="ic3-mdx-result-cell-header">August 13 2010</td>
  <td class="ic3-mdx-result-cell-header">August 14 2010</td>
  <td class="ic3-mdx-result-cell-header">August 15 2010</td>
  <td class="ic3-mdx-result-cell-header">August 16 2010</td>
  <td class="ic3-mdx-result-cell-header">August 17 2010</td>
  <td class="ic3-mdx-result-cell-header">August 18 2010</td>
  <td class="ic3-mdx-result-cell-header">August 19 2010</td>
  <td class="ic3-mdx-result-cell-header">August 20 2010</td>
  <td class="ic3-mdx-result-cell-header">August 21 2010</td>
  <td class="ic3-mdx-result-cell-header">August 22 2010</td>
  <td class="ic3-mdx-result-cell-header">August 23 2010</td>
  <td class="ic3-mdx-result-cell-header">August 24 2010</td>
  <td class="ic3-mdx-result-cell-header">August 25 2010</td>
  <td class="ic3-mdx-result-cell-header">August 26 2010</td>
  <td class="ic3-mdx-result-cell-header">August 27 2010</td>
  <td class="ic3-mdx-result-cell-header">August 28 2010</td>
  <td class="ic3-mdx-result-cell-header">August 29 2010</td>
  <td class="ic3-mdx-result-cell-header">August 30 2010</td>
  <td class="ic3-mdx-result-cell-header">August 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Sep 2010</td>
  <td class="ic3-mdx-result-cell-header">September 1 2010</td>
  <td class="ic3-mdx-result-cell-header">September 2 2010</td>
  <td class="ic3-mdx-result-cell-header">September 3 2010</td>
  <td class="ic3-mdx-result-cell-header">September 4 2010</td>
  <td class="ic3-mdx-result-cell-header">September 5 2010</td>
  <td class="ic3-mdx-result-cell-header">September 6 2010</td>
  <td class="ic3-mdx-result-cell-header">September 7 2010</td>
  <td class="ic3-mdx-result-cell-header">September 8 2010</td>
  <td class="ic3-mdx-result-cell-header">September 9 2010</td>
  <td class="ic3-mdx-result-cell-header">September 10 2010</td>
  <td class="ic3-mdx-result-cell-header">September 11 2010</td>
  <td class="ic3-mdx-result-cell-header">September 12 2010</td>
  <td class="ic3-mdx-result-cell-header">September 13 2010</td>
  <td class="ic3-mdx-result-cell-header">September 14 2010</td>
  <td class="ic3-mdx-result-cell-header">September 15 2010</td>
  <td class="ic3-mdx-result-cell-header">September 16 2010</td>
  <td class="ic3-mdx-result-cell-header">September 17 2010</td>
  <td class="ic3-mdx-result-cell-header">September 18 2010</td>
  <td class="ic3-mdx-result-cell-header">September 19 2010</td>
  <td class="ic3-mdx-result-cell-header">September 20 2010</td>
  <td class="ic3-mdx-result-cell-header">September 21 2010</td>
  <td class="ic3-mdx-result-cell-header">September 22 2010</td>
  <td class="ic3-mdx-result-cell-header">September 23 2010</td>
  <td class="ic3-mdx-result-cell-header">September 24 2010</td>
  <td class="ic3-mdx-result-cell-header">September 25 2010</td>
  <td class="ic3-mdx-result-cell-header">September 26 2010</td>
  <td class="ic3-mdx-result-cell-header">September 27 2010</td>
  <td class="ic3-mdx-result-cell-header">September 28 2010</td>
  <td class="ic3-mdx-result-cell-header">September 29 2010</td>
  <td class="ic3-mdx-result-cell-header">September 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q4 2010</td>
  <td class="ic3-mdx-result-cell-header">Oct 2010</td>
  <td class="ic3-mdx-result-cell-header">October 1 2010</td>
  <td class="ic3-mdx-result-cell-header">October 2 2010</td>
  <td class="ic3-mdx-result-cell-header">October 3 2010</td>
  <td class="ic3-mdx-result-cell-header">October 4 2010</td>
  <td class="ic3-mdx-result-cell-header">October 5 2010</td>
  <td class="ic3-mdx-result-cell-header">October 6 2010</td>
  <td class="ic3-mdx-result-cell-header">October 7 2010</td>
  <td class="ic3-mdx-result-cell-header">October 8 2010</td>
  <td class="ic3-mdx-result-cell-header">October 9 2010</td>
  <td class="ic3-mdx-result-cell-header">October 10 2010</td>
  <td class="ic3-mdx-result-cell-header">October 11 2010</td>
  <td class="ic3-mdx-result-cell-header">October 12 2010</td>
  <td class="ic3-mdx-result-cell-header">October 13 2010</td>
  <td class="ic3-mdx-result-cell-header">October 14 2010</td>
  <td class="ic3-mdx-result-cell-header">October 15 2010</td>
  <td class="ic3-mdx-result-cell-header">October 16 2010</td>
  <td class="ic3-mdx-result-cell-header">October 17 2010</td>
  <td class="ic3-mdx-result-cell-header">October 18 2010</td>
  <td class="ic3-mdx-result-cell-header">October 19 2010</td>
  <td class="ic3-mdx-result-cell-header">October 20 2010</td>
  <td class="ic3-mdx-result-cell-header">October 21 2010</td>
  <td class="ic3-mdx-result-cell-header">October 22 2010</td>
  <td class="ic3-mdx-result-cell-header">October 23 2010</td>
  <td class="ic3-mdx-result-cell-header">October 24 2010</td>
  <td class="ic3-mdx-result-cell-header">October 25 2010</td>
  <td class="ic3-mdx-result-cell-header">October 26 2010</td>
  <td class="ic3-mdx-result-cell-header">October 27 2010</td>
  <td class="ic3-mdx-result-cell-header">October 28 2010</td>
  <td class="ic3-mdx-result-cell-header">October 29 2010</td>
  <td class="ic3-mdx-result-cell-header">October 30 2010</td>
  <td class="ic3-mdx-result-cell-header">October 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Nov 2010</td>
  <td class="ic3-mdx-result-cell-header">November 1 2010</td>
  <td class="ic3-mdx-result-cell-header">November 2 2010</td>
  <td class="ic3-mdx-result-cell-header">November 3 2010</td>
  <td class="ic3-mdx-result-cell-header">November 4 2010</td>
  <td class="ic3-mdx-result-cell-header">November 5 2010</td>
  <td class="ic3-mdx-result-cell-header">November 6 2010</td>
  <td class="ic3-mdx-result-cell-header">November 7 2010</td>
  <td class="ic3-mdx-result-cell-header">November 8 2010</td>
  <td class="ic3-mdx-result-cell-header">November 9 2010</td>
  <td class="ic3-mdx-result-cell-header">November 10 2010</td>
  <td class="ic3-mdx-result-cell-header">November 11 2010</td>
  <td class="ic3-mdx-result-cell-header">November 12 2010</td>
  <td class="ic3-mdx-result-cell-header">November 13 2010</td>
  <td class="ic3-mdx-result-cell-header">November 14 2010</td>
  <td class="ic3-mdx-result-cell-header">November 15 2010</td>
  <td class="ic3-mdx-result-cell-header">November 16 2010</td>
  <td class="ic3-mdx-result-cell-header">November 17 2010</td>
  <td class="ic3-mdx-result-cell-header">November 18 2010</td>
  <td class="ic3-mdx-result-cell-header">November 19 2010</td>
  <td class="ic3-mdx-result-cell-header">November 20 2010</td>
  <td class="ic3-mdx-result-cell-header">November 21 2010</td>
  <td class="ic3-mdx-result-cell-header">November 22 2010</td>
  <td class="ic3-mdx-result-cell-header">November 23 2010</td>
  <td class="ic3-mdx-result-cell-header">November 24 2010</td>
  <td class="ic3-mdx-result-cell-header">November 25 2010</td>
  <td class="ic3-mdx-result-cell-header">November 26 2010</td>
  <td class="ic3-mdx-result-cell-header">November 27 2010</td>
  <td class="ic3-mdx-result-cell-header">November 28 2010</td>
  <td class="ic3-mdx-result-cell-header">November 29 2010</td>
  <td class="ic3-mdx-result-cell-header">November 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Dec 2010</td>
  <td class="ic3-mdx-result-cell-header">December 1 2010</td>
  <td class="ic3-mdx-result-cell-header">December 2 2010</td>
  <td class="ic3-mdx-result-cell-header">December 3 2010</td>
  <td class="ic3-mdx-result-cell-header">December 4 2010</td>
  <td class="ic3-mdx-result-cell-header">December 5 2010</td>
  <td class="ic3-mdx-result-cell-header">December 6 2010</td>
  <td class="ic3-mdx-result-cell-header">December 7 2010</td>
  <td class="ic3-mdx-result-cell-header">December 8 2010</td>
  <td class="ic3-mdx-result-cell-header">December 9 2010</td>
  <td class="ic3-mdx-result-cell-header">December 10 2010</td>
  <td class="ic3-mdx-result-cell-header">December 11 2010</td>
  <td class="ic3-mdx-result-cell-header">December 12 2010</td>
  <td class="ic3-mdx-result-cell-header">December 13 2010</td>
  <td class="ic3-mdx-result-cell-header">December 14 2010</td>
  <td class="ic3-mdx-result-cell-header">December 15 2010</td>
  <td class="ic3-mdx-result-cell-header">December 16 2010</td>
  <td class="ic3-mdx-result-cell-header">December 17 2010</td>
  <td class="ic3-mdx-result-cell-header">December 18 2010</td>
  <td class="ic3-mdx-result-cell-header">December 19 2010</td>
  <td class="ic3-mdx-result-cell-header">December 20 2010</td>
  <td class="ic3-mdx-result-cell-header">December 21 2010</td>
  <td class="ic3-mdx-result-cell-header">December 22 2010</td>
  <td class="ic3-mdx-result-cell-header">December 23 2010</td>
  <td class="ic3-mdx-result-cell-header">December 24 2010</td>
  <td class="ic3-mdx-result-cell-header">December 25 2010</td>
  <td class="ic3-mdx-result-cell-header">December 26 2010</td>
  <td class="ic3-mdx-result-cell-header">December 27 2010</td>
  <td class="ic3-mdx-result-cell-header">December 28 2010</td>
  <td class="ic3-mdx-result-cell-header">December 29 2010</td>
  <td class="ic3-mdx-result-cell-header">December 30 2010</td>
  <td class="ic3-mdx-result-cell-header">December 31 2010</td>
  <td class="ic3-mdx-result-cell-header">2011</td>
  <td class="ic3-mdx-result-cell-header">Q1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jan 2011</td>
  <td class="ic3-mdx-result-cell-header">January 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Feb 2011</td>
  <td class="ic3-mdx-result-cell-header">February 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Mar 2011</td>
  <td class="ic3-mdx-result-cell-header">March 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q2 2011</td>
  <td class="ic3-mdx-result-cell-header">Apr 2011</td>
  <td class="ic3-mdx-result-cell-header">April 1 2011</td>
  <td class="ic3-mdx-result-cell-header">May 2011</td>
  <td class="ic3-mdx-result-cell-header">May 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jun 2011</td>
  <td class="ic3-mdx-result-cell-header">June 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q3 2011</td>
  <td class="ic3-mdx-result-cell-header">Jul 2011</td>
  <td class="ic3-mdx-result-cell-header">July 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Aug 2011</td>
  <td class="ic3-mdx-result-cell-header">August 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Sep 2011</td>
  <td class="ic3-mdx-result-cell-header">September 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q4 2011</td>
  <td class="ic3-mdx-result-cell-header">Oct 2011</td>
  <td class="ic3-mdx-result-cell-header">October 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Nov 2011</td>
  <td class="ic3-mdx-result-cell-header">November 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Dec 2011</td>
  <td class="ic3-mdx-result-cell-header">December 1 2011</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">January 1 2010</td>
  <td class="ic3-mdx-result-cell-header">January 2 2010</td>
  <td class="ic3-mdx-result-cell-header">January 3 2010</td>
  <td class="ic3-mdx-result-cell-header">January 4 2010</td>
  <td class="ic3-mdx-result-cell-header">January 5 2010</td>
  <td class="ic3-mdx-result-cell-header">January 6 2010</td>
  <td class="ic3-mdx-result-cell-header">January 7 2010</td>
  <td class="ic3-mdx-result-cell-header">January 8 2010</td>
  <td class="ic3-mdx-result-cell-header">January 9 2010</td>
  <td class="ic3-mdx-result-cell-header">January 10 2010</td>
  <td class="ic3-mdx-result-cell-header">January 11 2010</td>
  <td class="ic3-mdx-result-cell-header">January 12 2010</td>
  <td class="ic3-mdx-result-cell-header">January 13 2010</td>
  <td class="ic3-mdx-result-cell-header">January 14 2010</td>
  <td class="ic3-mdx-result-cell-header">January 15 2010</td>
  <td class="ic3-mdx-result-cell-header">January 16 2010</td>
  <td class="ic3-mdx-result-cell-header">January 17 2010</td>
  <td class="ic3-mdx-result-cell-header">January 18 2010</td>
  <td class="ic3-mdx-result-cell-header">January 19 2010</td>
  <td class="ic3-mdx-result-cell-header">January 20 2010</td>
  <td class="ic3-mdx-result-cell-header">January 21 2010</td>
  <td class="ic3-mdx-result-cell-header">January 22 2010</td>
  <td class="ic3-mdx-result-cell-header">January 23 2010</td>
  <td class="ic3-mdx-result-cell-header">January 24 2010</td>
  <td class="ic3-mdx-result-cell-header">January 25 2010</td>
  <td class="ic3-mdx-result-cell-header">January 26 2010</td>
  <td class="ic3-mdx-result-cell-header">January 27 2010</td>
  <td class="ic3-mdx-result-cell-header">January 28 2010</td>
  <td class="ic3-mdx-result-cell-header">January 29 2010</td>
  <td class="ic3-mdx-result-cell-header">January 30 2010</td>
  <td class="ic3-mdx-result-cell-header">January 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">February 1 2010</td>
  <td class="ic3-mdx-result-cell-header">February 2 2010</td>
  <td class="ic3-mdx-result-cell-header">February 3 2010</td>
  <td class="ic3-mdx-result-cell-header">February 4 2010</td>
  <td class="ic3-mdx-result-cell-header">February 5 2010</td>
  <td class="ic3-mdx-result-cell-header">February 6 2010</td>
  <td class="ic3-mdx-result-cell-header">February 7 2010</td>
  <td class="ic3-mdx-result-cell-header">February 8 2010</td>
  <td class="ic3-mdx-result-cell-header">February 9 2010</td>
  <td class="ic3-mdx-result-cell-header">February 10 2010</td>
  <td class="ic3-mdx-result-cell-header">February 11 2010</td>
  <td class="ic3-mdx-result-cell-header">February 12 2010</td>
  <td class="ic3-mdx-result-cell-header">February 13 2010</td>
  <td class="ic3-mdx-result-cell-header">February 14 2010</td>
  <td class="ic3-mdx-result-cell-header">February 15 2010</td>
  <td class="ic3-mdx-result-cell-header">February 16 2010</td>
  <td class="ic3-mdx-result-cell-header">February 17 2010</td>
  <td class="ic3-mdx-result-cell-header">February 18 2010</td>
  <td class="ic3-mdx-result-cell-header">February 19 2010</td>
  <td class="ic3-mdx-result-cell-header">February 20 2010</td>
  <td class="ic3-mdx-result-cell-header">February 21 2010</td>
  <td class="ic3-mdx-result-cell-header">February 22 2010</td>
  <td class="ic3-mdx-result-cell-header">February 23 2010</td>
  <td class="ic3-mdx-result-cell-header">February 24 2010</td>
  <td class="ic3-mdx-result-cell-header">February 25 2010</td>
  <td class="ic3-mdx-result-cell-header">February 26 2010</td>
  <td class="ic3-mdx-result-cell-header">February 27 2010</td>
  <td class="ic3-mdx-result-cell-header">February 28 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
  <td class="ic3-mdx-result-cell-header">March 1 2010</td>
  <td class="ic3-mdx-result-cell-header">March 2 2010</td>
  <td class="ic3-mdx-result-cell-header">March 3 2010</td>
  <td class="ic3-mdx-result-cell-header">March 4 2010</td>
  <td class="ic3-mdx-result-cell-header">March 5 2010</td>
  <td class="ic3-mdx-result-cell-header">March 6 2010</td>
  <td class="ic3-mdx-result-cell-header">March 7 2010</td>
  <td class="ic3-mdx-result-cell-header">March 8 2010</td>
  <td class="ic3-mdx-result-cell-header">March 9 2010</td>
  <td class="ic3-mdx-result-cell-header">March 10 2010</td>
  <td class="ic3-mdx-result-cell-header">March 11 2010</td>
  <td class="ic3-mdx-result-cell-header">March 12 2010</td>
  <td class="ic3-mdx-result-cell-header">March 13 2010</td>
  <td class="ic3-mdx-result-cell-header">March 14 2010</td>
  <td class="ic3-mdx-result-cell-header">March 15 2010</td>
  <td class="ic3-mdx-result-cell-header">March 16 2010</td>
  <td class="ic3-mdx-result-cell-header">March 17 2010</td>
  <td class="ic3-mdx-result-cell-header">March 18 2010</td>
  <td class="ic3-mdx-result-cell-header">March 19 2010</td>
  <td class="ic3-mdx-result-cell-header">March 20 2010</td>
  <td class="ic3-mdx-result-cell-header">March 21 2010</td>
  <td class="ic3-mdx-result-cell-header">March 22 2010</td>
  <td class="ic3-mdx-result-cell-header">March 23 2010</td>
  <td class="ic3-mdx-result-cell-header">March 24 2010</td>
  <td class="ic3-mdx-result-cell-header">March 25 2010</td>
  <td class="ic3-mdx-result-cell-header">March 26 2010</td>
  <td class="ic3-mdx-result-cell-header">March 27 2010</td>
  <td class="ic3-mdx-result-cell-header">March 28 2010</td>
  <td class="ic3-mdx-result-cell-header">March 29 2010</td>
  <td class="ic3-mdx-result-cell-header">March 30 2010</td>
  <td class="ic3-mdx-result-cell-header">March 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
  <td class="ic3-mdx-result-cell-header">Apr 2010</td>
  <td class="ic3-mdx-result-cell-header">April 1 2010</td>
  <td class="ic3-mdx-result-cell-header">April 2 2010</td>
  <td class="ic3-mdx-result-cell-header">April 3 2010</td>
  <td class="ic3-mdx-result-cell-header">April 4 2010</td>
  <td class="ic3-mdx-result-cell-header">April 5 2010</td>
  <td class="ic3-mdx-result-cell-header">April 6 2010</td>
  <td class="ic3-mdx-result-cell-header">April 7 2010</td>
  <td class="ic3-mdx-result-cell-header">April 8 2010</td>
  <td class="ic3-mdx-result-cell-header">April 9 2010</td>
  <td class="ic3-mdx-result-cell-header">April 10 2010</td>
  <td class="ic3-mdx-result-cell-header">April 11 2010</td>
  <td class="ic3-mdx-result-cell-header">April 12 2010</td>
  <td class="ic3-mdx-result-cell-header">April 13 2010</td>
  <td class="ic3-mdx-result-cell-header">April 14 2010</td>
  <td class="ic3-mdx-result-cell-header">April 15 2010</td>
  <td class="ic3-mdx-result-cell-header">April 16 2010</td>
  <td class="ic3-mdx-result-cell-header">April 17 2010</td>
  <td class="ic3-mdx-result-cell-header">April 18 2010</td>
  <td class="ic3-mdx-result-cell-header">April 19 2010</td>
  <td class="ic3-mdx-result-cell-header">April 20 2010</td>
  <td class="ic3-mdx-result-cell-header">April 21 2010</td>
  <td class="ic3-mdx-result-cell-header">April 22 2010</td>
  <td class="ic3-mdx-result-cell-header">April 23 2010</td>
  <td class="ic3-mdx-result-cell-header">April 24 2010</td>
  <td class="ic3-mdx-result-cell-header">April 25 2010</td>
  <td class="ic3-mdx-result-cell-header">April 26 2010</td>
  <td class="ic3-mdx-result-cell-header">April 27 2010</td>
  <td class="ic3-mdx-result-cell-header">April 28 2010</td>
  <td class="ic3-mdx-result-cell-header">April 29 2010</td>
  <td class="ic3-mdx-result-cell-header">April 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2010</td>
  <td class="ic3-mdx-result-cell-header">May 1 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2 2010</td>
  <td class="ic3-mdx-result-cell-header">May 3 2010</td>
  <td class="ic3-mdx-result-cell-header">May 4 2010</td>
  <td class="ic3-mdx-result-cell-header">May 5 2010</td>
  <td class="ic3-mdx-result-cell-header">May 6 2010</td>
  <td class="ic3-mdx-result-cell-header">May 7 2010</td>
  <td class="ic3-mdx-result-cell-header">May 8 2010</td>
  <td class="ic3-mdx-result-cell-header">May 9 2010</td>
  <td class="ic3-mdx-result-cell-header">May 10 2010</td>
  <td class="ic3-mdx-result-cell-header">May 11 2010</td>
  <td class="ic3-mdx-result-cell-header">May 12 2010</td>
  <td class="ic3-mdx-result-cell-header">May 13 2010</td>
  <td class="ic3-mdx-result-cell-header">May 14 2010</td>
  <td class="ic3-mdx-result-cell-header">May 15 2010</td>
  <td class="ic3-mdx-result-cell-header">May 16 2010</td>
  <td class="ic3-mdx-result-cell-header">May 17 2010</td>
  <td class="ic3-mdx-result-cell-header">May 18 2010</td>
  <td class="ic3-mdx-result-cell-header">May 19 2010</td>
  <td class="ic3-mdx-result-cell-header">May 20 2010</td>
  <td class="ic3-mdx-result-cell-header">May 21 2010</td>
  <td class="ic3-mdx-result-cell-header">May 22 2010</td>
  <td class="ic3-mdx-result-cell-header">May 23 2010</td>
  <td class="ic3-mdx-result-cell-header">May 24 2010</td>
  <td class="ic3-mdx-result-cell-header">May 25 2010</td>
  <td class="ic3-mdx-result-cell-header">May 26 2010</td>
  <td class="ic3-mdx-result-cell-header">May 27 2010</td>
  <td class="ic3-mdx-result-cell-header">May 28 2010</td>
  <td class="ic3-mdx-result-cell-header">May 29 2010</td>
  <td class="ic3-mdx-result-cell-header">May 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Jun 2010</td>
  <td class="ic3-mdx-result-cell-header">June 1 2010</td>
  <td class="ic3-mdx-result-cell-header">June 2 2010</td>
  <td class="ic3-mdx-result-cell-header">June 3 2010</td>
  <td class="ic3-mdx-result-cell-header">June 4 2010</td>
  <td class="ic3-mdx-result-cell-header">June 5 2010</td>
  <td class="ic3-mdx-result-cell-header">June 6 2010</td>
  <td class="ic3-mdx-result-cell-header">June 7 2010</td>
  <td class="ic3-mdx-result-cell-header">June 8 2010</td>
  <td class="ic3-mdx-result-cell-header">June 9 2010</td>
  <td class="ic3-mdx-result-cell-header">June 10 2010</td>
  <td class="ic3-mdx-result-cell-header">June 11 2010</td>
  <td class="ic3-mdx-result-cell-header">June 12 2010</td>
  <td class="ic3-mdx-result-cell-header">June 13 2010</td>
  <td class="ic3-mdx-result-cell-header">June 14 2010</td>
  <td class="ic3-mdx-result-cell-header">June 15 2010</td>
  <td class="ic3-mdx-result-cell-header">June 16 2010</td>
  <td class="ic3-mdx-result-cell-header">June 17 2010</td>
  <td class="ic3-mdx-result-cell-header">June 18 2010</td>
  <td class="ic3-mdx-result-cell-header">June 19 2010</td>
  <td class="ic3-mdx-result-cell-header">June 20 2010</td>
  <td class="ic3-mdx-result-cell-header">June 21 2010</td>
  <td class="ic3-mdx-result-cell-header">June 22 2010</td>
  <td class="ic3-mdx-result-cell-header">June 23 2010</td>
  <td class="ic3-mdx-result-cell-header">June 24 2010</td>
  <td class="ic3-mdx-result-cell-header">June 25 2010</td>
  <td class="ic3-mdx-result-cell-header">June 26 2010</td>
  <td class="ic3-mdx-result-cell-header">June 27 2010</td>
  <td class="ic3-mdx-result-cell-header">June 28 2010</td>
  <td class="ic3-mdx-result-cell-header">June 29 2010</td>
  <td class="ic3-mdx-result-cell-header">June 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q3 2010</td>
  <td class="ic3-mdx-result-cell-header">Jul 2010</td>
  <td class="ic3-mdx-result-cell-header">July 1 2010</td>
  <td class="ic3-mdx-result-cell-header">July 2 2010</td>
  <td class="ic3-mdx-result-cell-header">July 3 2010</td>
  <td class="ic3-mdx-result-cell-header">July 4 2010</td>
  <td class="ic3-mdx-result-cell-header">July 5 2010</td>
  <td class="ic3-mdx-result-cell-header">July 6 2010</td>
  <td class="ic3-mdx-result-cell-header">July 7 2010</td>
  <td class="ic3-mdx-result-cell-header">July 8 2010</td>
  <td class="ic3-mdx-result-cell-header">July 9 2010</td>
  <td class="ic3-mdx-result-cell-header">July 10 2010</td>
  <td class="ic3-mdx-result-cell-header">July 11 2010</td>
  <td class="ic3-mdx-result-cell-header">July 12 2010</td>
  <td class="ic3-mdx-result-cell-header">July 13 2010</td>
  <td class="ic3-mdx-result-cell-header">July 14 2010</td>
  <td class="ic3-mdx-result-cell-header">July 15 2010</td>
  <td class="ic3-mdx-result-cell-header">July 16 2010</td>
  <td class="ic3-mdx-result-cell-header">July 17 2010</td>
  <td class="ic3-mdx-result-cell-header">July 18 2010</td>
  <td class="ic3-mdx-result-cell-header">July 19 2010</td>
  <td class="ic3-mdx-result-cell-header">July 20 2010</td>
  <td class="ic3-mdx-result-cell-header">July 21 2010</td>
  <td class="ic3-mdx-result-cell-header">July 22 2010</td>
  <td class="ic3-mdx-result-cell-header">July 23 2010</td>
  <td class="ic3-mdx-result-cell-header">July 24 2010</td>
  <td class="ic3-mdx-result-cell-header">July 25 2010</td>
  <td class="ic3-mdx-result-cell-header">July 26 2010</td>
  <td class="ic3-mdx-result-cell-header">July 27 2010</td>
  <td class="ic3-mdx-result-cell-header">July 28 2010</td>
  <td class="ic3-mdx-result-cell-header">July 29 2010</td>
  <td class="ic3-mdx-result-cell-header">July 30 2010</td>
  <td class="ic3-mdx-result-cell-header">July 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Aug 2010</td>
  <td class="ic3-mdx-result-cell-header">August 1 2010</td>
  <td class="ic3-mdx-result-cell-header">August 2 2010</td>
  <td class="ic3-mdx-result-cell-header">August 3 2010</td>
  <td class="ic3-mdx-result-cell-header">August 4 2010</td>
  <td class="ic3-mdx-result-cell-header">August 5 2010</td>
  <td class="ic3-mdx-result-cell-header">August 6 2010</td>
  <td class="ic3-mdx-result-cell-header">August 7 2010</td>
  <td class="ic3-mdx-result-cell-header">August 8 2010</td>
  <td class="ic3-mdx-result-cell-header">August 9 2010</td>
  <td class="ic3-mdx-result-cell-header">August 10 2010</td>
  <td class="ic3-mdx-result-cell-header">August 11 2010</td>
  <td class="ic3-mdx-result-cell-header">August 12 2010</td>
  <td class="ic3-mdx-result-cell-header">August 13 2010</td>
  <td class="ic3-mdx-result-cell-header">August 14 2010</td>
  <td class="ic3-mdx-result-cell-header">August 15 2010</td>
  <td class="ic3-mdx-result-cell-header">August 16 2010</td>
  <td class="ic3-mdx-result-cell-header">August 17 2010</td>
  <td class="ic3-mdx-result-cell-header">August 18 2010</td>
  <td class="ic3-mdx-result-cell-header">August 19 2010</td>
  <td class="ic3-mdx-result-cell-header">August 20 2010</td>
  <td class="ic3-mdx-result-cell-header">August 21 2010</td>
  <td class="ic3-mdx-result-cell-header">August 22 2010</td>
  <td class="ic3-mdx-result-cell-header">August 23 2010</td>
  <td class="ic3-mdx-result-cell-header">August 24 2010</td>
  <td class="ic3-mdx-result-cell-header">August 25 2010</td>
  <td class="ic3-mdx-result-cell-header">August 26 2010</td>
  <td class="ic3-mdx-result-cell-header">August 27 2010</td>
  <td class="ic3-mdx-result-cell-header">August 28 2010</td>
  <td class="ic3-mdx-result-cell-header">August 29 2010</td>
  <td class="ic3-mdx-result-cell-header">August 30 2010</td>
  <td class="ic3-mdx-result-cell-header">August 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Sep 2010</td>
  <td class="ic3-mdx-result-cell-header">September 1 2010</td>
  <td class="ic3-mdx-result-cell-header">September 2 2010</td>
  <td class="ic3-mdx-result-cell-header">September 3 2010</td>
  <td class="ic3-mdx-result-cell-header">September 4 2010</td>
  <td class="ic3-mdx-result-cell-header">September 5 2010</td>
  <td class="ic3-mdx-result-cell-header">September 6 2010</td>
  <td class="ic3-mdx-result-cell-header">September 7 2010</td>
  <td class="ic3-mdx-result-cell-header">September 8 2010</td>
  <td class="ic3-mdx-result-cell-header">September 9 2010</td>
  <td class="ic3-mdx-result-cell-header">September 10 2010</td>
  <td class="ic3-mdx-result-cell-header">September 11 2010</td>
  <td class="ic3-mdx-result-cell-header">September 12 2010</td>
  <td class="ic3-mdx-result-cell-header">September 13 2010</td>
  <td class="ic3-mdx-result-cell-header">September 14 2010</td>
  <td class="ic3-mdx-result-cell-header">September 15 2010</td>
  <td class="ic3-mdx-result-cell-header">September 16 2010</td>
  <td class="ic3-mdx-result-cell-header">September 17 2010</td>
  <td class="ic3-mdx-result-cell-header">September 18 2010</td>
  <td class="ic3-mdx-result-cell-header">September 19 2010</td>
  <td class="ic3-mdx-result-cell-header">September 20 2010</td>
  <td class="ic3-mdx-result-cell-header">September 21 2010</td>
  <td class="ic3-mdx-result-cell-header">September 22 2010</td>
  <td class="ic3-mdx-result-cell-header">September 23 2010</td>
  <td class="ic3-mdx-result-cell-header">September 24 2010</td>
  <td class="ic3-mdx-result-cell-header">September 25 2010</td>
  <td class="ic3-mdx-result-cell-header">September 26 2010</td>
  <td class="ic3-mdx-result-cell-header">September 27 2010</td>
  <td class="ic3-mdx-result-cell-header">September 28 2010</td>
  <td class="ic3-mdx-result-cell-header">September 29 2010</td>
  <td class="ic3-mdx-result-cell-header">September 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q4 2010</td>
  <td class="ic3-mdx-result-cell-header">Oct 2010</td>
  <td class="ic3-mdx-result-cell-header">October 1 2010</td>
  <td class="ic3-mdx-result-cell-header">October 2 2010</td>
  <td class="ic3-mdx-result-cell-header">October 3 2010</td>
  <td class="ic3-mdx-result-cell-header">October 4 2010</td>
  <td class="ic3-mdx-result-cell-header">October 5 2010</td>
  <td class="ic3-mdx-result-cell-header">October 6 2010</td>
  <td class="ic3-mdx-result-cell-header">October 7 2010</td>
  <td class="ic3-mdx-result-cell-header">October 8 2010</td>
  <td class="ic3-mdx-result-cell-header">October 9 2010</td>
  <td class="ic3-mdx-result-cell-header">October 10 2010</td>
  <td class="ic3-mdx-result-cell-header">October 11 2010</td>
  <td class="ic3-mdx-result-cell-header">October 12 2010</td>
  <td class="ic3-mdx-result-cell-header">October 13 2010</td>
  <td class="ic3-mdx-result-cell-header">October 14 2010</td>
  <td class="ic3-mdx-result-cell-header">October 15 2010</td>
  <td class="ic3-mdx-result-cell-header">October 16 2010</td>
  <td class="ic3-mdx-result-cell-header">October 17 2010</td>
  <td class="ic3-mdx-result-cell-header">October 18 2010</td>
  <td class="ic3-mdx-result-cell-header">October 19 2010</td>
  <td class="ic3-mdx-result-cell-header">October 20 2010</td>
  <td class="ic3-mdx-result-cell-header">October 21 2010</td>
  <td class="ic3-mdx-result-cell-header">October 22 2010</td>
  <td class="ic3-mdx-result-cell-header">October 23 2010</td>
  <td class="ic3-mdx-result-cell-header">October 24 2010</td>
  <td class="ic3-mdx-result-cell-header">October 25 2010</td>
  <td class="ic3-mdx-result-cell-header">October 26 2010</td>
  <td class="ic3-mdx-result-cell-header">October 27 2010</td>
  <td class="ic3-mdx-result-cell-header">October 28 2010</td>
  <td class="ic3-mdx-result-cell-header">October 29 2010</td>
  <td class="ic3-mdx-result-cell-header">October 30 2010</td>
  <td class="ic3-mdx-result-cell-header">October 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Nov 2010</td>
  <td class="ic3-mdx-result-cell-header">November 1 2010</td>
  <td class="ic3-mdx-result-cell-header">November 2 2010</td>
  <td class="ic3-mdx-result-cell-header">November 3 2010</td>
  <td class="ic3-mdx-result-cell-header">November 4 2010</td>
  <td class="ic3-mdx-result-cell-header">November 5 2010</td>
  <td class="ic3-mdx-result-cell-header">November 6 2010</td>
  <td class="ic3-mdx-result-cell-header">November 7 2010</td>
  <td class="ic3-mdx-result-cell-header">November 8 2010</td>
  <td class="ic3-mdx-result-cell-header">November 9 2010</td>
  <td class="ic3-mdx-result-cell-header">November 10 2010</td>
  <td class="ic3-mdx-result-cell-header">November 11 2010</td>
  <td class="ic3-mdx-result-cell-header">November 12 2010</td>
  <td class="ic3-mdx-result-cell-header">November 13 2010</td>
  <td class="ic3-mdx-result-cell-header">November 14 2010</td>
  <td class="ic3-mdx-result-cell-header">November 15 2010</td>
  <td class="ic3-mdx-result-cell-header">November 16 2010</td>
  <td class="ic3-mdx-result-cell-header">November 17 2010</td>
  <td class="ic3-mdx-result-cell-header">November 18 2010</td>
  <td class="ic3-mdx-result-cell-header">November 19 2010</td>
  <td class="ic3-mdx-result-cell-header">November 20 2010</td>
  <td class="ic3-mdx-result-cell-header">November 21 2010</td>
  <td class="ic3-mdx-result-cell-header">November 22 2010</td>
  <td class="ic3-mdx-result-cell-header">November 23 2010</td>
  <td class="ic3-mdx-result-cell-header">November 24 2010</td>
  <td class="ic3-mdx-result-cell-header">November 25 2010</td>
  <td class="ic3-mdx-result-cell-header">November 26 2010</td>
  <td class="ic3-mdx-result-cell-header">November 27 2010</td>
  <td class="ic3-mdx-result-cell-header">November 28 2010</td>
  <td class="ic3-mdx-result-cell-header">November 29 2010</td>
  <td class="ic3-mdx-result-cell-header">November 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Dec 2010</td>
  <td class="ic3-mdx-result-cell-header">December 1 2010</td>
  <td class="ic3-mdx-result-cell-header">December 2 2010</td>
  <td class="ic3-mdx-result-cell-header">December 3 2010</td>
  <td class="ic3-mdx-result-cell-header">December 4 2010</td>
  <td class="ic3-mdx-result-cell-header">December 5 2010</td>
  <td class="ic3-mdx-result-cell-header">December 6 2010</td>
  <td class="ic3-mdx-result-cell-header">December 7 2010</td>
  <td class="ic3-mdx-result-cell-header">December 8 2010</td>
  <td class="ic3-mdx-result-cell-header">December 9 2010</td>
  <td class="ic3-mdx-result-cell-header">December 10 2010</td>
  <td class="ic3-mdx-result-cell-header">December 11 2010</td>
  <td class="ic3-mdx-result-cell-header">December 12 2010</td>
  <td class="ic3-mdx-result-cell-header">December 13 2010</td>
  <td class="ic3-mdx-result-cell-header">December 14 2010</td>
  <td class="ic3-mdx-result-cell-header">December 15 2010</td>
  <td class="ic3-mdx-result-cell-header">December 16 2010</td>
  <td class="ic3-mdx-result-cell-header">December 17 2010</td>
  <td class="ic3-mdx-result-cell-header">December 18 2010</td>
  <td class="ic3-mdx-result-cell-header">December 19 2010</td>
  <td class="ic3-mdx-result-cell-header">December 20 2010</td>
  <td class="ic3-mdx-result-cell-header">December 21 2010</td>
  <td class="ic3-mdx-result-cell-header">December 22 2010</td>
  <td class="ic3-mdx-result-cell-header">December 23 2010</td>
  <td class="ic3-mdx-result-cell-header">December 24 2010</td>
  <td class="ic3-mdx-result-cell-header">December 25 2010</td>
  <td class="ic3-mdx-result-cell-header">December 26 2010</td>
  <td class="ic3-mdx-result-cell-header">December 27 2010</td>
  <td class="ic3-mdx-result-cell-header">December 28 2010</td>
  <td class="ic3-mdx-result-cell-header">December 29 2010</td>
  <td class="ic3-mdx-result-cell-header">December 30 2010</td>
  <td class="ic3-mdx-result-cell-header">December 31 2010</td>
  <td class="ic3-mdx-result-cell-header">2011</td>
  <td class="ic3-mdx-result-cell-header">Q1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jan 2011</td>
  <td class="ic3-mdx-result-cell-header">January 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Feb 2011</td>
  <td class="ic3-mdx-result-cell-header">February 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Mar 2011</td>
  <td class="ic3-mdx-result-cell-header">March 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q2 2011</td>
  <td class="ic3-mdx-result-cell-header">Apr 2011</td>
  <td class="ic3-mdx-result-cell-header">April 1 2011</td>
  <td class="ic3-mdx-result-cell-header">May 2011</td>
  <td class="ic3-mdx-result-cell-header">May 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jun 2011</td>
  <td class="ic3-mdx-result-cell-header">June 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q3 2011</td>
  <td class="ic3-mdx-result-cell-header">Jul 2011</td>
  <td class="ic3-mdx-result-cell-header">July 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Aug 2011</td>
  <td class="ic3-mdx-result-cell-header">August 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Sep 2011</td>
  <td class="ic3-mdx-result-cell-header">September 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q4 2011</td>
  <td class="ic3-mdx-result-cell-header">Oct 2011</td>
  <td class="ic3-mdx-result-cell-header">October 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Nov 2011</td>
  <td class="ic3-mdx-result-cell-header">November 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Dec 2011</td>
  <td class="ic3-mdx-result-cell-header">December 1 2011</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Jan 2010</td>
  <td class="ic3-mdx-result-cell-header">January 1 2010</td>
  <td class="ic3-mdx-result-cell-header">January 2 2010</td>
  <td class="ic3-mdx-result-cell-header">January 3 2010</td>
  <td class="ic3-mdx-result-cell-header">January 4 2010</td>
  <td class="ic3-mdx-result-cell-header">January 5 2010</td>
  <td class="ic3-mdx-result-cell-header">January 6 2010</td>
  <td class="ic3-mdx-result-cell-header">January 7 2010</td>
  <td class="ic3-mdx-result-cell-header">January 8 2010</td>
  <td class="ic3-mdx-result-cell-header">January 9 2010</td>
  <td class="ic3-mdx-result-cell-header">January 10 2010</td>
  <td class="ic3-mdx-result-cell-header">January 11 2010</td>
  <td class="ic3-mdx-result-cell-header">January 12 2010</td>
  <td class="ic3-mdx-result-cell-header">January 13 2010</td>
  <td class="ic3-mdx-result-cell-header">January 14 2010</td>
  <td class="ic3-mdx-result-cell-header">January 15 2010</td>
  <td class="ic3-mdx-result-cell-header">January 16 2010</td>
  <td class="ic3-mdx-result-cell-header">January 17 2010</td>
  <td class="ic3-mdx-result-cell-header">January 18 2010</td>
  <td class="ic3-mdx-result-cell-header">January 19 2010</td>
  <td class="ic3-mdx-result-cell-header">January 20 2010</td>
  <td class="ic3-mdx-result-cell-header">January 21 2010</td>
  <td class="ic3-mdx-result-cell-header">January 22 2010</td>
  <td class="ic3-mdx-result-cell-header">January 23 2010</td>
  <td class="ic3-mdx-result-cell-header">January 24 2010</td>
  <td class="ic3-mdx-result-cell-header">January 25 2010</td>
  <td class="ic3-mdx-result-cell-header">January 26 2010</td>
  <td class="ic3-mdx-result-cell-header">January 27 2010</td>
  <td class="ic3-mdx-result-cell-header">January 28 2010</td>
  <td class="ic3-mdx-result-cell-header">January 29 2010</td>
  <td class="ic3-mdx-result-cell-header">January 30 2010</td>
  <td class="ic3-mdx-result-cell-header">January 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Feb 2010</td>
  <td class="ic3-mdx-result-cell-header">February 1 2010</td>
  <td class="ic3-mdx-result-cell-header">February 2 2010</td>
  <td class="ic3-mdx-result-cell-header">February 3 2010</td>
  <td class="ic3-mdx-result-cell-header">February 4 2010</td>
  <td class="ic3-mdx-result-cell-header">February 5 2010</td>
  <td class="ic3-mdx-result-cell-header">February 6 2010</td>
  <td class="ic3-mdx-result-cell-header">February 7 2010</td>
  <td class="ic3-mdx-result-cell-header">February 8 2010</td>
  <td class="ic3-mdx-result-cell-header">February 9 2010</td>
  <td class="ic3-mdx-result-cell-header">February 10 2010</td>
  <td class="ic3-mdx-result-cell-header">February 11 2010</td>
  <td class="ic3-mdx-result-cell-header">February 12 2010</td>
  <td class="ic3-mdx-result-cell-header">February 13 2010</td>
  <td class="ic3-mdx-result-cell-header">February 14 2010</td>
  <td class="ic3-mdx-result-cell-header">February 15 2010</td>
  <td class="ic3-mdx-result-cell-header">February 16 2010</td>
  <td class="ic3-mdx-result-cell-header">February 17 2010</td>
  <td class="ic3-mdx-result-cell-header">February 18 2010</td>
  <td class="ic3-mdx-result-cell-header">February 19 2010</td>
  <td class="ic3-mdx-result-cell-header">February 20 2010</td>
  <td class="ic3-mdx-result-cell-header">February 21 2010</td>
  <td class="ic3-mdx-result-cell-header">February 22 2010</td>
  <td class="ic3-mdx-result-cell-header">February 23 2010</td>
  <td class="ic3-mdx-result-cell-header">February 24 2010</td>
  <td class="ic3-mdx-result-cell-header">February 25 2010</td>
  <td class="ic3-mdx-result-cell-header">February 26 2010</td>
  <td class="ic3-mdx-result-cell-header">February 27 2010</td>
  <td class="ic3-mdx-result-cell-header">February 28 2010</td>
  <td class="ic3-mdx-result-cell-header">Mar 2010</td>
  <td class="ic3-mdx-result-cell-header">March 1 2010</td>
  <td class="ic3-mdx-result-cell-header">March 2 2010</td>
  <td class="ic3-mdx-result-cell-header">March 3 2010</td>
  <td class="ic3-mdx-result-cell-header">March 4 2010</td>
  <td class="ic3-mdx-result-cell-header">March 5 2010</td>
  <td class="ic3-mdx-result-cell-header">March 6 2010</td>
  <td class="ic3-mdx-result-cell-header">March 7 2010</td>
  <td class="ic3-mdx-result-cell-header">March 8 2010</td>
  <td class="ic3-mdx-result-cell-header">March 9 2010</td>
  <td class="ic3-mdx-result-cell-header">March 10 2010</td>
  <td class="ic3-mdx-result-cell-header">March 11 2010</td>
  <td class="ic3-mdx-result-cell-header">March 12 2010</td>
  <td class="ic3-mdx-result-cell-header">March 13 2010</td>
  <td class="ic3-mdx-result-cell-header">March 14 2010</td>
  <td class="ic3-mdx-result-cell-header">March 15 2010</td>
  <td class="ic3-mdx-result-cell-header">March 16 2010</td>
  <td class="ic3-mdx-result-cell-header">March 17 2010</td>
  <td class="ic3-mdx-result-cell-header">March 18 2010</td>
  <td class="ic3-mdx-result-cell-header">March 19 2010</td>
  <td class="ic3-mdx-result-cell-header">March 20 2010</td>
  <td class="ic3-mdx-result-cell-header">March 21 2010</td>
  <td class="ic3-mdx-result-cell-header">March 22 2010</td>
  <td class="ic3-mdx-result-cell-header">March 23 2010</td>
  <td class="ic3-mdx-result-cell-header">March 24 2010</td>
  <td class="ic3-mdx-result-cell-header">March 25 2010</td>
  <td class="ic3-mdx-result-cell-header">March 26 2010</td>
  <td class="ic3-mdx-result-cell-header">March 27 2010</td>
  <td class="ic3-mdx-result-cell-header">March 28 2010</td>
  <td class="ic3-mdx-result-cell-header">March 29 2010</td>
  <td class="ic3-mdx-result-cell-header">March 30 2010</td>
  <td class="ic3-mdx-result-cell-header">March 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
  <td class="ic3-mdx-result-cell-header">Apr 2010</td>
  <td class="ic3-mdx-result-cell-header">April 1 2010</td>
  <td class="ic3-mdx-result-cell-header">April 2 2010</td>
  <td class="ic3-mdx-result-cell-header">April 3 2010</td>
  <td class="ic3-mdx-result-cell-header">April 4 2010</td>
  <td class="ic3-mdx-result-cell-header">April 5 2010</td>
  <td class="ic3-mdx-result-cell-header">April 6 2010</td>
  <td class="ic3-mdx-result-cell-header">April 7 2010</td>
  <td class="ic3-mdx-result-cell-header">April 8 2010</td>
  <td class="ic3-mdx-result-cell-header">April 9 2010</td>
  <td class="ic3-mdx-result-cell-header">April 10 2010</td>
  <td class="ic3-mdx-result-cell-header">April 11 2010</td>
  <td class="ic3-mdx-result-cell-header">April 12 2010</td>
  <td class="ic3-mdx-result-cell-header">April 13 2010</td>
  <td class="ic3-mdx-result-cell-header">April 14 2010</td>
  <td class="ic3-mdx-result-cell-header">April 15 2010</td>
  <td class="ic3-mdx-result-cell-header">April 16 2010</td>
  <td class="ic3-mdx-result-cell-header">April 17 2010</td>
  <td class="ic3-mdx-result-cell-header">April 18 2010</td>
  <td class="ic3-mdx-result-cell-header">April 19 2010</td>
  <td class="ic3-mdx-result-cell-header">April 20 2010</td>
  <td class="ic3-mdx-result-cell-header">April 21 2010</td>
  <td class="ic3-mdx-result-cell-header">April 22 2010</td>
  <td class="ic3-mdx-result-cell-header">April 23 2010</td>
  <td class="ic3-mdx-result-cell-header">April 24 2010</td>
  <td class="ic3-mdx-result-cell-header">April 25 2010</td>
  <td class="ic3-mdx-result-cell-header">April 26 2010</td>
  <td class="ic3-mdx-result-cell-header">April 27 2010</td>
  <td class="ic3-mdx-result-cell-header">April 28 2010</td>
  <td class="ic3-mdx-result-cell-header">April 29 2010</td>
  <td class="ic3-mdx-result-cell-header">April 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2010</td>
  <td class="ic3-mdx-result-cell-header">May 1 2010</td>
  <td class="ic3-mdx-result-cell-header">May 2 2010</td>
  <td class="ic3-mdx-result-cell-header">May 3 2010</td>
  <td class="ic3-mdx-result-cell-header">May 4 2010</td>
  <td class="ic3-mdx-result-cell-header">May 5 2010</td>
  <td class="ic3-mdx-result-cell-header">May 6 2010</td>
  <td class="ic3-mdx-result-cell-header">May 7 2010</td>
  <td class="ic3-mdx-result-cell-header">May 8 2010</td>
  <td class="ic3-mdx-result-cell-header">May 9 2010</td>
  <td class="ic3-mdx-result-cell-header">May 10 2010</td>
  <td class="ic3-mdx-result-cell-header">May 11 2010</td>
  <td class="ic3-mdx-result-cell-header">May 12 2010</td>
  <td class="ic3-mdx-result-cell-header">May 13 2010</td>
  <td class="ic3-mdx-result-cell-header">May 14 2010</td>
  <td class="ic3-mdx-result-cell-header">May 15 2010</td>
  <td class="ic3-mdx-result-cell-header">May 16 2010</td>
  <td class="ic3-mdx-result-cell-header">May 17 2010</td>
  <td class="ic3-mdx-result-cell-header">May 18 2010</td>
  <td class="ic3-mdx-result-cell-header">May 19 2010</td>
  <td class="ic3-mdx-result-cell-header">May 20 2010</td>
  <td class="ic3-mdx-result-cell-header">May 21 2010</td>
  <td class="ic3-mdx-result-cell-header">May 22 2010</td>
  <td class="ic3-mdx-result-cell-header">May 23 2010</td>
  <td class="ic3-mdx-result-cell-header">May 24 2010</td>
  <td class="ic3-mdx-result-cell-header">May 25 2010</td>
  <td class="ic3-mdx-result-cell-header">May 26 2010</td>
  <td class="ic3-mdx-result-cell-header">May 27 2010</td>
  <td class="ic3-mdx-result-cell-header">May 28 2010</td>
  <td class="ic3-mdx-result-cell-header">May 29 2010</td>
  <td class="ic3-mdx-result-cell-header">May 30 2010</td>
  <td class="ic3-mdx-result-cell-header">May 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Jun 2010</td>
  <td class="ic3-mdx-result-cell-header">June 1 2010</td>
  <td class="ic3-mdx-result-cell-header">June 2 2010</td>
  <td class="ic3-mdx-result-cell-header">June 3 2010</td>
  <td class="ic3-mdx-result-cell-header">June 4 2010</td>
  <td class="ic3-mdx-result-cell-header">June 5 2010</td>
  <td class="ic3-mdx-result-cell-header">June 6 2010</td>
  <td class="ic3-mdx-result-cell-header">June 7 2010</td>
  <td class="ic3-mdx-result-cell-header">June 8 2010</td>
  <td class="ic3-mdx-result-cell-header">June 9 2010</td>
  <td class="ic3-mdx-result-cell-header">June 10 2010</td>
  <td class="ic3-mdx-result-cell-header">June 11 2010</td>
  <td class="ic3-mdx-result-cell-header">June 12 2010</td>
  <td class="ic3-mdx-result-cell-header">June 13 2010</td>
  <td class="ic3-mdx-result-cell-header">June 14 2010</td>
  <td class="ic3-mdx-result-cell-header">June 15 2010</td>
  <td class="ic3-mdx-result-cell-header">June 16 2010</td>
  <td class="ic3-mdx-result-cell-header">June 17 2010</td>
  <td class="ic3-mdx-result-cell-header">June 18 2010</td>
  <td class="ic3-mdx-result-cell-header">June 19 2010</td>
  <td class="ic3-mdx-result-cell-header">June 20 2010</td>
  <td class="ic3-mdx-result-cell-header">June 21 2010</td>
  <td class="ic3-mdx-result-cell-header">June 22 2010</td>
  <td class="ic3-mdx-result-cell-header">June 23 2010</td>
  <td class="ic3-mdx-result-cell-header">June 24 2010</td>
  <td class="ic3-mdx-result-cell-header">June 25 2010</td>
  <td class="ic3-mdx-result-cell-header">June 26 2010</td>
  <td class="ic3-mdx-result-cell-header">June 27 2010</td>
  <td class="ic3-mdx-result-cell-header">June 28 2010</td>
  <td class="ic3-mdx-result-cell-header">June 29 2010</td>
  <td class="ic3-mdx-result-cell-header">June 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q3 2010</td>
  <td class="ic3-mdx-result-cell-header">Jul 2010</td>
  <td class="ic3-mdx-result-cell-header">July 1 2010</td>
  <td class="ic3-mdx-result-cell-header">July 2 2010</td>
  <td class="ic3-mdx-result-cell-header">July 3 2010</td>
  <td class="ic3-mdx-result-cell-header">July 4 2010</td>
  <td class="ic3-mdx-result-cell-header">July 5 2010</td>
  <td class="ic3-mdx-result-cell-header">July 6 2010</td>
  <td class="ic3-mdx-result-cell-header">July 7 2010</td>
  <td class="ic3-mdx-result-cell-header">July 8 2010</td>
  <td class="ic3-mdx-result-cell-header">July 9 2010</td>
  <td class="ic3-mdx-result-cell-header">July 10 2010</td>
  <td class="ic3-mdx-result-cell-header">July 11 2010</td>
  <td class="ic3-mdx-result-cell-header">July 12 2010</td>
  <td class="ic3-mdx-result-cell-header">July 13 2010</td>
  <td class="ic3-mdx-result-cell-header">July 14 2010</td>
  <td class="ic3-mdx-result-cell-header">July 15 2010</td>
  <td class="ic3-mdx-result-cell-header">July 16 2010</td>
  <td class="ic3-mdx-result-cell-header">July 17 2010</td>
  <td class="ic3-mdx-result-cell-header">July 18 2010</td>
  <td class="ic3-mdx-result-cell-header">July 19 2010</td>
  <td class="ic3-mdx-result-cell-header">July 20 2010</td>
  <td class="ic3-mdx-result-cell-header">July 21 2010</td>
  <td class="ic3-mdx-result-cell-header">July 22 2010</td>
  <td class="ic3-mdx-result-cell-header">July 23 2010</td>
  <td class="ic3-mdx-result-cell-header">July 24 2010</td>
  <td class="ic3-mdx-result-cell-header">July 25 2010</td>
  <td class="ic3-mdx-result-cell-header">July 26 2010</td>
  <td class="ic3-mdx-result-cell-header">July 27 2010</td>
  <td class="ic3-mdx-result-cell-header">July 28 2010</td>
  <td class="ic3-mdx-result-cell-header">July 29 2010</td>
  <td class="ic3-mdx-result-cell-header">July 30 2010</td>
  <td class="ic3-mdx-result-cell-header">July 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Aug 2010</td>
  <td class="ic3-mdx-result-cell-header">August 1 2010</td>
  <td class="ic3-mdx-result-cell-header">August 2 2010</td>
  <td class="ic3-mdx-result-cell-header">August 3 2010</td>
  <td class="ic3-mdx-result-cell-header">August 4 2010</td>
  <td class="ic3-mdx-result-cell-header">August 5 2010</td>
  <td class="ic3-mdx-result-cell-header">August 6 2010</td>
  <td class="ic3-mdx-result-cell-header">August 7 2010</td>
  <td class="ic3-mdx-result-cell-header">August 8 2010</td>
  <td class="ic3-mdx-result-cell-header">August 9 2010</td>
  <td class="ic3-mdx-result-cell-header">August 10 2010</td>
  <td class="ic3-mdx-result-cell-header">August 11 2010</td>
  <td class="ic3-mdx-result-cell-header">August 12 2010</td>
  <td class="ic3-mdx-result-cell-header">August 13 2010</td>
  <td class="ic3-mdx-result-cell-header">August 14 2010</td>
  <td class="ic3-mdx-result-cell-header">August 15 2010</td>
  <td class="ic3-mdx-result-cell-header">August 16 2010</td>
  <td class="ic3-mdx-result-cell-header">August 17 2010</td>
  <td class="ic3-mdx-result-cell-header">August 18 2010</td>
  <td class="ic3-mdx-result-cell-header">August 19 2010</td>
  <td class="ic3-mdx-result-cell-header">August 20 2010</td>
  <td class="ic3-mdx-result-cell-header">August 21 2010</td>
  <td class="ic3-mdx-result-cell-header">August 22 2010</td>
  <td class="ic3-mdx-result-cell-header">August 23 2010</td>
  <td class="ic3-mdx-result-cell-header">August 24 2010</td>
  <td class="ic3-mdx-result-cell-header">August 25 2010</td>
  <td class="ic3-mdx-result-cell-header">August 26 2010</td>
  <td class="ic3-mdx-result-cell-header">August 27 2010</td>
  <td class="ic3-mdx-result-cell-header">August 28 2010</td>
  <td class="ic3-mdx-result-cell-header">August 29 2010</td>
  <td class="ic3-mdx-result-cell-header">August 30 2010</td>
  <td class="ic3-mdx-result-cell-header">August 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Sep 2010</td>
  <td class="ic3-mdx-result-cell-header">September 1 2010</td>
  <td class="ic3-mdx-result-cell-header">September 2 2010</td>
  <td class="ic3-mdx-result-cell-header">September 3 2010</td>
  <td class="ic3-mdx-result-cell-header">September 4 2010</td>
  <td class="ic3-mdx-result-cell-header">September 5 2010</td>
  <td class="ic3-mdx-result-cell-header">September 6 2010</td>
  <td class="ic3-mdx-result-cell-header">September 7 2010</td>
  <td class="ic3-mdx-result-cell-header">September 8 2010</td>
  <td class="ic3-mdx-result-cell-header">September 9 2010</td>
  <td class="ic3-mdx-result-cell-header">September 10 2010</td>
  <td class="ic3-mdx-result-cell-header">September 11 2010</td>
  <td class="ic3-mdx-result-cell-header">September 12 2010</td>
  <td class="ic3-mdx-result-cell-header">September 13 2010</td>
  <td class="ic3-mdx-result-cell-header">September 14 2010</td>
  <td class="ic3-mdx-result-cell-header">September 15 2010</td>
  <td class="ic3-mdx-result-cell-header">September 16 2010</td>
  <td class="ic3-mdx-result-cell-header">September 17 2010</td>
  <td class="ic3-mdx-result-cell-header">September 18 2010</td>
  <td class="ic3-mdx-result-cell-header">September 19 2010</td>
  <td class="ic3-mdx-result-cell-header">September 20 2010</td>
  <td class="ic3-mdx-result-cell-header">September 21 2010</td>
  <td class="ic3-mdx-result-cell-header">September 22 2010</td>
  <td class="ic3-mdx-result-cell-header">September 23 2010</td>
  <td class="ic3-mdx-result-cell-header">September 24 2010</td>
  <td class="ic3-mdx-result-cell-header">September 25 2010</td>
  <td class="ic3-mdx-result-cell-header">September 26 2010</td>
  <td class="ic3-mdx-result-cell-header">September 27 2010</td>
  <td class="ic3-mdx-result-cell-header">September 28 2010</td>
  <td class="ic3-mdx-result-cell-header">September 29 2010</td>
  <td class="ic3-mdx-result-cell-header">September 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Q4 2010</td>
  <td class="ic3-mdx-result-cell-header">Oct 2010</td>
  <td class="ic3-mdx-result-cell-header">October 1 2010</td>
  <td class="ic3-mdx-result-cell-header">October 2 2010</td>
  <td class="ic3-mdx-result-cell-header">October 3 2010</td>
  <td class="ic3-mdx-result-cell-header">October 4 2010</td>
  <td class="ic3-mdx-result-cell-header">October 5 2010</td>
  <td class="ic3-mdx-result-cell-header">October 6 2010</td>
  <td class="ic3-mdx-result-cell-header">October 7 2010</td>
  <td class="ic3-mdx-result-cell-header">October 8 2010</td>
  <td class="ic3-mdx-result-cell-header">October 9 2010</td>
  <td class="ic3-mdx-result-cell-header">October 10 2010</td>
  <td class="ic3-mdx-result-cell-header">October 11 2010</td>
  <td class="ic3-mdx-result-cell-header">October 12 2010</td>
  <td class="ic3-mdx-result-cell-header">October 13 2010</td>
  <td class="ic3-mdx-result-cell-header">October 14 2010</td>
  <td class="ic3-mdx-result-cell-header">October 15 2010</td>
  <td class="ic3-mdx-result-cell-header">October 16 2010</td>
  <td class="ic3-mdx-result-cell-header">October 17 2010</td>
  <td class="ic3-mdx-result-cell-header">October 18 2010</td>
  <td class="ic3-mdx-result-cell-header">October 19 2010</td>
  <td class="ic3-mdx-result-cell-header">October 20 2010</td>
  <td class="ic3-mdx-result-cell-header">October 21 2010</td>
  <td class="ic3-mdx-result-cell-header">October 22 2010</td>
  <td class="ic3-mdx-result-cell-header">October 23 2010</td>
  <td class="ic3-mdx-result-cell-header">October 24 2010</td>
  <td class="ic3-mdx-result-cell-header">October 25 2010</td>
  <td class="ic3-mdx-result-cell-header">October 26 2010</td>
  <td class="ic3-mdx-result-cell-header">October 27 2010</td>
  <td class="ic3-mdx-result-cell-header">October 28 2010</td>
  <td class="ic3-mdx-result-cell-header">October 29 2010</td>
  <td class="ic3-mdx-result-cell-header">October 30 2010</td>
  <td class="ic3-mdx-result-cell-header">October 31 2010</td>
  <td class="ic3-mdx-result-cell-header">Nov 2010</td>
  <td class="ic3-mdx-result-cell-header">November 1 2010</td>
  <td class="ic3-mdx-result-cell-header">November 2 2010</td>
  <td class="ic3-mdx-result-cell-header">November 3 2010</td>
  <td class="ic3-mdx-result-cell-header">November 4 2010</td>
  <td class="ic3-mdx-result-cell-header">November 5 2010</td>
  <td class="ic3-mdx-result-cell-header">November 6 2010</td>
  <td class="ic3-mdx-result-cell-header">November 7 2010</td>
  <td class="ic3-mdx-result-cell-header">November 8 2010</td>
  <td class="ic3-mdx-result-cell-header">November 9 2010</td>
  <td class="ic3-mdx-result-cell-header">November 10 2010</td>
  <td class="ic3-mdx-result-cell-header">November 11 2010</td>
  <td class="ic3-mdx-result-cell-header">November 12 2010</td>
  <td class="ic3-mdx-result-cell-header">November 13 2010</td>
  <td class="ic3-mdx-result-cell-header">November 14 2010</td>
  <td class="ic3-mdx-result-cell-header">November 15 2010</td>
  <td class="ic3-mdx-result-cell-header">November 16 2010</td>
  <td class="ic3-mdx-result-cell-header">November 17 2010</td>
  <td class="ic3-mdx-result-cell-header">November 18 2010</td>
  <td class="ic3-mdx-result-cell-header">November 19 2010</td>
  <td class="ic3-mdx-result-cell-header">November 20 2010</td>
  <td class="ic3-mdx-result-cell-header">November 21 2010</td>
  <td class="ic3-mdx-result-cell-header">November 22 2010</td>
  <td class="ic3-mdx-result-cell-header">November 23 2010</td>
  <td class="ic3-mdx-result-cell-header">November 24 2010</td>
  <td class="ic3-mdx-result-cell-header">November 25 2010</td>
  <td class="ic3-mdx-result-cell-header">November 26 2010</td>
  <td class="ic3-mdx-result-cell-header">November 27 2010</td>
  <td class="ic3-mdx-result-cell-header">November 28 2010</td>
  <td class="ic3-mdx-result-cell-header">November 29 2010</td>
  <td class="ic3-mdx-result-cell-header">November 30 2010</td>
  <td class="ic3-mdx-result-cell-header">Dec 2010</td>
  <td class="ic3-mdx-result-cell-header">December 1 2010</td>
  <td class="ic3-mdx-result-cell-header">December 2 2010</td>
  <td class="ic3-mdx-result-cell-header">December 3 2010</td>
  <td class="ic3-mdx-result-cell-header">December 4 2010</td>
  <td class="ic3-mdx-result-cell-header">December 5 2010</td>
  <td class="ic3-mdx-result-cell-header">December 6 2010</td>
  <td class="ic3-mdx-result-cell-header">December 7 2010</td>
  <td class="ic3-mdx-result-cell-header">December 8 2010</td>
  <td class="ic3-mdx-result-cell-header">December 9 2010</td>
  <td class="ic3-mdx-result-cell-header">December 10 2010</td>
  <td class="ic3-mdx-result-cell-header">December 11 2010</td>
  <td class="ic3-mdx-result-cell-header">December 12 2010</td>
  <td class="ic3-mdx-result-cell-header">December 13 2010</td>
  <td class="ic3-mdx-result-cell-header">December 14 2010</td>
  <td class="ic3-mdx-result-cell-header">December 15 2010</td>
  <td class="ic3-mdx-result-cell-header">December 16 2010</td>
  <td class="ic3-mdx-result-cell-header">December 17 2010</td>
  <td class="ic3-mdx-result-cell-header">December 18 2010</td>
  <td class="ic3-mdx-result-cell-header">December 19 2010</td>
  <td class="ic3-mdx-result-cell-header">December 20 2010</td>
  <td class="ic3-mdx-result-cell-header">December 21 2010</td>
  <td class="ic3-mdx-result-cell-header">December 22 2010</td>
  <td class="ic3-mdx-result-cell-header">December 23 2010</td>
  <td class="ic3-mdx-result-cell-header">December 24 2010</td>
  <td class="ic3-mdx-result-cell-header">December 25 2010</td>
  <td class="ic3-mdx-result-cell-header">December 26 2010</td>
  <td class="ic3-mdx-result-cell-header">December 27 2010</td>
  <td class="ic3-mdx-result-cell-header">December 28 2010</td>
  <td class="ic3-mdx-result-cell-header">December 29 2010</td>
  <td class="ic3-mdx-result-cell-header">December 30 2010</td>
  <td class="ic3-mdx-result-cell-header">December 31 2010</td>
  <td class="ic3-mdx-result-cell-header">2011</td>
  <td class="ic3-mdx-result-cell-header">Q1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jan 2011</td>
  <td class="ic3-mdx-result-cell-header">January 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Feb 2011</td>
  <td class="ic3-mdx-result-cell-header">February 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Mar 2011</td>
  <td class="ic3-mdx-result-cell-header">March 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q2 2011</td>
  <td class="ic3-mdx-result-cell-header">Apr 2011</td>
  <td class="ic3-mdx-result-cell-header">April 1 2011</td>
  <td class="ic3-mdx-result-cell-header">May 2011</td>
  <td class="ic3-mdx-result-cell-header">May 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Jun 2011</td>
  <td class="ic3-mdx-result-cell-header">June 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q3 2011</td>
  <td class="ic3-mdx-result-cell-header">Jul 2011</td>
  <td class="ic3-mdx-result-cell-header">July 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Aug 2011</td>
  <td class="ic3-mdx-result-cell-header">August 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Sep 2011</td>
  <td class="ic3-mdx-result-cell-header">September 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Q4 2011</td>
  <td class="ic3-mdx-result-cell-header">Oct 2011</td>
  <td class="ic3-mdx-result-cell-header">October 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Nov 2011</td>
  <td class="ic3-mdx-result-cell-header">November 1 2011</td>
  <td class="ic3-mdx-result-cell-header">Dec 2011</td>
  <td class="ic3-mdx-result-cell-header">December 1 2011</td>
</tr>
<tr>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>3</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>3</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>3</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>1</td>
 <td></td>
 <td>2</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>2</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>2</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>2</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>2</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>1</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>1</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>1</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td>1</td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
 <td></td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    {Descendants([Geography].[Geo].[France],[Geography].[Geo].[Country],SELF_AND_AFTER)+Descendants([Geography].[Geo].[Spain],[Geography].[Geo].[Country],SELF_AND_AFTER)}
    *
    {Descendants([Time].[Calendar].[Year].[2010],[Time].[Calendar].[Year],SELF_AND_AFTER)+Descendants([Time].[Calendar].[Year].[2011],[Time].[Calendar].[Year],SELF_AND_AFTER)}
     on 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
SELECT
    Expand( {[Geography].[Geo].[Country].members} * {[Time].[Calendar].[Year].[2010],[Time].[Calendar].[Year].[2011]}) on 0
FROM
    [Sales]
FILTERBY {[Geography].[Geo].[France],[Geography].[Geo].[Spain]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Expand(tuple_set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a set with all tuples expanded, with self and all descendants.

**Query**

```
WITH
  MEMBER T as count( Expand( ([Geography].[Geo].[France],[Time].[Calendar].[Jan 2010]) ) )
SELECT
  T on 0
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">T</td>
</tr>
<tr>
 <td>64</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
 MEMBER T AS  count({[Geography].[Geo].[France]}+{[Geography].[Geo].[Paris]}) * count({[Time].[Calendar].[Jan 2010]}+{[Time].[Calendar].[Jan 2010].children})
SELECT
    T on 0
FROM [Sales]
```


 
</div>

                                                                         

### See Also


[Descendants](Descendants.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
