## Exists

Returns the first set filtered by an existing rule based on the second set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |set-expression |zero-one | |



### Return

```
set
```



### Description

Returns a set of existing tuples.

A single set as parameter :

This function filters out tuples that do not exists. A tuple does not exist if it contains members of the same dimension but different hierarchies whose combination is always empty by construction. For example the [Geography] dimension defines two hierarchies: [Geo] and [Economy]. The both have a level country; by construction the tuple ([Geo].[United States], [Economy].[Spain]) is not possible.

Two sets as parameter :

This function returns the tuples in the first set that are non empty when evaluated across the tuples of the second set.

Note, this function is faster than his equivalent NonEmpty() as it can be solved without querying the fact tables.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Exists(tuple_set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all set members that exists, hierarchy wise, from the tuple set.

In our example, [Geo].[France] and [Economy].[Canada] does not exist (by dimension construction)

**Query**

```
WITH
    MEMBER ExistingCountries as count ( exists( {([Geography].[Geo].[All Regions].[Europe].[France],[Geography].[Economy].[Country].[Canada])}) )
SELECT
    ExistingCountries on 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">ExistingCountries</td>
</tr>
<tr>
 <td>0</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER ExistingCountries as count ( { ( [Geography].[Geo].[All Regions].[Europe].[France], [Geography].[Economy].[Country].[Canada] ) } )
SELECT
    ExistingCountries on 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER ExistingCountries as 0
SELECT
    ExistingCountries on 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Exists(tuple_set,tuple_set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members of the first set that exists, dimension wise, for at least one combination with the members of the second set.

In our example, the query returns only [Canada] as there is no [Spain] in [America]

**Query**

```
exists( {[Geography].[Economy].[Canada],[Geography].[Economy].[Spain] },[Geography].[Geo].[America].children)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Economy].[Country].[Canada]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Economy].[Country].[Canada]
```


 
</div>

                                                                                                            

### See Also


[IsEmpty](IsEmpty.md)

[NonEmpty](NonEmpty.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
