## Except

Returns a set with all elements from the first set that do not belong to the second set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression | | |
| |set-expression | | |
| |ALL |zero-one | |



### Return

```
set
```



### Description

Returns a set of all elements from the first set that do not belong to the second set.

Except( {A,B,C}, {A,F,G} ) -> {B,C}

Equivalent syntax : {A,B,C} - {A,F,G}

The ALL flag parameter specifies that the function should retain duplicates; if the ALL flag is not set then all the duplicates are removed from the result set.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except(member-set,member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all members from the first set that are not present in the second. Duplicates are removed.

In our example, a single instance of [America] is returned.

**Query**

```
Except({[Geography].[Geo].[Europe],[Geography].[Geo].[America],[Geography].[Geo].[America]},[Geography].[Geo].[Europe])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Geography].[Geo].[America] }
```


**Assertion : MDX Equals**

```
// Equivalent to the operator -
{[Geography].[Geo].[Europe],[Geography].[Geo].[America],[Geography].[Geo].[America]} - {[Geography].[Geo].[Europe]}
```


**Assertion : MDX Equals**

```
// Duplicates are removed
Except({[Geography].[Geo].[Europe],[Geography].[Geo].[America],[Geography].[Geo].[America]},[Geography].[Geo].[Europe])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except(tuple-set,tuple-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all tuples from the first set that are not present in the second.

In our example, ([Geography].[Geo].[Europe],[Product].[Prod].[Corporate]) is returned.

**Query**

```
Except({[Geography].[Geo].[Europe],[Geography].[Geo].[America]} * [Product].[Prod].[Corporate],{([Geography].[Geo].[America],[Product].[Prod].[Corporate])} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[Europe], [Product].[Prod].[Licence].[Corporate] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{([Geography].[Geo].[Europe],[Product].[Prod].[Corporate])}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except(member-set,member-set,ALL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all elements from the first set that are not present in the second. Duplicated elements are kept.

In our example, two instances of {[America], [America]} are returned.

**Query**

```
Except({[Geography].[Geo].[Europe],[Geography].[Geo].[America],[Geography].[Geo].[America]},{[Geography].[Geo].[Europe]},ALL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America],[Geography].[Geo].[America]}
```


**Assertion : MDX Equals**

```
Except({[Geography].[Geo].[Europe],[Geography].[Geo].[America],[Geography].[Geo].[America]},{[Geography].[Geo].[Europe]},all/*lower case*/)
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applying except to a single set returns an error.

**Query**

```
Except( [Geography].[Geo].members )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

Except() : unexpected number of parameters '1' (expected:'3,2')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applying except to empty sets results in an empty set. Remember null is implicitly converted to an empty set.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Except({},{})
```


**Assertion : MDX Equals**

```
Except(null,null)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except(member-set,member-set) - members with different dimensionality

</div>

<div class="ic3-mdx-example-body" style="display:none">

Except can only be applied to sets with the same dimensionality. Therefore all members/tuples should contain the same hierarchies.

**Query**

```
Except( [Geography].[Geo].members, {[Geography].[Economy].DefaultMember} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Geography].[Geo]' - '[Geography].[Economy]'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except(tuple-set,tuple-set) - tuples with different dimensionality

</div>

<div class="ic3-mdx-example-body" style="display:none">

Except can only be applied to sets with the same dimensionality. This will also happen if tuples have the same hierarchies but in a different order

**Query**

```
Except(
{ ( [Geography].[Geo].[Spain], [Time].[Calendar].[2010] ) },
{ ( [Time].[Calendar].[2010] , [Geography].[Geo].[Spain] ) }
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Geography].[Geo],[Time].[Calendar]' - '[Time].[Calendar],[Geography].[Geo]'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Except(member-set,member-set,INVALID_FLAG)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An invalid flag generates an error.

**Query**

```
Except( {}, {}, INVALID_FLAG)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Except() : argument (2) type mismatch: expected:'[ALL]', got:'function option(INVALID_FLAG)'</td></tr></table>


 
</div>

                                                                         

### See Also


[Intersect](Intersect.md)

[Union](Union.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
